docker-grid Cookbook
==================

This cookbook sets up Docker engine.

## Contents

- [Requirements](#requirements)
  - [platforms](#platforms)
  - [packages](#packages)
- [Attributes](#attributes)
- [Usage](#usage)
  - [Recipes](#recipes)
    - [docker-grid::default](#docker-griddefault)
    - [docker-grid::engine](#docker-gridengine)
  - [Role Examples](#role-examples)
- [License and Authors](#license-and-authors)

## Requirements

### platforms
- CentOS, Red Hat Enterprise Linux >= 7.2
- Ubuntu >= 14.04

### packages
- none.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['docker-grid']['apt_repo']['url']`|String||`'https://apt.dockerproject.org/repo'`|
|`['docker-grid']['apt_repo']['keyserver']`|String||`'hkp://p80.pool.sks-keyservers.net:80'`|
|`['docker-grid']['apt_repo']['recv-keys']`|String||`'58118E89F3A912897C070ADBF76221572C52609D'`|
|`['docker-grid']['yum_repo']['baseurl']`|String||`'https://yum.dockerproject.org/repo/main/centos/$releasever/'`|
|`['docker-grid']['yum_repo']['gpgcheck']`|String|`'0'`: disabled, `'1'`: enabled.|`'1'`|
|`['docker-grid']['yum_repo']['gpgkey']`|String||`'https://yum.dockerproject.org/gpg'`|
|`['docker-grid']['engine']['version_on_centos']`|String|Docker version for CentOS.|`'1.11.2-1'`|
|`['docker-grid']['engine']['version_on_ubuntu']`|String|Docker version for Ubuntu.|`'1.11.2-0'`|
|`['docker-grid']['engine']['version']`|String|Docker 1.9.x - 1.11.x is recommended for stability reasons. Note: this **default** value is overwritten by the `version_on_{centos or ubuntu}`.|See default.rb|
|`['docker-grid']['engine']['storage-driver_on_centos']`|String|Docker storage driver (overlay, devicemapper, ...) for CentOS.|`'overlay'`|
|`['docker-grid']['engine']['storage-driver_on_ubuntu']`|String|Docker storage driver (aufs, overlay, ...) for Ubuntu.|`'aufs'`|
|`['docker-grid']['engine']['storage-driver']`|String||See default.rb|
|`['docker-grid']['engine']['daemon_extra_options']`|String|ref. `docker daemon --help`.|`'-H fd://'`|

## Usage

### Recipes

#### docker-grid::default

This recipe does nothing.

#### docker-grid::engine

This recipe sets up Docker engine.

### Role Examples

- `roles/docker.rb`

```ruby
name 'docker'
description 'Docker Engine'

run_list(
  'recipe[docker-grid::engine]',
)

override_attributes(
  'docker-grid' => {
    'engine' => {
      'version_on_centos' => '1.11.2-1',
      'version_on_ubuntu' => '1.11.2-0',
      'storage-driver_on_centos' => 'overlay',
      'storage-driver_on_ubuntu' => 'overlay',  # default: aufs
      'daemon_extra_options' => '-H fd://',
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
