/**
 * \file fract_x86.h
 * \brief Compatible typedef & macro to enable simulation in x86 env.
 * \details
 * This include file provides the compatible macros for x86. These macro substitutes the
 * 32bit fixed point macro set fract.h.
 */

#ifndef _FRACT_X86_H_
#define _FRACT_X86_H_

typedef long long int fract32;

#define SATP(x)  (((x)>2147483647LL)?(2147483647LL):x)
#define SAT(x) (((x)>=-2147483648LL)?(SATP(x)):-2147483648LL)

#define mult_fr1x32x32(x,y) SAT(((fract32)(x)*(fract32)(y)/*+0x40000000*/)>>31)

#define sub_fr1x32(x,y) SAT((fract32)(x)-(y))

#define add_fr1x32(x,y) SAT((fract32)(x)+(y))

#endif // _FRACT_X86_H_
