//
//  LFApp.m
//  LetterFix2
//
//  Created by kuri on 10/02/26.
//  Copyright 2010-2021 kuri. All rights reserved.
//

#import "LFApp.h"
#import "LFMenu.h"

@implementation LFApp

- (instancetype) init
{
    self = [super init];
    
    if (self != nil) {
	userDefaults = [NSUserDefaults standardUserDefaults];
	
        infodict       = [NSBundle mainBundle].infoDictionary;
        mailVersion    = infodict[@"CFBundleVersion"];
        lastknow       = [userDefaults stringForKey:@"LetterFixLastKnownBundleVersion"];
        
	if (lastknow && [mailVersion compare:lastknow] != NSOrderedSame) {
	    NSAlert *alert = [[NSAlert alloc] init];
	    [alert setMessageText:@"LetterFix plug-in"];
	    [alert setInformativeText:@"Mail.app が変更されました。\n"
	     @"Mail.app のアップデート等により，プラグインの動作に問題が発生する場合は，アンインストールしてください。\n"
         @"プラグインは、Mail.app の一般環境設定から無効にできます。\n"
	     @"なお、このプラグインは通常 /Library/Mail/Bundles/ にインストールされています。"];
	    [alert setAlertStyle:NSInformationalAlertStyle];
	    [alert runModal];
	    [alert release];
	}
	
        SInt32 systemVersionMajor, systemVersionMinor;
        if ((Gestalt(gestaltSystemVersionMajor, &systemVersionMajor) == noErr) &&
	    (Gestalt(gestaltSystemVersionMinor, &systemVersionMinor) == noErr)) {
            if (systemVersionMajor == 10) {
                switch (systemVersionMinor) {
                    case 9:
                        version = LF_Mavericks;
                        break;
                    case 10:
                        version = LF_Yosemite;
                        break;
                    case 11:
                        version = LF_ElCapitan;
                        break;
                    case 12:
                        version = LF_Sierra;
                        break;
                    case 13:
                        version = LF_HighSierra;
                        break;
                    case 14:
                        version = LF_Mojave;
                        break;
                    case 15:
                        version = LF_Catalina;
                        break;
                    default:
                        version = LF_Unknown;
                        break;
                }
            } else if (systemVersionMajor == 11) {
                version = LF_BigSur; // 11.x.y
            } else if (systemVersionMajor == 12) {
                version = LF_Monterey; // 12.x.y
            } else {
                version = LF_Unknown;
            }
        } else {
            version = LF_Unknown;
        }
        
        if (version != LF_Unknown) {
            [userDefaults setObject:mailVersion forKey:@"LetterFixLastKnownBundleVersion"];
	
            self.isActive = ![userDefaults boolForKey:@"LetterFixDisabled"];
            self.shouldFixOsDependents = ![userDefaults boolForKey:@"LetterFixOsDependentFixDisabled"];
            self.shouldFixParenSymbols = ![userDefaults boolForKey:@"LetterFixParenSymbolFixDisabled"];
            self.shouldNotFixSomeParenSymbols = [userDefaults boolForKey:@"LetterFixSomeParenSymbolFixEnabled"];
            self.shouldFixAllLetters = ![userDefaults boolForKey:@"LetterFixAllLetterFixDisabled"];
            self.shouldAppendCodeInfo = [userDefaults boolForKey:@"LetterFixDoAppendCodeInfo"];
            self.operationModeOnLoad = (int)[userDefaults integerForKey:@"LetterFixOperationAtOpen"];
            if (version == LF_HighSierra || version == LF_Mojave ||
                version == LF_Catalina || version == LF_BigSur ||
                version == LF_Monterey )
                self.shouldCheckSubject = [userDefaults integerForKey:@"LetterFixCheckSubjectEnabled"];
            else
                self.shouldCheckSubject = ![userDefaults integerForKey:@"LetterFixCheckSubjectDisabled"];
            self.shouldCheckOnSave = [userDefaults integerForKey:@"LetterFixCheckOnSaveEnabled"];
            self.shouldIgnoreZeroWidthSpace = [userDefaults boolForKey:@"LetterFixIgnoreZeroWidthSpace"];
            menu = [[LFMenu alloc] initWithApp:self];
            [menu inject];

            if (^{
                for (NSString *lang in [NSLocale preferredLanguages])
                    if ([lang hasPrefix:@"ja"]) return NO;
                return YES;
            }()) {
                NSAlert *alert = [[NSAlert alloc] init];
                [alert setMessageText:@"LetterFix plug-in"];
                [alert setInformativeText:@"システム環境設定＞言語とテキスト(Language & Text)内の言語リストに"
                 @"「日本語」が存在しません。この状態では Letter-fix は動作せず、すべての日本語メールはUTF-8で送信されます。"
                 @"言語リストに日本語を加えてください。なお順序は問いません。"];
                [alert setAlertStyle:NSInformationalAlertStyle];
                [alert runModal];
                [alert release];
                isActive = FALSE;
                [[menu onoffMenuItem] setState:FALSE];
            }
        } else {
            NSAlert *alert = [[NSAlert alloc] init];
            [alert setMessageText:@"LetterFix plug-in"];
            [alert setInformativeText:@"このバージョンのmacOSには対応していません。アンインストールしてください。"];
            [alert setAlertStyle:NSInformationalAlertStyle];
            [alert runModal];
            [alert release];
        }
    }
    return self;
}

- (BOOL) isActive
{
    return (isActive);
}

- (void) setIsActive:(BOOL)active
{
    [userDefaults setBool:!active forKey:@"LetterFixDisabled"];
    isActive = active;
}

- (BOOL) shouldFixOsDependents
{
    return (flagFixOsDependents);
}

- (void) setShouldFixOsDependents:(BOOL)active
{
    [userDefaults setBool:!active forKey:@"LetterFixOsDependentFixDisabled"];
    flagFixOsDependents = active;
}

- (BOOL) shouldFixParenSymbols
{
    return (flagFixParenSymbols);
}

- (void) setShouldFixParenSymbols:(BOOL)active
{
    [userDefaults setBool:!active forKey:@"LetterFixParenSymbolFixDisabled"];
    flagFixParenSymbols = active;
}

- (BOOL) shouldNotFixSomeParenSymbols
{
    return (flagNotFixSomeParenSymbols);
}

- (void) setShouldNotFixSomeParenSymbols:(BOOL)active
{
    [userDefaults setBool:active forKey:@"LetterFixSomeParenSymbolFixEnabled"];
    flagNotFixSomeParenSymbols = active;
}

- (BOOL) shouldFixAllLetters
{
    return (flagFixAllLetters);
}

- (void) setShouldFixAllLetters:(BOOL)active
{
    [userDefaults setBool:!active forKey:@"LetterFixAllLetterFixDisabled"];
    flagFixAllLetters = active;
}

- (BOOL) shouldAppendCodeInfo
{
    return (flagAppendCodeInfo);
}

- (void) setShouldAppendCodeInfo:(BOOL)active
{
    [userDefaults setBool:active forKey:@"LetterFixDoAppendCodeInfo"];
    flagAppendCodeInfo = active;
}

- (int) operationModeOnLoad
{
    return (operationModeOnLoad);
}

- (void) setOperationModeOnLoad:(int)value
{
    [userDefaults setInteger:value forKey:@"LetterFixOperationAtOpen"];
    operationModeOnLoad = value;
}

- (BOOL) shouldCheckSubject
{
    return (flagCheckSubject);
}

- (void) setShouldCheckSubject:(BOOL)active
{
    [userDefaults setBool:active forKey:@"LetterFixCheckSubjectEnabled"];
    [userDefaults setBool:!active forKey:@"LetterFixCheckSubjectDisabled"];
    flagCheckSubject = active;
}

- (BOOL) shouldCheckOnSave
{
    return (flagCheckOnSave);
}

- (void) setShouldCheckOnSave:(BOOL)active
{
    [userDefaults setBool:active forKey:@"LetterFixCheckOnSaveEnabled"];
    flagCheckOnSave = active;
}

- (BOOL) shouldIgnoreZeroWidthSpace
{
    return (flagIgnoreZeroWidthSpace);
}

- (void) setShouldIgnoreZeroWidthSpace:(BOOL)active
{
    [userDefaults setBool:active forKey:@"LetterFixIgnoreZeroWidthSpace"];
    flagIgnoreZeroWidthSpace = active;
}

@synthesize version;
@synthesize mailVersion;

@end
