//
//  LFApp.h
//  LetterFix2
//
//  Created by kuri on 10/02/26.
//  Copyright 2010-2021 kuri. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AppKit/AppKit.h>
//#import "LFMenu.h"

#define LETTERFIX_VERSION "3.1.4"

enum LFversion {
    LF_Unknown = -1,
    LF_Mavericks = 1009,
    LF_Yosemite  = 1010,
    LF_ElCapitan = 1011,
    LF_Sierra    = 1012,
    LF_HighSierra= 1013,
    LF_Mojave    = 1014,
    LF_Catalina  = 1015,
    LF_BigSur    = 1100,
    LF_Monterey  = 1200,
};

@interface LFApp : NSObject {
    BOOL isActive;
    BOOL flagFixOsDependents;
    BOOL flagFixParenSymbols;
    BOOL flagNotFixSomeParenSymbols;
    BOOL flagFixAllLetters;
    BOOL flagAppendCodeInfo;
    int  operationModeOnLoad;
    BOOL flagCheckSubject;
    BOOL flagCheckOnSave;
    BOOL flagIgnoreZeroWidthSpace;
    id menu;
    
    NSUserDefaults *userDefaults;
    NSDictionary *infodict;
    id mailVersion;
    id lastknow;
    NSInteger version;
}
- (instancetype) init;
@property BOOL isActive;
@property BOOL shouldFixOsDependents;
@property BOOL shouldFixParenSymbols;
@property BOOL shouldNotFixSomeParenSymbols;
@property BOOL shouldFixAllLetters;
@property BOOL shouldAppendCodeInfo;
@property int  operationModeOnLoad;
@property BOOL shouldCheckSubject;
@property BOOL shouldCheckOnSave;
@property BOOL shouldIgnoreZeroWidthSpace;
@property(readonly) NSInteger version;
@property(readonly) id mailVersion;
@end
