var stgObjects = {
	
	// BlockClass : 普通のブロック。 引数に画像名を指定
    a : {base:BlockClass,args:'1241.png'},
    d : {base:BlockClass,args:'1248.png'},
    e : {base:BlockClass,args:'1244.png'},
    n : {base:HiddenBlockClass,args:'1244.png', prop:{collidingMask:CollideRight, collidingExcludeMask:(CollideLeft | CollideTop | CollideBody)}},
    p : {base:HiddenBlockClass,args:'1241.png', prop:{collidingMask:CollideBottom, collidingExcludeMask:(CollideLeft |CollideRight| CollideTop)}},
    f : {base:BlockClass,args:'1245.png'},
    o : {base:BlockClass,args:'palm_body.png'},
    // SlopeBlockClass : 当たり判定が斜めのブロック。
    // 引数 : 画像名, 当たり判定領域左側の開始位置のブロック上辺からの高さ, 当たり判定領域右側の...
    //        たとえば、この例のように 0, 32 と指定すれば右下がりの坂になり、32, 0と指定すれば左下がり、 16, 16と指定すれば半分の高さの長方形になる
    // enableBlockMode : 当たり判定領域をデバッグ表示する。
    b : {base:SlopeBlockClass,args:['1243.png',-1,33],prop:{enableDebugMode:true}},
    g : {base:SlopeBlockClass,args:['1242.png',33,-1],prop:{enableDebugMode:true}},
    h : {base:SlopeBlockClass,args:['1246.png',32,0],prop:{enableDebugMode:true}},
    i : {base:SlopeBlockClass,args:['1247.png',0,32],prop:{enableDebugMode:true}},
    j : {base:SlopeBlockClass,args:['1244.png',600,600],prop:{enableDebugMode:true}},
    k : {base:SlopeBlockClass,args:['1246.png',600,600],prop:{enableDebugMode:true}},
    l : {base:SlopeBlockClass,args:['1247.png',600,600],prop:{enableDebugMode:true}},
    m : {base:SlopeBlockClass,args:['1241.png',600,600],prop:{enableDebugMode:true}},
    B:  {base:EnemyCharacterClass_Frog,args:'null'},
    J :  {base:EnemyCharacterClass_AntigravityTaraba,args:'null'},
   z:  {base:EnemyCharacterClass_Pirania,args:'null'},
    // FreeItemClass : キャラが取得するとコールバックが実行されるアイテム
    // callback : 誰かに取得されたときに発生するコールバック。アタックした人、そのアタック直後のx, y座標が引数にセットされる。
    // times : 取得できる回数で、-1で無限。
    c : {base:FreeItemClass,args:["1248.png",callBack],prop:{times:1}},
    
    // 何もブロックを置かない位置のためにかならずこのようなエントリーを記述
    _ : null
};

// FreeItemClassのコールバック
function callBack(obj, obj_x, obj_y)
{
	if(obj instanceof MainCharacterClass){

	}
}

var stgInfo = {
    width: 6400,				//横サイズ
    height: 480,				//縦サイズ
    background: "back2.png",	
    BGM: "umi.mp3",  
    waterLevel: 352,

};

with(stgObjects){
	var tbl = [
		[ , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , ,a,c,c,a,c,c,a,c,a,a, , , , , , , , , , , , , , , , , , , , , ],
		[ , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , ,_,_, ,_, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , ,a,c,a,a,c,c,a,c,c,a, , , , , , , , , , , , , , , , , , , , , ],
		[ , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, ,_,_,_,_,_,B, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , ,a,c,c,a,c,c,a,c,c,a, , , , , , , , , , , , , , , , , , , , , ],
		[ , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, ,_,_,_,_,_,B, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , ,a,c,c,a,c,c,a,c,c,c, , , , , , , , , , , , , , , , , , , , , ],
		[ , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,_, , , ,o, , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, ,_,_,_,_,_,B, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , ,g,a,a,a,a,b, , , , , , , , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , ,c,a,c,a,c,c,a,c,c,c, , , , , ,B, , , , , ,_,_,_,_,_,_, , ,_,_],
		[ , , , ,_, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , ,o, , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, ,_,_,_,_,_,B, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , ,a,m,m,m,m,m,a,a,b, , , , , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , ,_,c,c,a,c,c,a,c,c,c, , , , , ,B, , ,_, ,_,_,_,_,_,_,_,_,_,_,_],
		[ , , , , , , , , , , , , , ,_, , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , ,o, , , , , , , , , , , , , , , , , , , , , , , , , , , ,_,o,_,_,_,_,_,_,_,_,_,_,_,_, , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , ,p, , , ,a,m,m,m,m,m,a,a,m,b, , , , , , , , ,_,_, , , , , , ,o, , , , , , , , , , , , , , , , , , , ,_,c,c,a,c,c,a,c,a,a, , ,g,a,a,a,a,b, , ,_,_,_,_,_,_,_,_,_,_,_],
		[ , , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , ,B,o, , , , , , , , , , , , , , , , , , , , , , , , , , , ,_,o,_,_,_,g,a,a,a,a,a,a,b,_, , , , , , , , , , , , , , , , , , , , , , , , , , , , , ,o, , , , , , ,a,a,a,a,a,a,a,a,a,a,_, , , , , , , ,_,_,_,_,_, , , ,o, , , , , , , , , , , , , , , , , , , ,c,a,a,a,c,c,a,c,a,a, , ,a,a,a,a,a,a,_,_,_,_,_,_,_,_,_,_,_,_,_],
		[ , , , , , , , ,_,p, , , , ,o, , , , , , , , , , , , , , , , , , , , , , , ,g,a,a,a,a,a,d,a,b, , , , , , , , , , , , ,B, , , , , , , , , , , , , ,_,o,_,_,g,d,d,d,d,d,a,a,a,a,b, , , , , , , , , , , , , , , , ,B,B,B, , , , , , , , , ,o, , , , , , ,a,a,a,a,a,a,a,a,a,m,b, , , , , , ,_,_,_,_,_,_,_, ,c,c,c,m,b, , , , , , , , , , ,B, , ,p, , ,a,a,a,a,c,c,a,c,a,a, , ,a,a,a,a,a,a, , ,_,_,_,_,_,_,_,_,_,_,_],
		[b, , , , , , , , , , , , , ,o, , , , , , , , , , , , , , , , , , , , ,g,a,a,m,m,m,m,m,m,m,m,m,a,a,a,a,b, , , , , , , ,B, , , , , , , , , , , , , ,_,o,_,g,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,d,a,d,d,d,b,_, , ,g,a,a,a,a,a,b, , , , ,_,g,a,a,a,a,b, , , , ,a,a,a,a,a,a,a,a,a,m,m, , , ,g,a,a,a,a,a,a,b,_,_,g,c,c,c,m,a,a,b,_, , , , , ,g,b,B, , , , , ,a,a,a,a,c,c,a,c,c,c, , ,a,a,a,a,a,a, ,_,_,_,_,_,_,_,_,_,_,_, ],
		[a,a,a,b, , , , ,_, , , ,_,g,a,b, , , , , , , ,_,_,g,a,a,a,a,a,a,a,a,a,a,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,b,_,_,_,g,a,a,a,b, , , , , , , , , , , , ,g,a,a,a,a,a,d,d,a,a,a,a,a,a,_,_,_,_,_,d,d,d,d,d,d, , , ,a,a,a,a,a,a,a, , , , ,g,a,a,a,a,a,a, , , , ,a,m,m,m,m,a,a,a,m,m,m, , , ,a,a,a,a,a,a,a,a,_,_,a,a,a,a,a,a,a,a,_,_, , ,_,g,a,a,b, , , , , ,a,a,a,a,c,c,a,c,c,c, , ,a,a,a,a,a,a, , ,_,_,g,a,a,a,a,a,a,a,a],
		[e,e,e,e,i,_,_,_,_,_,_,_,h,e,e,e,i,J,_,_,_,_,_,_,h,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,e,_,_,_,e,e,e,e,e,_,_,_,_,_,_,_,_,_,_,_,_,e,e,e,e,e,e,e,e,e,e,e,e,e,_, , , , , ,e,e,e,e,e, , , , ,e,e,e,e,e,e,e, , , , ,e,e,e,e,e,e,e, , , , ,e,e,e,e,e,e,e,e,e,e,e, , , ,f,e,e,e,f,f,e,f, , ,e,e,e,e,e,e,e,e,_, , , ,h,e,e,e,e,i, , , , ,e,e,e,e,j,j,e,e,e,e, , ,f,e,e,e,e,e, , ,_,_,j,j,j,j,j,j,j,j,j],
		[e,e,e,e,e,i,_,_,_,_,_,h,e,e,f,e,e,e,e,i,_,_,_,h,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,e, , , , , , , , , , ,h,e,e,e,e,e,i, , , , , , , ,_,e,e,e,e,_,_,_,_, , ,h,e,i, ,_,e,e,e, , , , , , ,e,e,e,e,e, , , , , , ,e,e,e,e,e,e, , , , ,e,e,e,e,e,e,e,e,e,e,e, , , , , , , , , , , , , , ,e,e,e,e,e,e, , , , ,h,e,e,e,e,e,e,i, , , ,e,e,e,e,j,j,e,f,e,e, , ,e,e,e,e,e,e, , ,_,_,j,j,j,j,j,j,j,j,j],
		[e,e,e,e,e,e,_,_,z,_,h,e,e,e,e,e,e,e,e,e,i,_,h,n,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,j,e,J,J, , , , , ,J, ,h,j,e,e,e,e,e,j,i, , , , , , , , , , , , , , , , ,h,e,e,e, , ,_,e, , , , , , , , , , , , , , , , , , , ,e,e,e,e, , , , , ,e,e,e,e,e,e,e,e,e,e,e,l, , , ,z, , , ,z, , , , ,z, , ,z, , ,z, , , ,h,e,e,e,e,e,e,e,e,i, , ,e,e,e,e,j,j,e,e,e,e, , ,e,e,e,f,e,e, , ,_,_,j,j,j,j,j,j,j,j,j],
		[e,e,f,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,j,e,e,j,e,e,e,e,e,e,e,e,e,e,e,e,e,e,e,j,e,e,e,f,e,e,e,e,e,e,i,_,_,h,e,e,e,e,e,e,e,e,e,e,j,j,e,e,e,e,e,i, , , , , , ,h,e,e,e,e,e,e,e,i, , , , , , , , , , , ,_,_, , , , , , , , , , , , , , , , , , ,e,e,e,e,e,e,e,e,e,e,e,j,j,j,j,j,l, , , , , , , , , , , , , , , ,h,e,e,e,e,e,e,e,e,e,e,e,i, ,e,e,e,e,j,j,e,e,e,e, , ,e,f,e,e,e,e, , ,_,_,j,j,j,j,j,j,j,j,j]
	];
}

//約束事
var stage = new PCDSLStageClass(stgInfo, tbl);

stage.runStage = function(){
	PCDSLStageClass.prototype.runStage.apply(this, []);

	
var msg1 = new MessageItemClass(stage, ["この看板を読んだあなたは、そろそろ覚悟を決めたほうがいい。\n...なぜかって??\nそれは少し先にすすもうとしてみればわかるよ。\n"]);
msg1.origin.x = 3648;
msg1.origin.y = 256;
stage.addStageObject(msg1);

var leaf = new BlockClass(stage, ["palm_leaf.png",]);

leaf.size.x = 140;
leaf.size.y = 140;
leaf.origin.x = 390;
leaf.origin.y =124;
leaf.collisionMargin.top = 900;
leaf.collisionMargin.right = 0;
stage.addStageObject(leaf);

var leaf1 = new BlockClass(stage, ["palm_leaf.png",]);

leaf1.size.x = 140;
leaf1.size.y = 140;
leaf1.origin.x = 1250;
leaf1.origin.y =60;
leaf1.collisionMargin.top = 900;
leaf1.collisionMargin.right = 0;
stage.addStageObject(leaf1);

var leaf2 = new BlockClass(stage, ["palm_leaf.png",]);

leaf2.size.x = 140;
leaf2.size.y = 140;
leaf2.origin.x = 1385;
leaf2.origin.y =30;
leaf2.collisionMargin.top = 900;
leaf2.collisionMargin.right = 0;
stage.addStageObject(leaf2);

var cover = new BlockClass(stage, ["1245.png",]);

cover.size.x = 32;
cover.size.y = 32;
cover.origin.x = 736;
cover.origin.y =416;
cover.collisionMargin.top =900;

stage.addStageObject(cover);






var e1 = new EnemyCharacterClass(stage, [["kani3.png","kani2.png","kani1.png","kani2.png",]]);
	e1.size.x = 40;
	e1.size.y=  40;
	e1.origin.x =930;
	e1.origin.y =0;
	e1.chasingRange = 300;
	e1.collisionMargin.top = 20;
	e1.hurt = 0
        e1.movingVelocity = 50;
        e1.touchDamage = 20;
        stage.addStageObject(e1);
        
        var e2 = new EnemyCharacterClass(stage, [["kani3.png","kani2.png","kani1.png","kani2.png",]]);
	e2.size.x = 40;
	e2.size.y=  40;
	e2.origin.x =990;
	e2.origin.y =0;
	e2.chasingRange = 300;
	e2.collisionMargin.top = 20;
	e2.hurt= 0;
        e2.movingVelocity = 50;
        e2.touchDamage = 20;
        stage.addStageObject(e2);
        
        var e3 = new EnemyCharacterClass(stage, [["kani3.png","kani2.png","kani1.png","kani2.png",]]);
	e3.size.x = 40;
	e3.size.y=  40;
	e3.origin.x =1050;
	e3.origin.y =0;
	e3.chasingRange = 300;
	e3.collisionMargin.top = 20;
	e3.hurt=0;
        e3.movingVelocity = 50;
        e3.touchDamage = 20;
        stage.addStageObject(e3);
        
        var e4 = new EnemyCharacterClass(stage, [["kani3.png","kani2.png","kani1.png","kani2.png",]]);
	e4.size.x = 40;
	e4.size.y=  40;
	e4.origin.x =1110;
	e4.origin.y =0;
	e4.chasingRange = 300;
	e4.collisionMargin.top = 20;
	
        e4.movingVelocity = 50;
        e4.touchDamage = 20;
        e4.hurt = 0;
        stage.addStageObject(e4);
        
        var e5 = new EnemyCharacterClass(stage, [["kani3.png","kani2.png","kani1.png","kani2.png",]]);
	e5.size.x = 40;
	e5.size.y=  40;
	e5.origin.x =1210;
	e5.origin.y =0;
	e5.chasingRange = 300;
	e5.collisionMargin.top = 20;
	
        e5.movingVelocity = 50;
        e5.touchDamage = 20;
        e5.hurt = 0;
        stage.addStageObject(e4);
        
        var warpRight = new WarpItemClass(stage, ["panya", 60, 0, 32, 480, false]);
	warpRight.origin.x = 6368;
	warpRight.origin.y = 0;
	stage.addStageObject(warpRight);
	var warpLeft = new WarpItemClass(stage, ["panya", 60, 0, 32, 480, false]);
	warpLeft.origin.x = -32;
	warpLeft.origin.y = 0;
	stage.addStageObject(warpLeft);
};



stage;
					