
// StageObjectsはステージに文字シンボルとして配置したいオブジェクト定義の連想配列である。
// StageObjectの各項目の指定方法は以下の二通りある。
// ・クラス名指定 ... コンストラクタがに引数が不要な時
// a : BlockClass
// ・拡張指定
// a : {base : FreeItemClass,			//鋳型となるクラス名
//      args : '1190.png',				//コンストラクタに指定する引数(一つだけの場合) stageは自動で指定されるので不要
//      args : ['1190.png', callback],	//二つ以上の場合。やはり第一引数のstageは不要
//      prop : {times : 1},				//各インスタンスに指定したいプロパティの連想配列。(省略可)
										//この例ではaFreeItemClass.timesプロパティを1に指定している
//      adjust : [-50, 50],				//位置の微調整。必ずX座標、Y座標の相対位置を示す配列にする。(省略可)
//      extid : 19						//ネットワークを超えて一つのオブジェクトである必要がある場合にはゼロではない値を取る（ステージ内で固有の値, 省略可; 既定0）
//		sync : true						//ネットワーク同期を有効に(addStageObjectの第二引数)(省略可; 既定false)

var stgObjects = {
	
	// BlockClass : 普通のブロック。 引数に画像名を指定
  
    b : {base:BlockClass,args:'1150.png'},
    f : {base:BlockClass,args:'1190.png'},
    t : {base:BlockClass,args:'1160.png'},
 　 x : {base:BlockClass,args:'1236.png'},
    j : {base:BlockClass,args:'1238.png'},
    y : {base:BlockClass,args:'1240.png'},
    h : {base:BlockClass,args:'1239.png'},
　　ab: {base:BlockClass,args:'bridge.png'},
  
    
  
    i : {base:BlockClass,args:'1235.png'},
    n : {base:BlockClass,args:'leaves.png'},
    p : {base:BlockClass,args:'glass.png'},
    ag : {base:BlockClass,args:'hosikusabelow.png'},
    r : {base:HiddenBlockClass,args:'hosikusa.png'},
　　

   
    
    // SlopeBlockClass : 当たり判定が斜めのブロック。
    // 引数 : 画像名, 当たり判定領域左側の開始位置のブロック上辺からの高さ, 当たり判定領域右側の...
    //        たとえば、この例のように 0, 32 と指定すれば右下がりの坂になり、32, 0と指定すれば左下がり、 16, 16と指定すれば半分の高さの長方形になる
    // enableBlockMode : 当たり判定領域をデバッグ表示する。
 
    c : {base:SlopeBlockClass,args:['1152.png',32,0],prop:{enableDebugMode:true}},
    d : {base:SlopeBlockClass,args:['1213.png',16,16],prop:{enableDebugMode:true}},
    a : {base:SlopeBlockClass,args:['kusa.png',64,64],prop:{enableDebugMode:true}},
    g : {base:SlopeBlockClass,args:['1151.png',0,32],prop:{enableDebugMode:true}},
    e : {base:SlopeBlockClass,args:['1214.png',128,128],prop:{enableDebugMode:true}},
    l : {base:SlopeBlockClass,args:['leavesedge1.png',16,0],prop:{enableDebugMode:true}},
    m : {base:SlopeBlockClass,args:['leavesedge2.png',0,16],prop:{enableDebugMode:true}},
    o : {base:SlopeBlockClass,args:['stop.png',32,32],prop:{enableDebugMode:true}},
    q : {base:SlopeBlockClass,args:['hosikusa.png',8,8],prop:{enableDebugMode:true}},
    s : {base:SlopeBlockClass,args:['leaves.png',1500,1500],prop:{enableDebugMode:true}},
    u : {base:SlopeBlockClass,args:['1162.png',32,0],prop:{enableDebugMode:true}},
    w : {base:SlopeBlockClass,args:['1161.png',0,32],prop:{enableDebugMode:true}},
    z : {base:SlopeBlockClass,args:['1164.png',32,0],prop:{enableDebugMode:true}},
   aa : {base:SlopeBlockClass,args:['fence.png',600,600],prop:{enableDebugMode:true}},
   ad : {base:SlopeBlockClass,args:['fence.png',16,16],prop:{enableDebugMode:true}},
   ae : {base:SlopeBlockClass,args:['toge.png',28,28],prop:{enableDebugMode:true}},
   af : {base:SlopeBlockClass,args:['toge.png',0,0],prop:{enableDebugMode:true}},

    // FreeItemClass : キャラが取得するとコールバックが実行されるアイテム
    // callback : 誰かに取得されたときに発生するコールバック。アタックした人、そのアタック直後のx, y座標が引数にセットされる。
    // times : 取得できる回数で、-1で無限。
    k : {base:FreeItemClass,args:["1234.png",callBack],prop:{times:1}},
    
    ac : {base:FreeItemClass,args:["bridge.png",callBack],prop:{times:1}},
    // 何もブロックを置かない位置のためにかならずこのようなエントリーを記述
    _ : null
};

// FreeItemClassのコールバック
function callBack(obj, obj_x, obj_y)
{
	if(obj instanceof MainCharacterClass){

	}
}

var stgInfo = {
    width: 6400,				//横サイズ
    height: 480,				//縦サイズ
    background: "back2.png",		//背景画像。横幅は640pxである必要はない。
    BGM: "S02.mp3",
};

with(stgObjects) {
    var tbl = [
         [_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,],
         [_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,],
         [_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,],
         [_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,],
         [_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,i,_,_,_,i,i],
         [_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,l,s,m,_,_,_,_,_,_,],
         [_,_,_,_,_,_,_,_,l,n,m,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,l,s,m,_,_,_,l,s,m,_,_,_,_,_,_],
         [_,_,_,_,_,_,_,l,n,s,s,m,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,o,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,l,s,m,_,_,l,s,s,s,m,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,i,_,_,_,i,_,_,_,_,],
         [_,_,_,_,_,_,_,l,n,s,s,m,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,u,t,t,w,aa,aa,aa,aa,aa,aa,aa,aa,aa,aa,aa,aa,aa,aa,_,_,_,_,_,_,_,_,_,l,s,s,s,m,_,l,s,s,s,m,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,ag,],
         [_,_,_,_,_,_,_,l,n,n,n,m,_,_,_,_,_,o,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,u,t,t,t,t,t,ab,ab,ab,ac,ac,ab,ab,ac,ab,ac,ac,ac,ab,ac,t,t,t,t,t,w,_,_,_,l,s,s,s,m,_,_,l,n,m,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,i,k,i,_,_,_,_,_,ag,ag,],
         [_,_,i,k,i,_,_,_,_,e,_,_,_,_,_,a,c,b,g,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,z,t,t,t,t,t,t,t,j,_,_,_,_,_,_,_,_,_,_,_,_,h,t,t,t,t,t,t,j,_,_,_,l,n,m,_,_,_,_,e,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,ag,ag,ag,_,_,_,_,i,i,_,_,_,_,_,_,_,_,_,_,_,_,_,i,i,],
        [_,_,_,_,_,_,_,_,_,e,_,_,a,a,c,b,b,b,b,b,g,_,_,_,q,q,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,_,_,q,q,_,_,_,_,a,a,a,a,a,a,a,a,a,a,_,u,t,t,t,t,t,t,t,t,j,_,_,_,_,_,_,_,_,_,_,_,_,y,t,t,t,t,t,t,j,_,_,_,_,e,_,_,_,_,_,e,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,ag,ag,ag,ag,_,_,_,_,_,],
      [_,_,_,_,_,_,a,a,a,e,a,c,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,g,_,q,q,_,_,_,c,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,x,t,t,t,t,t,t,t,t,t,j,_,_,_,_,_,_,_,_,_,_,_,_,h,t,t,t,t,t,t,j,a,a,a,a,e,a,a,a,d,a,e,a,a,a,ad,ad,ad,ad,ad,ad,ad,_,_,_,_,_,_,_,ad,ae,ae,ae,_,_,ae,ae,ae,_,_,ae,ae,ae,_,ae,ae,ae,ae,ae,ae,ae,ae,af,af,af,ae,ae,af,af,ae,af,ad,a,a,a,q,q,q,a,a,a,a,a,a,a,a,a,a,ag,ag,ag,ag,ag,],
         [a,d,a,a,a,c,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,x,t,t,t,t,t,t,t,t,t,j,_,_,_,_,_,_,_,_,_,_,_,_,h,t,t,t,t,t,t,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,],
         [f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,j,_,_,_,_,_,_,_,_,_,_,_,_,h,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,f,]
 
    ];
}
//約束事
var stage = new PCDSLStageClass(stgInfo, tbl);


stage.runStage = function(){
	PCDSLStageClass.prototype.runStage.apply(this, []);
	var main = new MainCharacterClass(stage, [["nakedman.png","nakedman2.png",]]);
	main.size.x = 32;
	main.size.y=64;
	main.origin.x =32;
	main.origin.y =0;
	main.ownerUID = stage.manager.userID;
	main.movingVelocity = 200;
	stage.userControlledCharacter = main

var barn = new SlopeBlockClass(stage, ["barn.png", 49, 49]);

barn.size.x = 200;
barn.size.y = 150;
barn.origin.x = 1300;
barn.origin.y =236;
stage.addStageObject(barn);

var barn2 = new SlopeBlockClass(stage, ["barn.png", 49, 49]);

barn2.size.x = 170;
barn2.size.y = 150;
barn2.origin.x = 3700;
barn2.origin.y =266;
stage.addStageObject(barn2);

var windmill = new SlopeBlockClass(stage, ["windmill.png", 5, 5]);
windmill.size.x = 50;
windmill.size.y = 150;
windmill.origin.x = 1600;
windmill.origin.y =236;
stage.addStageObject(windmill);


var cow2 = new SlopeBlockClass(stage, ["cow2.png", 49, 49]);
cow2.size.x = 100;
cow2.size.y = 50;
cow2.origin.x = 850;
cow2.origin.y = 336;
stage.addStageObject(cow2);

var cow3 = new SlopeBlockClass(stage, ["cow.png", 49, 49]);
cow3.size.x = 100;
cow3.size.y = 50;
cow3.origin.x = 930;
cow3.origin.y = 336;
stage.addStageObject(cow3);

var fence = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
fence.size.x = 32;
fence.size.y = 32;
fence.origin.x = 736;
fence.origin.y = 352;
stage.addStageObject(fence);

var fence2 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
fence2.size.x = 32;
fence2.size.y = 32;
fence2.origin.x = 768;
fence2.origin.y = 352;
stage.addStageObject(fence2);

var fence3 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
fence3.size.x = 32;
fence3.size.y = 32;
fence3.origin.x = 800;
fence3.origin.y = 352;
stage.addStageObject(fence3);

var fence4 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
fence4.size.x = 32;
fence4.size.y = 32;
fence4.origin.x = 832;
fence4.origin.y = 352;
stage.addStageObject(fence4);

var fence5 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
fence5.size.x = 32;
fence5.size.y = 32;
fence5.origin.x = 864;
fence5.origin.y = 352;
stage.addStageObject(fence5);

var fence6 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
fence6.size.x = 32;
fence6.size.y = 32;
fence6.origin.x = 896;
fence6.origin.y = 352;
stage.addStageObject(fence6);

var fence7 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
fence7.size.x = 32;
fence7.size.y = 32;
fence7.origin.x = 928;
fence7.origin.y = 352;
stage.addStageObject(fence7);

var fence8 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
fence8.size.x = 32;
fence8.size.y = 32;
fence8.origin.x = 960;
fence8.origin.y = 352;
stage.addStageObject(fence8);

var fence9 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
fence9.size.x = 32;
fence9.size.y = 32;
fence9.origin.x = 992;
fence9.origin.y = 352;
stage.addStageObject(fence9);

var fence10 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
fence10.size.x = 32;
fence10.size.y = 32;
fence10.origin.x = 1024;
fence10.origin.y = 352;
stage.addStageObject(fence10);

var fence11 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
fence11.size.x = 32;
fence11.size.y = 32;
fence11.origin.x = 3712;
fence11.origin.y = 384;
stage.addStageObject(fence11);

var fence12 = new SlopeBlockClass(stage, ["fence.png", 16, 16]);
fence12.size.x = 32;
fence12.size.y = 32;
fence12.origin.x = 3680;
fence12.origin.y = 384;
stage.addStageObject(fence12);

var cow4 = new SlopeBlockClass(stage, ["cow.png", 14, 14]);
cow4.size.x = 100;
cow4.size.y = 50;
cow4.origin.x = 4010;
cow4.origin.y = 367;
stage.addStageObject(cow4);

var cow5 = new SlopeBlockClass(stage, ["cow2.png", 14, 14]);
cow5.size.x = 100;
cow5.size.y = 50;
cow5.origin.x = 4180;
cow5.origin.y = 367;
stage.addStageObject(cow5);

var cow6 = new SlopeBlockClass(stage, ["cow.png", 70, 70]);
cow6.size.x = 100;
cow6.size.y = 50;
cow6.origin.x = 4420;
cow6.origin.y = 367;
stage.addStageObject(cow6);

var cow7 = new SlopeBlockClass(stage, ["cow2.png", 14, 14]);
cow7.size.x = 100;
cow7.size.y = 50;
cow7.origin.x = 4510;
cow7.origin.y = 367;
stage.addStageObject(cow7);


},


stage;