<?php
//
//定数宣言
//

//データベースユーザー名
define("DATABASE_USER", "pcd2013devUser");
//データベースパスワード
define("DATABASE_PWD", "MoonStone");
//データベース名
define("DATABASE_NAME", "pcd2013dev");

//データベース生成SQL
define("QUERY_CREATE_authUserTable", "");
define("QUERY_CREATE_stageObjectTable", "");

//SQL文 for authUserTable
define("QUERY_SELECT_USER_ID", "SELECT id from authUserTable where name = ?");
define("QUERY_SELECT_USER_ID_TYPES", "s");
define("QUERY_SELECT_USER_STAGE", "SELECT userStageName from authUserTable where id=?");
define("QUERY_SELECT_USER_STAGE_TYPES", "i");
define("QUERY_SELECT_USER_STAGE_AND_TIMESTAMP", "SELECT userStageName, lastResponseTimestamp from authUserTable where id=?");
define("QUERY_SELECT_USER_STAGE_AND_TIMESTAMP_TYPES", "i");
define("QUERY_ADD_USER", "insert into authUserTable (name, userStageName) values (?, ?)");
define("QUERY_ADD_USER_TYPES", "ss");
define("QUERY_UPDATE_USER_STAGE", "UPDATE authUserTable SET userStageName=? WHERE id=?");
define("QUERY_UPDATE_USER_STAGE_TYPES", "si");
define("QUERY_UPDATE_USER_TIMESTAMP", "UPDATE authUserTable SET lastResponseTimestamp=? WHERE id=?");
define("QUERY_UPDATE_USER_TIMESTAMP_TYPES", "ii");
define("QUERY_SELECT_USER_TIMESTAMP", "SELECT lastResponseTimestamp from authUserTable where id = ?");
define("QUERY_SELECT_USER_TIMESTAMP_TYPES", "i");
define("QUERY_DELETE_OFFLINE_USER", "DELETE from authUserTable WHERE lastResponseTimestamp<=?");
define("QUERY_DELETE_OFFLINE_USER_TYPES", "i");
define("QUERY_SELECT_USER_CCLASS", "SELECT userCharacterBaseClass from authUserTable where id=?");
define("QUERY_SELECT_USER_CCLASS_TYPES", "i");
define("QUERY_UPDATE_USER_CCLASS", "UPDATE authUserTable SET userCharacterBaseClass=? where id=?");
define("QUERY_UPDATE_USER_CCLASS_TYPES", "si");
//SQL文 for stageObjectTable
define("QUERY_ADD_OBJECT", "insert into stageObjectTable (locationX, locationY, velocityX, velocityY, stageName, className, objectAttribute, constructorArgs, ownerUserID, modifiedTimestamp, addedTimestamp) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
define("QUERY_ADD_OBJECT_TYPES", "ddddssssiii");
define("QUERY_DELETE_USER_OBJECT_ALL", "delete from stageObjectTable where ownerUserID=?");
define("QUERY_DELETE_USER_OBJECT_ALL_TYPES", "i");
define("QUERY_SELECT_ADDED_OBJECT", "SELECT id, locationX, locationY, velocityX, velocityY, className, objectAttribute, constructorArgs, ownerUserID FROM stageObjectTable WHERE stageName=? AND ownerUserID<>? AND addedTimestamp>? AND objectAttribute<>'Deleted'");
define("QUERY_SELECT_ADDED_OBJECT_TYPES", "sii");
define("QUERY_SELECT_UPDATED_OBJECT", "SELECT id, locationX, locationY, velocityX, velocityY, className, objectAttribute FROM stageObjectTable WHERE stageName=? AND ownerUserID<>? AND modifiedTimestamp>=? AND addedTimestamp<? AND objectAttribute<>'Deleted'");
define("QUERY_SELECT_UPDATED_OBJECT_TYPES", "siii");
define("QUERY_SELECT_DELETED_OBJECT", "SELECT id, locationX, locationY, velocityX, velocityY, className, objectAttribute FROM stageObjectTable WHERE stageName=? AND ownerUserID<>? AND modifiedTimestamp>=? AND objectAttribute='Deleted'");
define("QUERY_SELECT_DELETED_OBJECT_TYPES", "sii");
define("QUERY_UPDATE_STAGE_OBJECT", "UPDATE stageObjectTable SET locationX=?, locationY=?, velocityX=?, velocityY=?, objectAttribute=?, modifiedTimestamp=? WHERE stageName=? AND id=? AND objectAttribute<>'Deleted'");
define("QUERY_UPDATE_STAGE_OBJECT_TYPES", "ddddsisi");
define("QUERY_SELECT_ALL_OTHER_USER_OBJECT", "SELECT id, locationX, locationY, velocityX, velocityY, className, objectAttribute, constructorArgs, ownerUserID FROM stageObjectTable WHERE stageName=? AND ownerUserID<>? AND modifiedTimestamp>? AND objectAttribute<>'Deleted'");
define("QUERY_SELECT_ALL_OTHER_USER_OBJECT_TYPES", "sii");
define("QUERY_CHECK_AND_SET_DELETED_OBJECT", "UPDATE stageObjectTable SET objectAttribute='Deleted', modifiedTimestamp=? WHERE modifiedTimestamp<=? AND objectAttribute<>'Deleted'");
define("QUERY_CHECK_AND_SET_DELETED_OBJECT_TYPES", "ii");
define("QUERY_DELETE_OFFLINE_OBJECT", "DELETE from stageObjectTable WHERE modifiedTimestamp<=?");
define("QUERY_DELETE_OFFLINE_OBJECT_TYPES", "i");
//デフォルト開始ステージ名
define("DEFAULT_START_STAGE", "cselect");

//生存期間（ミリ秒）
define("OBJECT_ALIVE_TIME_MS", 2000);
define("OBJECT_DELETE_TIME_MS", 30000);
define("USER_ALIVE_TIME_MS", 2000);
define("USER_DELETE_TIME_MS", 180000);

function escapeMySQLArgumentString(&$str)
{
	$str = str_replace("\\", "", $str);
	$str = str_replace("\"", "", $str);
	$str = str_replace("'", "", $str);
	$str = str_replace("¥", "", $str);
	$str = str_replace("|", "", $str);
}

function updateUserTimestamp($db, $userID)
{
	$stmt = $db->prepare(QUERY_UPDATE_USER_TIMESTAMP);
	$stmt->bind_param(QUERY_UPDATE_USER_TIMESTAMP_TYPES, getTimeStampMs(), $userID);
	$stmt->execute();
	//エラーチェック省略
	$stmt->close();
}

function getUserLastResponseTimestamp($db, $userID)
{
	$ts = 0;
	$stmt = $db->prepare(QUERY_SELECT_USER_TIMESTAMP);
	$stmt->bind_param(QUERY_SELECT_USER_TIMESTAMP_TYPES, $userID);
	$stmt->execute();
	if($stmt->errno == 0){
		//クエリ成功
		$stmt->store_result();
		// 結果の個数を確認
		if($stmt->num_rows != 0){
			//結果格納
			$stmt->bind_result($ts);
			$stmt->fetch();
		}
	}
	$stmt->close();
	return $ts;
}

function getTimeStampMs()
{
	return ceil(microtime(true)*1000);
}

?>