(function (window, $, undefined) {
	var document = window.document,
		key = "simplrTextDate";
	
	var log = function (val) {
		console.log(val);
	};
	
	var dir = function (val) {
		console.dir(val);
	};
	
	String.prototype.toNumber = function () {
		return this.replace(/^(\d*)[\s\S]*/, "$1") - 0;
	};
	
	$(function () {
		
		var $t = $("#textarea"),
			$tt = $("#textarea textarea"),
			$i = $("#info");
		
		var autoIndent = function ($e) {
			var pos = $e.getCaretPos(),
				before,
				after,
				val = $e.val(),
				res,
				indent;
			
			before = val.substring(0, pos.start);
			res = before.split(/\n/);
			indent = res[res.length - 1].match(/^\s*/)[0];
			
			after = val.substring(pos.start, val.length);
			before += "\n" + indent;
			$e.val(before + after);
						
			$e.setCaretPos({
				start:	before.length,
				end:	before.length
			});
			
			return;
		};
		
		var closeTag = function ($e) {
			var pos = $e.getCaretPos(),
				val = $e.val(),
				before,
				res,
				tag;
			
			before = val.substring(0, pos.start);
			res = before.match(/^[\S\s]*<([a-zA-Z0-9]+)(?:\s[\s\S]*)?>([\s\S]*)/);
			
			if (res) {
				tag = "</" + res[1] + ">";
				if (res[2] !== "") {
					$e.insertBeforeSelection(tag);
				} else {
					$e.insertAfterSelection(tag);
				}
			}
		};
		
		var selectLine = function ($e) {
			var pos = $e.getCaretPos(),
				val = $e.val(),
				selection = $e.getSelection(),
				before,
				after,
				res,
				start,
				end;
			
			if (!selection.match(/\n/)) {
				before = val.substring(0, pos.start);
				after = val.substring(pos.end, val.length);
				
				res = before.match(/^[\s\S]*\n/);
				start = res ? res[0].length : 0;
				
				res = after.match(/^.*?\n/);
				end = res ? pos.end + res[0].length : val.length;
				
				$e.setCaretPos({
					start: start,
					end: end
				});
			}
		};
		
		var preFix;
		var findText = function ($e) {
			var input = prompt(
				"検索\n(正規表現を使用する場合は\"g:\"、しない場合は\"n:\"を先頭に)",
				preFix
			);
		};
		
		
		$tt.focus();
		
		var isCtrl = false;
		$tt.bind("keydown", function (event) {
			var key = $.getKeyCode(event);
			
			switch (key) {
			case 9 :
				event.preventDefault();
				$tt.insertBeforeSelection("\t");
				return false;
				
			case 13 :
				event.preventDefault();
				autoIndent($tt);
				return false;
				
			case 84 :
				if (isCtrl) {
					event.preventDefault();
					closeTag($tt);
					return false;
				}
				break;
				
			case 76 :
				if (isCtrl) {
					event.preventDefault();
					selectLine($tt);
					return false;
				}
				break;
				
			case 70 :
				if (isCtrl) {
					event.preventDefault();
					findText($tt);
					return false;
				}
				break;
				
			case 17 :
				isCtrl = true;
				break;
				
			default :
				log(key);
				break;
			}
		})
		
		.bind("keyup", function (event) {
			var key = $.getKeyCode(event);
			
			switch (key) {
			case 17 :
				isCtrl = false;
				break;
				
			default :
				break;
			}
		});		
		
		// 文書の情報を更新
		var info = {
			countChar: $i.find(".countChar").text() - 0,
			countLine: $i.find(".countLine").text() - 0,
			currentLine: $i.find(".currentLine").text() - 0
		};
		var setInfo = function () {
			var val = $tt.val(), tmp;
			
			tmp = val.length;
			if (info.countChar !== tmp) {
				$i.find(".countChar").text(tmp);
				info.countChar = tmp;
			}
			
			tmp = val.split(/\n/g).length;
			if (info.countLine !== tmp) {
				$i.find(".countLine").text(tmp);
				info.countLine = tmp;
			}
			
			tmp = val.substring(0, $tt.getCaretPos().start).split(/\n/g).length
			if (info.currentLine !== tmp) {
				$i.find(".currentLine").text(tmp);
				info.currentLine = tmp;
			}
		};
		
		setInfo();
		setInterval(setInfo, 300);
		
		var flag = false;
	});
})(window, jQuery);

