// atgs[0] : SelectWidgetItemClassのリスト
// args[1] : 選択完了時のコールバック 引数: Cancel->null, Ok->SelectWidgetItemClassの「リスト」(複数選択不可の時も) (省略可)
// args[2] : 複数選択可(省略可、初期値はfalse)
// args[3] : 初期選択位置(省略可、初期値は0);
// args[4] : 最下部にメッセージを表示するかどうか(省略可、初期値はtrue);
var SelectWidgetClass = function(manager, args){
	SelectWidgetClass.base.apply(this, arguments);
	
	//位置など
	this.size = new Point2D(600, 440);
	this.origin = new Point2D(20, 20);
	
	//オプション
	this.items = args[0].slice(0);
	this.callback = args[1];	//省略可
	this.multiSelect = args[2] != undefined ? args[2] : false;
	this.defaultCursor = args[3] != undefined ? args[3] : 0;
	this.cursor = -1;
	this.showMessage = args[4] != undefined ? args[4] : true;
	this.fixedMessage = "";
	
	this.enableCancel = true;	//キャンセルボタンを有効にする
	
	//画面配置
	this.padding = 20;									//選択画面内の上下左右の余白
	this.itemPadding = 20;								//アイテムの間隔
	this.messageHeight = this.showMessage ? 166 : 0;	//メッセージ部分の高さ(マージン部分を含む)
	this.messageMergin = 32;							//メッセージ周囲のマージン
	this.messageBorder = "3px orange solid";			//メッセージの外郭
	this.buttonHeight = 16;								//ボタン部分の高さ
	this.buttonWidth = 96;								//一つのボタンの幅
	this.backColor = "rgba(0, 0, 0, 0.75)";							//画面の背景色
	this.border = "1px white solid";					//画面の最外郭
	
	//内部の変数
	this.wBox = null;
	this.wMessage = null;
	this.okButton = null;
	this.cancelButton = null;
	this.leftKeyPressed = true;
	this.rightKeyPressed = true;
	this.selectKeyPressed = true;
	this.isHidden = false;
	
	this.modalFunc = null;
	
}.extend(WidgetClass, {
	attach : function(){
		var w = this;
		var that = this;
		this.modalFunc = function()
		{
			// pauseStageに直接tickを設置するとtick内のthisでmanagerが取得されてしまう
			if(!w.tick())
			{
				w.manager.resumeStage();
				//w.manager.removeWidget(w);
			}
		};
		this.manager.pauseStage(this.modalFunc,
		function(){
			var wBox, wItem, wMessage, bOk, bCancel;
			wBox = document.createElement('div');
			with(wBox)
			{
				style.position = "absolute";
				style.top = that.origin.y + "px";
				style.left = that.origin.x + "px";
				style.width = that.size.x + "px";
				style.height = that.size.y + "px";
				style.backgroundColor = that.backColor;
				style.border = that.border;
				style.zIndex = "999";
			}
			wItem = document.createElement('div');
			with(wItem)
			{
				style.position = "absolute";
				style.top = that.padding + "px";
				style.left = that.padding + "px";
				style.width = (that.size.x - (that.padding * 2)) + "px";
				style.height = (that.size.y - (that.padding * 2) - that.buttonHeight - that.messageHeight) + "px";
				style.overflow = "hidden";
			}
			wBox.appendChild(wItem);
			
			var xloc = that.itemPadding, yloc = that.itemPadding;
			var maxHeight = 0;
			for(var i = 0; i < that.items.length; i++)
			{
				var w = that.items[i];
				if(xloc + w.size.x > (that.size.x - (that.padding * 2)) - that.itemPadding)
				{
					xloc = that.itemPadding;
					yloc += maxHeight + that.itemPadding;
					maxHeight = 0;
				}
				
				wItem.appendChild(w.createHtmlElement(xloc, yloc));
				w.updateHtmlElement()
				
				xloc += w.size.x + that.itemPadding;
				
				if(maxHeight < w.size.y) maxHeight = w.size.y;
				
			}
			
			wMessage = createMessageBox(
				"", 															//id
				that.size.x - (that.padding * 2) - (that.messageMergin * 2), 	//width
				that.messageHeight - (that.messageMergin * 2),					//height
				that.messageMergin + that.padding,								//x
				that.size.y - that.padding - that.buttonHeight - that.messageHeight + that.messageMergin,	//y
				wBox,
				"",																//color
				"white",														//foreColor
				16																//mergin
			);
			wMessage.style.border = that.messageBorder;
			changeMessageBox(wMessage, "", false);	//初めは空の文字列にしておく
			that.wMessage = wMessage;
			that.okButton = new SelectWidgetItemClass(true, "決定", new Point2D(that.buttonWidth, that.buttonHeight), false, "決定します。");
			bOk = that.okButton.createHtmlElement(that.size.x - that.padding - that.buttonWidth, that.size.y - that.padding - that.buttonHeight)
			wBox.appendChild(bOk);
			
			if(that.enableCancel)
			{
				that.cancelButton = new SelectWidgetItemClass(true, "キャンセル", new Point2D(that.buttonWidth, that.buttonHeight), false, "キャンセルします。");
				bCancel = that.cancelButton.createHtmlElement(that.size.x - that.padding - (that.buttonWidth * 2) - that.itemPadding * 2, that.size.y - that.padding - that.buttonHeight);
				wBox.appendChild(bCancel);
				that.items.push(that.cancelButton);
			}
			that.items.push(that.okButton);
			
			that.manager.mainArea.appendChild(wBox);
			that.wBox = wBox;
			
			// 初期選択状態をつくる
			that.moveCursor(that.defaultCursor);
		});
	},
	detach : function(){
		if(this.wBox){
			this.manager.mainArea.removeChild(this.wBox);
			
		}
		if(this.modalFunc)
		{
			this.manager.resumeStage(this.modalFunc);
		}
		if(this.callback)
		{
			this.callback(this.callbackArg);
		}
	},
	tick : function(){
	
		if(this.isHidden)
		{
			return false;
		}
		
		if(!this.wBox) return true;
		
		//カーソルの移動
		if(this.manager.UIManager.keyState.cursorLeft)
		{
			if(!this.leftKeyPressed)
			{
				this.leftKeyPressed = true;
				this.moveCursor(this.cursor - 1);
			}
		}else
		{
			this.leftKeyPressed = false;
		}
		if(this.manager.UIManager.keyState.cursorRight)
		{
			if(!this.rightKeyPressed)
			{
				this.rightKeyPressed = true;
				this.moveCursor(this.cursor + 1);
			}
		}else
		{
			this.rightKeyPressed = false;
		}
		if(this.manager.UIManager.keyState.select)
		{
			if(!this.selectKeyPressed)
			{
				this.selectKeyPressed = true;
				if(!this.select(this.cursor))
				{
					this.isHidden = true;
				}
			}
		}else
		{
			this.selectKeyPressed = false;
		}
		return true;
	},
	moveCursor : function(c){
		if(c < 0) c = 0;
		if(c >= this.items.length) c = this.items.length - 1;
		
		if(this.cursor != -1)
		{
			this.items[this.cursor].isActive = false;
			this.items[this.cursor].updateHtmlElement();
		}
		
		this.cursor = c;
		this.items[this.cursor].isActive = true;
		this.items[this.cursor].updateHtmlElement();
		
		var message = this.items[this.cursor].message
		if(this.fixedMessage != "") message = this.fixedMessage;
		changeMessageBox(this.wMessage, message, false);
	},
	select : function(c){	//Widgetを閉じるときはfalseで帰る
		if(c < this.items.length - (this.enableCancel ? 2 : 1))
		{
			if(this.multiSelect)
			{
				this.items[c].isSelected = !this.items[c].isSelected;
				this.items[c].updateHtmlElement();
			}else
			{
				for(var i = 0; i < this.items.length; i++)
				{
					this.items[i].isSelected = i == c;
					this.items[i].updateHtmlElement();
				}
			}
		}else
		{
			if((c == this.items.length - 2 && this.enableCancel)) //cancel button
			{
				if(this.callback)
				{
					this.callbackArg = null;
				}
			}else	//ok button
			{
				if(this.callback)
				{
					var list = [];
					for(var i = 0; i < this.items.length; i++)
					{
						if(this.items[i].isSelected)
						{
							list.push(this.items[i]);
						}
					}
					this.callbackArg = list;
				}
			}
			return false;
		}
		return true;
	}
});

// showAsLabel ... true : 第二引数をテキストとして表示する
// value				: 表示する文字列または画像
// size					: 要素のサイズ(Point2D)
// selected				: 初めから選択されているか(省略可 : 初期値false)
// message				: SelectWidgetClassの下に表示する文字列
var SelectWidgetItemClass = function(showAsLabel, value, size, selected, message)
{
	
	//属性
	this.showAsLabel = showAsLabel;
	this.value = value;
	this.size = size ? size : new Point2D(48, 48);
	this.isActive = false;
	this.isSelected = selected != undefined ? selected : false;
	this.message = message ? message : "";
	
	//外観
	this.border = "none";
	this.borderSelected = "1px orange solid";
	this.back = "";
	this.backSelected = "orange";
	
	//内部変数
	this.element = null;
};
SelectWidgetItemClass.prototype = {
	createHtmlElement : function(x, y)
	{
		if(this.element == null)
		{
			var element = document.createElement('div');
			this.element = element;
		} else{
			var element = this.element;
		}
		with(element)
		{
			style.position = "absolute";
			style.top = y + "px";
			style.left = x + "px";
			style.width = this.size.x + "px";
			style.height = this.size.y + "px";
			style.padding = "6px";					//showAsLabelの時のための設定。
			style.overflow = "hidden";
			style.borderRadius = "6px";
			style.border = this.border;
			style.backgroundColor = this.back;
			style.color = "white";
		}
		
		if(this.showAsLabel)
		{
			element.innerText = this.value;
		}else
		{
			var child = document.createElement('img')
			child.src = "images/" + this.value;
			with(child)
			{
				style.position = "absolute";
				style.top = "0";
				style.left = "0";
				style.width = "100%";
				style.height = "100%";
			}
			element.appendChild(child);
		}
		
		return this.element;
	},
	updateHtmlElement : function()
	{
		if(this.element != null)
		{
			with(this.element)
			{
				style.border = this.isActive ? this.borderSelected : this.border;
				style.backgroundColor = this.isSelected ? this.backSelected : this.back;
			}
		}
	}
};

