var RandomIngredientItemClass = function(stage, args){
	RandomIngredientItemClass.base.apply(this, arguments);
	if(args[0]){
		this.ingredients = args[0]
	} else{
		this.ingredients = IngredientAttributeList;
	}
	this.isFixedImage = false;
	if(args[1]){
		this.image = createImage(args[1]);
		this.isFixedImage = true;
	}
	this.times = -1;
	this.touchInterval = 60 * 60;
	this.changeItemTickIntervalBase = 12;
	this.changeItemTickInterval = this.changeItemTickIntervalBase;
	this.currentItemIndex = 0;
	this.callback = this.itemCaputured;
}.extend(FreeItemClass, {
	draw: function(x, y){
		var tickCount = this.ownerStage.manager.tickCount;
		if(this.changeItemTickInterval == this.changeItemTickIntervalBase){
			if(tickCount - this.lastTouchedTickCount >= this.touchInterval){
				this.currentItemIndex = getRandomInteger(this.ingredients.length - 1);
				if(!this.isFixedImage){
					this.image = IngredientImageList[this.currentItemIndex];
				}
			} else{
				this.currentItemIndex = -1;
				if(!this.isFixedImage){
					this.image = null;
				}
			}
		}
		this.changeItemTickInterval--;
		if(this.changeItemTickInterval <= 0){
			this.changeItemTickInterval = this.changeItemTickIntervalBase;
		}
		RandomIngredientItemClass.base.prototype.draw.apply(this, arguments);
	},
	itemCaputured: function(obj){
		if(this.image && obj instanceof MainCharacterClass){
			var m = this.ownerStage.userControlledCharacter;
			if(obj == m){
				if(this.ownerStage.manager.userManager.addIngredientItem(getSelectWidgetItemFromIngredientID(this.ingredients[this.currentItemIndex][0]))){
					mainManager.addWidget(new MessageWidgetClass(mainManager, [this.ingredients[this.currentItemIndex][2] + "をひろった。\n"]));
				} else{
					mainManager.addWidget(new MessageWidgetClass(mainManager, ["あなたは" + this.ingredients[this.currentItemIndex][2] + "を取り上げたが、手持ちの材料がいっぱいで持ちきれなかった。\n"]));
				}
			}
		}
	},
});
RandomIngredientItemClass.tick = function(){return false;};
