var EnemyCharacterClass_PanTank = function(stage, args){
	EnemyCharacterClass_PanTank.base.apply(this, [stage, [["pantank1.png","pantank2.png","pantank3.png","pantankaim.png","pantankfire.png","pantankcooldown.png",]]]);

	this.size.x = 128;
	this.size.y = 128;
	
	this.chasingRange = 700;
	this.collisionMargin.top = 90;
	this.collisionMargin.bottom = 10;
	
	this.movingVelocity = 130;
	
	this.touchDamage = 30;
	this.hurt = 0;
	this.max_HP = 85;
	this.HP = this.max_HP;
	
	this.isItemCollector = false;
	this.isWeaponed = true;

	stage.addStageObject(this);
}.extend(EnemyCharacterClass, {
	className: "EnemyCharacterClass_PanTank",
	fire: function()
	{
		if(this.lastFireTick < this.ownerStage.manager.tickCount - this.fireTickInterval){
			var f = new FireObjectClass(this.ownerStage, [["bullet.png"]]);
			f.maxBoundCount = 1;
			f.size.x = 20;
			f.size.y = 20;
			f.fire(this, 70,70);
			this.fireTickInterval=85;
			this.lastFireTick = this.ownerStage.manager.tickCount;
		}
	},
});
