#pragma once
#include <math.h>
#include "GVONavish.h"
#include "GVONormalizedPoint.h"


// ȈՓ񎟌xNg
class GVOVector {
private:
	double m_x = 0.0;
	double m_y = 0.0;
	double m_length = 0.0;

public:
	GVOVector() = default;
	GVOVector( const double x, const double y ) :
		m_x( x ),
		m_y( y ),
		m_length( calcLength( x, y ) )
	{
	}

	// EW2_xNgZoB
	// XE̔ȏ㗣ĂƋtŃxNgB
	// i~̋߂̗̋pj
	//
	// TODO: łWorldMapɏڂB
	GVOVector( const POINT& p1, const POINT& p2 )
	{
		const LONG k_threshold = k_worldWidth / 2;
		LONG dx = p2.x - p1.x;

		if ( k_threshold < dx ) {
			dx -= k_worldWidth;
		}
		else if ( dx < -k_threshold ) {
			dx += k_worldWidth;
		}
		m_x = dx;
		m_y = p2.y - p1.y;
		m_length = calcLength( m_x, m_y );
	}

	// KꂽEW2_xNgZo
	//
	// TODO: łWorldMapɏڂB
	GVOVector( const GVONormalizedPoint & p1, const GVONormalizedPoint&p2 )
	{
		const float k_threshold = 0.5f;
		float dx = p2.x() - p1.x();

		if ( k_threshold < dx ) {
			dx -= k_threshold;
		}
		else if ( dx < -k_threshold ) {
			dx += k_threshold;
		}
		m_x = dx;
		m_y = p2.y() - p1.y();
		m_length = calcLength( m_x, m_y );
	}

	// xNgx
	inline double x() const
	{
		return m_x;
	}

	// xNgy
	inline double y() const
	{
		return m_y;
	}

	// xNg
	inline double length() const
	{
		return m_length;
	}

	// PʃxNgԂ
	inline GVOVector normalizedVector() const
	{
		return normalizedVector( length() );
	}

	// Cӂ̒ŃxNg𐳋K
	inline GVOVector normalizedVector( const double norm ) const
	{
		GVOVector v( m_x, m_y );
		const double length = v.length();
		v.m_x = (v.m_x / length) * norm;
		v.m_y = (v.m_y / length) * norm;
		v.m_length = norm;
		return v;
	}

	// Q̃xNg̊px
	inline double angleTo( const GVOVector& other )const
	{
		return ::atan2( other.m_x * m_y - m_x * other.m_y, m_x * other.m_x + m_y * other.m_y );
	}

	// xNg
	inline void composite( const GVOVector& other )
	{
		m_x += other.m_x;
		m_y += other.m_y;
		m_length = calcLength( m_x, m_y );
	}

	//!@brief _ƃxNgw肵čW𓾂
	POINT pointFromOriginWithLength( const POINT& origin, const LONG length ) const
	{
		GVOVector v = normalizedVector();
		const POINT p = {
			origin.x + LONG( v.x() * length ),
			origin.y + LONG( v.y() * length )
		};
		return p;
	}
private:
	// xNgvZ
	static inline double calcLength(const double x, const double y)
	{
		return ::pow( x * x + y * y, 0.5 );
	}

};
