package ogakisoft.gesture.tools;

import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class GestureViewer extends JFrame {
	private static final long serialVersionUID = 1L;
	// private static final String TAG = "GestureViewer";
	private static final String source_file = "/Users/ogakinoritoshi/Documents/temp/gesture_data.compact";
	JPanel contentPane;
	JPanel panel;
	JLabel lblLabel;
	List<GestureHolder.Entry> entries;
	int index_entries;

	public GestureViewer(GestureHolder holder) {
		entries = holder.getEntries();
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 300, 300);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		GridBagLayout gbl_contentPane = new GridBagLayout();
		gbl_contentPane.columnWidths = new int[] { 131, 61, 117, 0 };
		gbl_contentPane.rowHeights = new int[] { 29, 0, 0 };
		gbl_contentPane.columnWeights = new double[] { 1.0, 0.0, 0.0,
				Double.MIN_VALUE };
		gbl_contentPane.rowWeights = new double[] { 0.0, 1.0, Double.MIN_VALUE };
		contentPane.setLayout(gbl_contentPane);

		// JLabel
		lblLabel = new JLabel("label");
		GridBagConstraints gbc_lblLabel = new GridBagConstraints();
		gbc_lblLabel.anchor = GridBagConstraints.WEST;
		gbc_lblLabel.insets = new Insets(0, 0, 5, 5);
		gbc_lblLabel.gridx = 0;
		gbc_lblLabel.gridy = 0;
		contentPane.add(lblLabel, gbc_lblLabel);

		JButton btnNext = new JButton("next");
		btnNext.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				if (index_entries < entries.size() - 2) {
					index_entries++;
					GestureHolder.Entry entry = entries.get(index_entries);
					show(entry.entryName, entry.gestures.get(0));
				}
			}
		});
		GridBagConstraints gbc_btnNext = new GridBagConstraints();
		gbc_btnNext.insets = new Insets(0, 0, 5, 0);
		gbc_btnNext.gridx = 2;
		gbc_btnNext.gridy = 0;
		contentPane.add(btnNext, gbc_btnNext);

		// JPanel
		panel = new JPanel();
		GridBagConstraints gbc_panel = new GridBagConstraints();
		gbc_panel.gridwidth = 3;
		gbc_panel.fill = GridBagConstraints.BOTH;
		gbc_panel.gridx = 0;
		gbc_panel.gridy = 1;
		contentPane.add(panel, gbc_panel);
	}

	public void show(String label, GestureHolder.Gesture gesture) {
		lblLabel.setText(label);
		panel.getGraphics()
				.clearRect(0, 0, panel.getWidth(), panel.getHeight());
//		int w = panel.getWidth();
//		int h = panel.getHeight();
		int x1, y1, x2, y2;

		int count_strokes = gesture.strokes.size();
		int count_points;
		GestureHolder.Stroke stroke;
		GestureHolder.Point point;
//		Rect rect = computeBoundingBox(gesture.strokes);
		for (int i = 0; i < count_strokes; i++) {
			stroke = gesture.strokes.get(i);
			count_points = stroke.points.size();
			x1 = 0;
			x2 = 0;
			y1 = 0;
			y2 = 0;
			for (int j = 0; j < count_points; j++) {
				point = stroke.points.get(j);
				x1 = (int) point.x;
				y1 = (int) point.y;
				if (x2 > 0 && y2 > 0) {
					int xx1 = x1; //(int) ((x1 * w) / rect.width - rect.left);
					int yy1 = y1; //(int) ((y1 * h) / rect.height - rect.top);
					int xx2 = x2; //(int) ((x2 * w) / rect.width - rect.left);
					int yy2 = y2; //(int) ((y2 * h) / rect.height - rect.top);
					panel.getGraphics().drawLine(xx1, yy1, xx2, yy2);
				}
				x2 = x1;
				y2 = y1;
			}
		}
	}

//	static class Rect {
//		float width;
//		float height;
//		float left;
//		float right;
//		float top;
//		float bottom;
//	}
//
//	private static Rect computeBoundingBox(List<GestureHolder.Stroke> strokes) {
//		int count_strokes = strokes.size();
//		int count_points;
//		GestureHolder.Stroke stroke;
//		GestureHolder.Point point;
//		float minX = Float.MAX_VALUE;
//		float minY = Float.MAX_VALUE;
//		float maxX = Float.MIN_VALUE;
//		float maxY = Float.MIN_VALUE;
//		for (int i = 0; i < count_strokes; i++) {
//			stroke = strokes.get(i);
//			count_points = stroke.points.size();
//			for (int j = 0; j < count_points; j++) {
//				point = stroke.points.get(j);
//				minX = Math.min(minX, point.x);
//				minY = Math.min(minY, point.y);
//				maxX = Math.max(maxX, point.x);
//				maxY = Math.max(maxY, point.y);
//			}
//		}
//		Rect rect = new Rect();
//		rect.width = maxX - minX;
//		rect.height = maxY - minY;
//		rect.left = minX;
//		rect.right = maxX;
//		rect.top = minY;
//		rect.bottom = maxY;
//		return rect;
//	}

	public static void main(String[] args) {
		LoadGesture load = new LoadGesture();
		FileInputStream fi = null;
		final GestureHolder holder = new GestureHolder();
		try {
			fi = new FileInputStream(new File(source_file));
			load.load(fi, holder);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (null != fi)
					fi.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					GestureViewer frame = new GestureViewer(holder);
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}
}
