package ogakisoft.gesture.tools;

import java.util.ArrayList;
import java.util.List;

import ogakisoft.util.Utils;

public class GestureHolder {
	private Header header;
	private long last_gesture_id;

	public GestureHolder() {
		header = new Header();
	}

	public void set(Header header) {
		this.header = header;
	}

	public List<Entry> getEntries() {
		return header.entries;
	}

	// public void setEntries(List<Entry> entries) {
	// header.entries = entries;
	// }

	public void addEntry(Entry entry) {
		header.add(entry);
	}

	public class Header {
		short fileFormatVersionNumber = 1;
		int numberOfEntries;
		List<Entry> entries;

		public Header() {
			entries = new ArrayList<Entry>();
		}

		public void add(Entry entry) {
			entries.add(entry);
			numberOfEntries = entries.size();
		}
	}

	public class Entry {
		String entryName;
		int numberOfGestures;
		List<Gesture> gestures;

		public Entry(String entryName) {
			this.entryName = entryName;
			gestures = new ArrayList<Gesture>();
		}

		public void add(Gesture gesture) {
			gestures.add(gesture);
			numberOfGestures = gestures.size();
		}
	}

	public class Gesture {
		long gestureId;
		int numberOfStrokes;
		List<Stroke> strokes;

		public Gesture() {
			gestureId = System.currentTimeMillis();
			while (last_gesture_id - gestureId == 0) {
				gestureId = Utils.currentTime();
			}
			last_gesture_id = gestureId;
			strokes = new ArrayList<Stroke>();
		}

		public void add(Stroke stroke) {
			strokes.add(stroke);
			numberOfStrokes = strokes.size();
		}

		public void setId(long id) {
			gestureId = id;
		}
	}

	public class Stroke {
		int numberOfPoints;
		List<Point> points;

		public Stroke() {
			points = new ArrayList<Point>();
		}

		public Stroke(List<Point> points) {
			this.points = points;
		}

		public void add(Point point) {
			points.add(point);
			numberOfPoints = points.size();
		}
	}

	public class Point {
		float x = 0f;
		float y = 0f;
		long timeStamp = 0;

		public Point(float x, float y, long timeStamp) {
			this.x = x;
			this.y = y;
			this.timeStamp = timeStamp;
		}
	}

	public static float[] toArray(List<Point> list) {
		int count = list.size();
		float[] results = new float[count * 2];
		Point point = null;
		int p = 0;
		for (int i = 0; i < count; i++) {
			point = list.get(i);
			results[p++] = point.x;
			results[p++] = point.y;
		}
		return results;
	}
}
