/*!
 * jQuery Rotatable Plugin v0.1
 * http://sourceforge.jp/projects/editors/
 * Copyright 2013 typista
 * Released under the MIT license
 */
(function(jQuery) {
	var imageBeingRotated = false;
	var mouseStartAngle = false;
	var imageStartAngle = false;
	jQuery.fn.extend({
        	rotatable: function( options ) {
			var options = jQuery.fn.extend(
				{
					'addClass' : 'rotatable-done',
					'saveDefault' : true
				},
				options
			);

			var width = this.width();
			var height = this.height();
			//var rotation = 0;

			$(this).on("mousedown", _mousedown);
			$(this).on("mousemove", _mousemove);
			$(this).on("mouseup", _mouseup);

			function _mousedown(e) {
				//e.preventDefault();
				if ( !e.shiftKey ) return;
				imageBeingRotated = $(this);
				//if ( $(imageBeingRotated).hasClass('ui-draggable') ) {
					//imageBeingRotated.draggable( "disable" );
				//}
				var imageCentre = getImageCentre( imageBeingRotated );
				var mouseStartXFromCentre = e.pageX - imageCentre[0];
				var mouseStartYFromCentre = e.pageY - imageCentre[1];
				mouseStartAngle = Math.atan2( mouseStartYFromCentre, mouseStartXFromCentre );
				imageStartAngle = $(imageBeingRotated).data('currentRotation');
				if ( typeof imageStartAngle === "undefined" ) {
					imageStartAngle = 0;
					$(imageBeingRotated).data('currentRotation', imageStartAngle );
				}
				$(this).mousemove( rotateImage );
				return false;
			}

			function _mousemove(e) {
				if ( !e.shiftKey ) return;
			}

			function _mouseup(e) {
				//e.preventDefault();
				//if ( $(imageBeingRotated).hasClass('ui-draggable') ) {
					//imageBeingRotated.draggable( "enable" );
				//}
				if ( !imageBeingRotated ) return;
				$(this).unbind( 'mousemove' );
				//setTimeout( function() { imageBeingRotated = false; }, 10 );
				imageBeingRotated = false;
				return true;
			}
			function rotateImage( e ) {
				if ( !e.shiftKey ) return;
				if ( !imageBeingRotated ) return;
			
				var imageCentre = getImageCentre( imageBeingRotated );
				var mouseXFromCentre = e.pageX - imageCentre[0];
				var mouseYFromCentre = e.pageY - imageCentre[1];
				var mouseAngle = Math.atan2( mouseYFromCentre, mouseXFromCentre );
			
				var rotateAngle = mouseAngle - mouseStartAngle + imageStartAngle;
			
				$(imageBeingRotated).css('transform','rotate(' + rotateAngle + 'rad)');
				$(imageBeingRotated).css('-moz-transform','rotate(' + rotateAngle + 'rad)');
				$(imageBeingRotated).css('-webkit-transform','rotate(' + rotateAngle + 'rad)');
				$(imageBeingRotated).css('-o-transform','rotate(' + rotateAngle + 'rad)');
				$(imageBeingRotated).data('currentRotation', rotateAngle );
				$(imageBeingRotated).find('.itemImage').attr('data-currentRotation', rotateAngle );
				$(imageBeingRotated).find('.image').attr('data-currentRotation', rotateAngle );
				return false;
			}
			function getImageCentre( image ) {
				$(image).css('transform','rotate(0rad)');
				$(image).css('-moz-transform','rotate(0rad)');
				$(image).css('-webkit-transform','rotate(0rad)');
				$(image).css('-o-transform','rotate(0rad)');

				var imageOffset = $(image).offset();
				var imageCentreX = imageOffset.left + $(image).width() / 2;
				var imageCentreY = imageOffset.top + $(image).height() / 2;

				var currentRotation = $(image).data('currentRotation');
				$(imageBeingRotated).css('transform','rotate(' + currentRotation + 'rad)');
				$(imageBeingRotated).css('-moz-transform','rotate(' + currentRotation + 'rad)');
				$(imageBeingRotated).css('-webkit-transform','rotate(' + currentRotation + 'rad)');
				$(imageBeingRotated).css('-o-transform','rotate(' + currentRotation + 'rad)');

				return Array( imageCentreX, imageCentreY );
			}
        	}   
	});
})(jQuery);
