package yukihane.inqubus.config;

import java.io.File;
import saccubus.worker.profile.VideoProfile;

/**
 * コンフィグに設定された値を基にしたVideoProfile実装.
 * @author yuki
 */
public class ConfigVideoProfile implements VideoProfile {

    private final boolean download;
    private final File dir;
    private final String fileName;

    public ConfigVideoProfile() {
        final Config p = Config.INSTANCE;
        this.download = !p.getVideoUseLocal();
        this.dir = new File(p.getVideoDir());
        this.fileName = p.getVideoFileNamePattern();
    }

    @Override
    public boolean isDownload() {
        return download;
    }

    @Override
    public File getDir() {
        return dir;
    }

    @Override
    public String getFileName() {
        return fileName;
    }

    @Override
    public File getLocalFile() {
        return getDir();
    }
}