#ifndef COMPUTER_M_H
#define COMPUTER_M_H

/*
	computer-m
*/

#include <stdio.h>

#define MAX_INSTRUCTION (512) 
#define MEMSIZE         (512) 

typedef enum __Computer_m_Instruction {
	CmI_ADD=0,
	CmI_SUB=1,
	CmI_MUL=2,
	CmI_DIV=3,
	CmI_MOV=4,
	CmI_EQUAL=5,
	CmI_GT =6,
	CmI_GE =7,
	CmI_JUMP=8,
	CmI_JOT=9,
	CmI_JOF=10,
	CmI_HALT=11,
	CmI_SEND=12,
	CmI_RSEND=13,
	CmI_ASEND=14,
	CmI_REC=15,
	CmI_RREC=16,
	CmI_AREC=17
} Computer_m_Instruction;

typedef struct __Computer_m_CPU  {
	char IR[MAX_INSTRUCTION];
	int  PC;
	int  CCR;
} Computer_m_CPU;

typedef char* Computer_m_CELL;

typedef struct __Computer_m_MMU {
	char* Cell[MEMSIZE];
} Computer_m_MMU;

typedef struct __Computer_m {
	FILE* inputDevice;
	FILE* outputDevice;
	FILE* programList;
	FILE* logDevice;
	Computer_m_CPU CPU;
	Computer_m_MMU MMU;
} Computer_m;

extern void comm_Read(Computer_m* comp, int mode);
extern void comm_Exec(Computer_m* comp, int mode);

#endif
