%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>The Bash Shell Startup Files</title>
@y
  <title>Bash シェルの初期起動ファイル</title>
@z

@x
  <para>The shell program <command>/bin/bash</command> (hereafter
  referred to as <quote>the shell</quote>) uses a collection of startup
  files to help create an environment to run in. Each file has a
  specific use and may affect login and interactive environments
  differently. The files in the <filename class="directory">/etc</filename>
  directory provide global settings. If an equivalent file exists in the
  home directory, it may override the global settings.</para>
@y
  <para>
  シェルプログラムである <filename>/bin/bash</filename> (これ以降は単に<quote>シェル</quote>と表現します) は、初期起動ファイルをいくつも利用して環境設定を行います。
  個々のファイルにはそれぞれに目的があり、ログインや対話環境をさまざまに制御します。
  <filename class="directory">/etc</filename> ディレクトリにあるファイルは一般にグローバルな設定を行います。
  これに対応づいたファイルがユーザーのホームディレクトリにある場合は、グローバルな設定を上書きします。
  </para>
@z

@x
  <para>An interactive login shell is started after a successful login,
  using <command>/bin/login</command>, by reading the
  <filename>/etc/passwd</filename> file. An interactive non-login shell
  is started at the command-line (e.g.,
  <prompt>[prompt]$</prompt><command>/bin/bash</command>). A
  non-interactive shell is usually present when a shell script is
  running. It is non-interactive because it is processing a script and
  not waiting for user input between commands.</para>
@y
  <para>
  対話型ログインシェルは <command>/bin/login</command> プログラムを利用して <filename>/etc/passwd</filename> ファイルを読み込み、ログインが成功することで起動します。
  同じ対話型でも非ログインシェルの場合は <prompt>[prompt]$</prompt><command>/bin/bash</command> のようなコマンドラインからの入力を経て起動します。
  非対話型のシェルはシェルスクリプト動作中に実行されます。
  非対話型であるのは、スクリプトの実行の最中にユーザーからの入力を待つことがないためです。
  </para>
@z

@x
  <para>For more information, see <command>info bash</command> under the
  <emphasis>Bash Startup Files and Interactive Shells</emphasis> section,
  and <ulink url="&cblfs-root;index.php/Bash_Startup_Files">Bash Startup
  Files</ulink> in CBLFS.</para>
@y
  <para>
  より詳しい情報は <command>info bash</command> の <emphasis>Bash Startup Files and Interactive Shells</emphasis> や CBLFS の <ulink
  url="&cblfs-root;index.php/Bash_Startup_Files">Bash Startup Files</ulink> の節を参照してください。
  </para>
@z

@x
  <para>The files <filename>/etc/profile</filename> and
  <filename>~/.bash_profile</filename> are read when the shell is
  invoked as an interactive login shell. Create a base
  <filename>/etc/profile</filename> that will read locale information from
  <filename>/etc/locale.conf</filename> and load
  any Bash auto completion files that may be on the system. This script also
  sets the <envar>INPUTRC</envar> environment variable that makes Bash and
  Readline use <filename>/etc/inputrc</filename>:</para>
@y
  <para>
  <filename>/etc/profile</filename> ファイルと <filename>~/.bash_profile</filename> ファイルは、対話型のログインシェルとして起動した時に読み込まれます。
  そこで <filename>/etc/profile</filename> を生成します。
  これは <filename>/etc/locale.conf</filename> からロケール情報を読み込みます。
  また Bash の自動補完 (auto completion) ファイルがあればこれも読み込みます。
  そして環境変数 <envar>INPUTRC</envar> を <filename>/etc/inputrc</filename> に設定して Bash と Readline がこれを利用するようにします。
  </para>
@z