%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <title>Installation of Yaboot</title>
@y
    <title>&InstallationOf1;Yaboot &InstallationOf2;</title>
@z

@x
    <para>Existing multilib distributions alter gcc to default to 32-bit
    output.  Because our gcc defaults to 64-bit, we need to pass appropriate
    options to both the compiler and the linker.  To prevent the build from
    failing due to compiler warnings, the -Werror flag is removed.  The
    Makefile already overrides any CC and ignores LDFLAGS in favour of
    its own variables, so we need to use the following seds for a
    successful compile and install.</para>
@y
    <para>
    既存のマルチライブラリ対応のディストリビューションでは gcc が 32ビットコードを生成するようにデフォルト設定されています。
    ここでは 64ビットをデフォルトとするために、コンパイラーとリンカーに対して適切なオプションを設定する必要があります。
    コンパイル時の警告によってビルドに失敗することから -Werror フラグは取り除きます。
    Makefile は CC 変数をオーバーライドし LDFLAGS は無視し、設定済みの変数を用います。
    コンパイルおよびインストールを適正に行なうために以下の sed コマンドを実行します。
    </para>
@z

@x
      <title>The meaning of the sed parameters:</title>
@y
      <title>&MeaningOfParameter1;sed &MeaningOfParameter2;</title>
@z

@x "s/\(-print-libgcc-file-name\)/${BUILD32} \1/"
          <para>This picks a convenient place within the Makefile's lgcc
          variable and inserts the flag to force <command>gcc</command> to
          create 32-bit code when compiling yaboot.</para>
@y
          <para>
          Makefile 内の lgcc 変数に対して、<command>gcc</command> が 32ビットコードを生成するようにフラグを挿入します。
          </para>
@z

@x "s/-Werror//"
          <para>This deletes the -Werror flag from the Makefile.</para>
@y
          <para>
          Makefile から -Werror フラグを削除します。
          </para>
@z

@x "s/\(-Bstatic\)/-melf32ppclinux \1/"
          <para>This picks the end of the LFLAGS which the Makefile passes to
          the linker to create the second-stage linux loader, and inserts a
          flag to force <command>ld</command> to use a suitable 32-bit
          emulation picked from the output of <command>'ld -V'</command>.</para>
@y
          <para>
          Makefile において第二ステージの Linux ローダーを生成する際のリンカー処理時の LDFLAGS を変更します。
          <command>ld</command> コマンドが 32ビットエミュレーションを利用するように <command>'ld -V'</command> の出力結果を挿入します。
          </para>
@z

@x
      <para>The multilib install of yaboot can fail if you miss any of the
      patches or seds, or omit the CFLAGS variable. <command>ld</command> will
      issue warnings, but the install will appear to complete successfully.
      That would result in an unbootable system, so you need to log the output
      to check it.</para>
@y
      <para>
      マルチライブラリによる yaboot のインストールを成功させるためには、上記のパッチ、sed コマンド、そして CFLAGS 変数の設定を必ず行わなければなりません。
      どれかをやり残した状況でも <command>ld</command> は警告エラーを出すだけで、インストールは正常に終了したかのように見えるかもしれません。
      ただそういう状況はシステムを起動させることはできません。
      ですからログ出力の結果は必ず確認してください。
      </para>
@z

@x
    <para os='g'>To ensure that the install was successful, run the following
    command:</para>
@y
    <para os='g'>
    インストールが成功したかどうかは以下のコマンドにより確認します。
    </para>
@z

@x
    <para os='i'>If the command gave you <emphasis>any</emphasis> output
    (... is incompatible with powerpc:common output) the build of yaboot is
    broken and you will have to correct your error(s) and repeat it.</para>
@y
    <para os='i'>
    このコマンド実行により ... is incompatible with powerpc:common output といった出力が<emphasis>一つ</emphasis> でもあれば、それは yaboot のビルドに失敗していることを意味します。
    その場合はビルドエラーを修正し再度インストールしてください。
    </para>
@z