%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Perl-&perl-version; 64 Bit</title>
@y
  <title>Perl-&perl-version; 64&Bit;</title>
@z

@x
    <title>Installation of Perl</title>
@y
    <title>&InstallationOf1;Perl &InstallationOf2;</title>
@z

@x
    <para os="mp1">Perl does not, by default, know about library directories
    with names other than <filename class="directory">lib</filename>. The
    following patch will allow it to install to other directories:</para>
@y
    <para os="mp1">
    Perl はデフォルトでは、ライブラリディレクトリといえば <filename class="directory">lib</filename> しか取り扱いません。
    以下のパッチにより他のディレクトリへのインストールができるようにします。
    </para>
@z

@x
    <para os="m2">We still need to tell Perl to actually use
    <filename class="directory">lib64</filename>:</para>
@y
    <para os="m2">
    そして <filename class="directory">lib64</filename> を利用することを指示します。
    </para>
@z

@x
      <title>The meaning of the new configure option:</title>
@y
      <title>&MeaningOfOption1;configure &MeaningOfOption2;</title>
@z

@x -Dlibpth="/usr/local/lib64 /lib64 /usr/lib64"
          <para>This tells Perl to link against the 64-bit libraries.</para>
@y
          <para>
          64ビットライブラリに対して Perl をリンクするようにします。
          </para>
@z

@x
    <para os="n">Now we need to create a link to the multiarch wrapper that
    lets us choose which perl installation to use:</para>
@y
    <para os="n">
    Multiarch Wrapper へのリンクを生成して perl が実行できるようにします。
    </para>
@z

@x
    <para os="p">The value of the <envar>USE_ARCH</envar> environment variable
    will decide which perl binary to execute.
    <command>USE_ARCH=32 perl -V:cc</command> will give the value of CC used to
    build the 32bit perl. The multiarch_wrapper will help later with building
    perl extensions and bindings. Without the multiarch_wrapper it is very hard
    to setup a 32bit extension or binding.</para>
@y
    <para os="p">
    環境変数 <envar>USE_ARCH</envar> の設定によってどの perl を実行するのかを選びます。
    <command>USE_ARCH=32 perl -V:cc</command> というコマンドを実行すれば、32ビット perl をビルドした際の CC の値を確認できます。
    Multiarch Wrapper は後々の Perl 拡張モジュールやバインディングをビルドする際に便利なものです。
    逆にこれがないと、32ビット拡張モジュールやバインディングの構築が相当やっかいになります。
    </para>
@z