%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Introduction</title>
@y
  <title>はじめに</title>
@z

@x
  <para os="a">In this chapter, we enter the building site and start
  constructing the CLFS system in earnest. The installation of this
  software is straightforward. Although in many cases the installation
  instructions could be made shorter and more generic, we have opted
  to provide the full instructions for every package to minimize the
  possibilities for mistakes.  The key to learning what makes a Linux
  system work is to know what each package is used for and why the user
  (or the system) needs it.  For every installed package, a summary of
  its contents is given, followed by concise descriptions of each
  program and library the package installed.</para>
@y
  <para os="a">
  この章ではビルド環境に入って正式な CLFS システムの構築作業を始めます。
  パッケージ類のインストール作業は簡単なものです。
  インストール手順の説明は、たいていは手短に一般的なものだけで済ますこともできます。
  ただ誤りの可能性を極力減らすために、個々のインストール手順の説明は十分に行うことにします。
  Linux システムがどのようにして動作しているかを学ぶには、個々のパッケージが何のために用いられていて、なぜユーザー (あるいはシステム) がそれを必要としているのかを知ることが重要になります。
  各パッケージのインストール手順においてはパッケージ構成の概要を示します。
  そしてそのパッケージがインストールするプログラムやライブラリについての細かな説明を示します。
  </para>
@z

@x
  <para os="b">If using compiler optimizations, please review the
  optimization hint at <ulink url="&hints-root;Optimization"/>.
  Compiler optimizations can make a program run slightly faster, but
  they may also cause compilation difficulties and problems when
  running the program. If a package refuses to compile when using
  optimization, try to compile it without optimization and see if
  that fixes the problem. Even if the package
  does compile when using optimization, there is the risk it may have
  been compiled incorrectly because of the complex interactions between
  the code and build tools.  Also note that the <option>-march</option>
  and <option>-mtune</option> options may cause problems with the toolchain
  packages (Binutils, GCC and Glibc). The small potential gains achieved in
  using compiler optimizations are often outweighed by the risks. First-time
  builders of CLFS are encouraged to build without custom optimizations.
  The subsequent system will still run very fast and be stable at the
  same time.</para>
@y
  <para os="b">
  コンパイラーの最適化オプションを利用する場合は、最適化に関するヒントを示した <ulink
  url="&hints-root;Optimization"/> を確認してみてください。
  コンパイラーの最適化を用いればプログラムが若干速くなる場合もありますが、そもそもコンパイルが出来なかったり、プログラムの実行時に問題が発生したりする場合があります。
  もしコンパイラーの最適化によってパッケージビルドが出来なかったら、最適化をなしにしてもう一度コンパイルすることで解決するかどうかを確認してください。
  最適化を行ってパッケージがコンパイル出来たとしても、コードとビルドツールの複雑な関連に起因してコンパイルが適切に行われないリスクをはらんでいます。
  また <option>-march</option> オプションや <option>-mtune</option> オプションは、ツールチェーン (Binutils, GCC, Glibc) において問題が発生するかもしれません。
  最適化オプションを用いることによって得られるものがあったとしても、それ以上にリスクを伴うことがしばしばです。
  初めて CLFS 構築を手がける方は、最適化オプションをなしにすることをお勧めします。
  これ以降にビルドしていくツール類は、それでも十分に速く安定して動作するはずです。
  </para>
@z

@x
  <para os="c">The order that packages are installed in this chapter needs to
  be strictly followed to ensure that no program accidentally acquires a
  path referring to <filename class="directory">/tools</filename>
  hard-wired into it. For the same reason, do not compile packages in
  parallel. Compiling in parallel may save time (especially on dual-CPU
  machines), but it could result in a program containing a hard-wired
  path to <filename class="directory">/tools</filename>, which will
  cause the program to stop working when that directory is
  removed.</para>
@y
  <para>
  本章にてインストールしていくパッケージ類のビルド順は、必ず本書どおりに行ってください。
  プログラムはすべて <filename class="directory">/tools</filename> ディレクトリを直接参照するような形でビルドしてはなりません。
  また同じ理由でパッケージ類を同時並行でビルドしないでください。
  特にデュアル CPU マシンにおいて同時にビルドしていくと時間の節約を図ることができますが <filename
  class="directory">/tools</filename> ディレクトリを直接参照するプログラムが出来上がってしまい、このディレクトリが存在しなくなった時にはプログラムが動作しないことになります。
  </para>
@z

@x
  <para os="d">To keep track of which package installs particular files, a
  package manager can be used. For a general overview of different styles of
  package managers, please take a look at the next page.</para>
@y
  <para os="d">
  各パッケージがどのようなファイルをインストールするのかを管理するには、パッケージマネージャーの利用も必要でしょう。
  パッケージマネージャーにはさまざまな特徴があります。
  全般的な概要については次ページを参照してください。
  </para>
@z