%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <secondary>cross tools</secondary>
@y
    <secondary>&CrossTools;</secondary>
@z

@x
    <title>Installation of File</title>
@y
    <title>&InstallationOf1;File &InstallationOf2;</title>
@z

@x
    <para>One method that <command>file</command> uses for identifying a given
    file is to run <quote>magic tests</quote>, where it compares the file's
    contents to data in <quote>magic files</quote>, which contain information
    about a number of standard file formats. When File is compiled, it will run
    <command>file -C</command> to combine the information from the
    magic files in its source tree into a single <filename>magic.mgc</filename>
    file, which it will use after it is installed. When we build File in 
    <xref linkend="chapter-temp-system"/>, it will be cross-compiled, so it
    will not be able to run the <command>file</command> program that it just
    built, which means that we need one that will run on the host system.</para>
@y
    <para>
    <command>file</command> が指示されたファイルを識別するには<quote>マジックテスト (magic tests)</quote>を実行します。
    これが実行されるとファイル内容と<quote>マジックファイル (magic files)</quote>内のデータを比較します。
    マジックファイルには標準的なファイルフォーマットの情報が数多く含まれています。
    File がビルドされると <command>file -C</command> が実行され、ソースディレクトリ内のマジックファイルの情報が収集されて <filename>magic.mgc</filename> という1つのファイルとなります。
    このファイルはインストール後に用いられます。
    <xref linkend="chapter-temp-system"/> では File のビルドはクロスコンパイルにより行うため、<command>file</command> プログラムをただビルドされた状態のまま実行することはできません。
    そこでホストシステム上で実行できるものをビルドする必要があります。
    </para>
@z

@x
    <para>Prepare File for compilation:</para>
@y
    <para>&PreparePackage1;File &PreparePackage2;</para>
@z

@x
      <title>The meaning of the configure options:</title>
@y
      <title>&MeaningOfOption1;configure &MeaningOfOption2;</title>
@z

@x --prefix=/cross-tools
          <para>This tells the configure script to prepare to install the
          package in the <filename class="directory">/cross-tools</filename>
          directory.</para>
@y
          <para>
          configure スクリプトに対して、パッケージのインストール先を <filename
          class="directory">/cross-tools</filename> ディレクトリにすることを指示します。
          </para>
@z

@x
    <para>Compile the package:</para>
@y
    <para>&CompileThePackage;</para>
@z

@x
    <para>Install the package:</para>
@y
    <para>&InstallThePackage;</para>
@z

@x
    <para>Details on this package are located in <xref
    linkend="contents-file" role="."/></para>
@y
    <para>
    &Details1;<xref linkend="contents-file" role=""/>&Details2;
    </para>
@z