/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.ImportPresetModel;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportPresetTableModel
extends AbstractTableModelWithComboBoxModel<ImportPresetModel> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES;
    private static final int[] COLUMN_WIDTHS;
    private String defaultPartsSetId;

    ImportPresetTableModel() {
    }

    public String getDefaultPartsSetId() {
        return this.defaultPartsSetId;
    }

    public void setDefaultPartsSetId(String defaultPartsSetId) {
        this.defaultPartsSetId = defaultPartsSetId;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0 || columnIndex == 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ImportPresetModel rowModel = (ImportPresetModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rowModel.isCheched();
            }
            case 1: {
                return rowModel.getPartsSetName();
            }
            case 2: {
                return this.getMissingPartsIdentifiersString(rowModel);
            }
        }
        return "";
    }

    private String getMissingPartsIdentifiersString(ImportPresetModel rowModel) {
        StringBuilder buf = new StringBuilder();
        for (PartsIdentifier partsIdentifier : rowModel.getMissingPartsIdentifiers()) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(partsIdentifier.getLocalizedPartsName());
        }
        return buf.toString();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ImportPresetModel rowModel = (ImportPresetModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                rowModel.setCheched((Boolean)aValue);
                break;
            }
            case 1: {
                String name = (String)aValue;
                String string = name = name != null ? name.trim() : "";
                if (name.length() > 0) {
                    rowModel.setPartsSetName(name);
                }
            }
            default: {
                return;
            }
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public boolean isDefaultPartsSet(int rowIndex) {
        ImportPresetModel rowModel = (ImportPresetModel)this.getRow(rowIndex);
        return rowModel.getPartsSet().getPartsSetId().equals(this.defaultPartsSetId);
    }

    public void adjustColumnModel(TableColumnModel columnModel) {
        int mx = columnModel.getColumnCount();
        for (int idx = 0; idx < mx; ++idx) {
            columnModel.getColumn(idx).setWidth(COLUMN_WIDTHS[idx]);
        }
    }

    public void initModel(Collection<PartsSet> partsSets, String defaultPartsSetId, CharacterData presetImportTarget) {
        this.clear();
        if (partsSets == null) {
            return;
        }
        Map<Object, Object> currentProfilesPartsSet = presetImportTarget != null ? presetImportTarget.getPartsSets() : Collections.emptyMap();
        for (PartsSet partsSet : partsSets) {
            PartsSet compatiblePartsSet;
            String partsSetId = partsSet.getPartsSetId();
            if (partsSetId == null || partsSetId.length() == 0 || (compatiblePartsSet = presetImportTarget != null ? partsSet.createCompatible(presetImportTarget) : partsSet).isEmpty()) continue;
            boolean overwrite = currentProfilesPartsSet.containsKey(partsSetId);
            boolean checked = presetImportTarget == null;
            ImportPresetModel rowModel = new ImportPresetModel(partsSet, overwrite, checked);
            this.addRow(rowModel);
        }
        this.defaultPartsSetId = defaultPartsSetId;
        this.sort();
    }

    public Collection<PartsSet> getSelectedPartsSets() {
        ArrayList<PartsSet> partsSets = new ArrayList<PartsSet>();
        for (ImportPresetModel rowModel : this.elements) {
            if (!rowModel.isCheched()) continue;
            partsSets.add(rowModel.getPartsSet());
        }
        return partsSets;
    }

    public void selectAll() {
        boolean modified = false;
        for (ImportPresetModel rowModel : this.elements) {
            if (rowModel.isCheched()) continue;
            rowModel.setCheched(true);
            modified = true;
        }
        if (modified) {
            this.fireTableDataChanged();
        }
    }

    public void deselectAll() {
        boolean modified = false;
        for (ImportPresetModel rowModel : this.elements) {
            if (!rowModel.isCheched()) continue;
            rowModel.setCheched(false);
            modified = true;
        }
        if (modified) {
            this.fireTableDataChanged();
        }
    }

    public void sort() {
        Collections.sort(this.elements, new Comparator<ImportPresetModel>(){

            @Override
            public int compare(ImportPresetModel o1, ImportPresetModel o2) {
                int ret = (o1.isCheched() ? 0 : 1) - (o2.isCheched() ? 0 : 1);
                if (ret == 0) {
                    ret = o1.getPartsSetName().compareTo(o2.getPartsSetName());
                }
                return ret;
            }
        });
        this.fireTableDataChanged();
    }

    public void checkMissingParts(Collection<PartsIdentifier> importedPartsIdentifiers) {
        boolean changed = false;
        for (ImportPresetModel rowModel : this.elements) {
            if (!rowModel.checkMissingParts(importedPartsIdentifiers)) continue;
            changed = true;
        }
        if (changed) {
            this.fireTableDataChanged();
        }
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/importwizdialog");
        COLUMN_NAMES = new String[]{strings.getProperty("preset.column.check"), strings.getProperty("preset.column.name"), strings.getProperty("preset.column.missings")};
        COLUMN_WIDTHS = new int[]{Integer.parseInt(strings.getProperty("preset.column.check.size")), Integer.parseInt(strings.getProperty("preset.column.name.size")), Integer.parseInt(strings.getProperty("preset.column.missings.size"))};
    }
}

