/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.AsyncImageBuilder;
import charactermanaj.graphics.ImageBuilder;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.model.io.PartsImageCollectionParser;
import java.io.IOException;

public abstract class ImageBuildJobAbstractAdaptor
implements AsyncImageBuilder.AsyncImageBuildJob {
    protected PartsImageCollectionParser partsImageCollectorParser;

    public ImageBuildJobAbstractAdaptor(PartsSpecResolver partsSpecResolver) {
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException();
        }
        this.partsImageCollectorParser = new PartsImageCollectionParser(partsSpecResolver);
    }

    public void loadParts(final ImageBuilder.ImageSourceCollector collector) throws IOException {
        if (collector == null) {
            throw new IllegalArgumentException("collector is null");
        }
        PartsSet partsSet = this.getPartsSet();
        if (partsSet == null) {
            throw new RuntimeException("PartsSet is null");
        }
        collector.setSize(this.partsImageCollectorParser.getPartsSpecResolver().getImageSize());
        collector.setImageBgColor(partsSet.getBgColor());
        collector.setAffineTramsform(partsSet.getAffineTransformParameter());
        this.partsImageCollectorParser.parse(partsSet, new PartsImageCollectionParser.PartsImageCollectionHandler(){

            public void detectImageSource(PartsIdentifier partsIdentifier, Layer layer, ImageResource imageResource, ColorConvertParameter param) {
                if (param == null) {
                    param = new ColorConvertParameter();
                }
                collector.setImageSource(layer, imageResource, param);
            }
        });
        collector.setComplite();
    }

    protected abstract PartsSet getPartsSet() throws IOException;

    public abstract void buildImage(ImageBuilder.ImageOutput var1);

    public abstract void handleException(Throwable var1);

    public void onAbandoned() {
    }

    public void onQueueing(long ticket) {
    }
}

