/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* POSIX Library malloc.
 */

/* @(#)$Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/kernel/POSIX/libc/malloc/malloc.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $ */
static char rcsid[] = "@(#)$Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/kernel/POSIX/libc/malloc/malloc.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $";

/*
 * $Log: malloc.c,v $
 * Revision 1.1  2011/12/27 17:13:35  liu1
 * Initial Version.
 *
 * Revision 1.1  1996-11-11 13:33:31  night
 * ǽϿ
 *
 * Revision 1.3  1995/09/21  15:52:12  night
 * եƬ Copyright notice ɲá
 *
 * Revision 1.2  1995/03/18  14:17:13  night
 * calloc(), free(), morecore() ؿɲá
 *
 * Revision 1.1  1995/03/04  16:04:45  night
 * ǽϿ
 *
 *
 */

 
#include <sys/types.h>
#include <native/syscall.h>
#include <sys/config.h>
#include <stdlib.h>


/*
 * ҡץؿ
 *
 * ץμ¹ưŪ˥/뤿δؿ
 *
 *
 * Υեˤϰʲδؿ¸ߤƤ롣
 *
 *	malloc	......	μؿ
 *	calloc	......	μؿ (mallocȤäƤ)
 *	free    ......  malloc Ǽΰβؿ
 *	realloc ......  malloc ǼΰƤ򤽤Τޤޤ
 *			礹ؿ
 *
 * ܥҡץؿǤϡե꡼δȤƥꥹȤˤ
 * եȥեåˡȤ
 * ʤmalloc Ǽΰϥե꡼ꥹȤˤ
 * ֥åΤꥹȤéäȤ˺ǽˤߤĤäʬΰ褬
 * ΤȤ
 *
 * ե꡼֥åΥꥹȤ뤿ˡ static ѿ
 * 롣
 *
 *	freelist	ե꡼֥åΥꥹȡ
 *	freepivot	˼ե꡼֥åΥ֥å
 *			ؤݥ󥿡Υݥѿλؤ֥å
 *			μΥ֥åȤγȤ
 *			롣
 *
 *
 * ƥե꡼֥åϡblock ¤ΤǴ롣
 *
 * 
 */

/*
 * ե꡼֥åΥꥹȤ뤿ι¤
 *
 */
struct block
{
  struct block	*next;		/* Υ֥å򼨤ݥ */
  size_t	size;		/* ֥åΥ	      */
  unsigned char	body[0];
};

typedef struct block block_t;

/*
 * block ¤ΤȤΥޥ
 */
#define NEXTB(xp)	(((block_t *)(xp))->next)
#define SIZEB(xp)	(((block_t *)(xp))->size)


/*
 * ΥեǻѤ static ѿ
 */
static block_t		freelist;	/* ե꡼֥å */
					/* ꥹȤƬ֥å */
					/* ʤѿ(֥åȤƤϡ */
					/*  0 ΤᡢФ˥ */
					/* Ȥʤ          */

static block_t		*freepivot;	/* μ֥å */
					/* Υ֥åؤݥ */
					/* ѿѿλؤ֥ */
					/* μΥ֥åե꡼ */
					/* ꥹȤé롣             */

static int		initialized = 0;


/*
 * ֥åΥ饤Ȥ뤿Υޥ
 *
 * Ȥˤϡɤ˺ 4 ХȤΥ饤Ȥ˹
 * 碌롣
 */
#define ALIGN(x,align)	(((((int)x) + ((align) - 1))/(align))*(align))

/*
 * ǾΥ֥åΥ
 */
#define MIN_FRAGMENT	(sizeof (block_t) * 32)


/*
 * ΥեǤΤ߻Ѥؿ (static ؿ) 
 */
static void	init_malloc (void);
static void	*malloc1 (size_t size);
static void	*morecore (size_t size);

/*
 * ν
 *
 * initialized ѿ 0 ΤȤ malloc/calloc Ƥ֤ȡδؿ¹
 * 롣
 */
static void
init_malloc (void)
{
  freelist.size = 0;
  freepivot = freelist.next = &freelist;
}


/*
 * ꤷΰ
 *
 */
void *
malloc (size_t size)
{
  /*
   * Υå
   */
  if (size <= 0) return (NULL);

  /*
   * Υ MIN_FRAGMENT ʲξˤϡ 
   * MIN_FRAGMENT ˹碌롣
   * MIN_FRAGMENT 礭ˤϡ֥åδʬ
   * 䤹
   */
  if (size < MIN_FRAGMENT)
    size = MIN_FRAGMENT;
  else
    size = ALIGN (size, 4);

  /*
   * ⤷initialized  0 ξˤϥΤ롣
   */
  if (initialized == 0)
    init_malloc ();

  return (malloc1 (size));
}


/*
 * ºݤ˥֥åΤνԤؿ
 *
 */
static void *
malloc1 (size_t size)
{
  block_t	*previous;
  block_t	*current;
  unsigned char	*p;

  /*
   * ʬ礭Ķ֥å򸡺롣
   */
  for (previous = freepivot, current = NEXTB (freepivot); 
       current != freepivot; 
       previous = current, current = NEXTB (current))
    {
      if (SIZEB (current) == size)
	{
	  /*
	   * ֥å礭׵ᤷ٥ԥåäƤ
	   * 롣
	   * ֥åݤȥꥹȤ鳰֥åΥܥǥ (body) 
	   * Υɥ쥹֤
	   * ֥å°ˤĤƤϡ˻ѤΤ
	   * ΤޤޤˤƤ
	   * freepivot ˼֥åΥ֥åΥɥ
	   * 롣
	   */
	  NEXTB (previous) = NEXTB (current);
	  freepivot = previous;
	  return ((void *)(current->body));
	}
      else if (SIZEB (current) > (size + MIN_FRAGMENT))
	{
	  /*
	   * ֥å礭ǾΥ礭
	   * ֥åθȾƤ롣
	   */
	  freepivot = previous;
	  p = (unsigned char *)current;
	  p = (p) + (SIZEB (current) - size);

	  /*
	   * ȥ֥åΥ֥åѹ롣
	   */
	  SIZEB (current) -= size;

	  /*
	   * ֥åΥܥǥ֤
	   */
	  current = (block_t *)p;
	  NEXTB (current) = NULL;
	  SIZEB (current) = size;
	  return ((void *)(current->body));
	}
    }

  /*
   * ֥åǤʤä
   * morecore() Ƥӡҡץΰĥ롣
   * ơ malloc1 Ƥ(ƵȤäƤ)
   */
  if (morecore(size))
    {
      return (malloc1 (size));
    }

  /*
   * ҡΰγ˼Ԥ
   * ǤʤΤ NULL ֤
   */
  return ((void *)NULL);
}


/*
 * ꤵ줿ĥ֥åꤵ줿Ŀ롣
 * ƥ֥åϢ³Ƥ롣
 *
 * ֥å NULL ꥢ롣
 *
 */
void *
calloc (size_t nblock, size_t size)
{
  void *p;

  size = size * nblock;
  p = malloc (size);
  if (p != (void *)NULL)
    {
      bzero (p, size);
    }
  return (p);
}


/*
 * ֥åγԤ
 *
 * malloc() Ȥäơ¸Υ֥åꤷꥵ˳
 * 롣
 * 礷֥åˤϡΥ֥åƤԡ롣
 * Υ֥åϡե꡼֥åꥹȤ᤹
 *
 */
void *
realloc (void *oldaddr, size_t newsize)
{
  void		*newaddr;
  block_t	*head;

  newaddr = malloc (newsize);
  bzero (newaddr, newsize);
  if (newaddr != NULL)
    {
      head = (block_t *) ((char *)oldaddr - sizeof (block_t));
      bcopy (oldaddr, newaddr, SIZEB (head));
      free ((void *)oldaddr);
    }
  return (newaddr);
}



/*
 * malloc ˤƼ֥åե꡼֥åꥹȤ
 * ֵѤ롣
 *
 * ֥åϡȤƼ3Ĥ롣
 *
 * 1) ե꡼ꥹΥ֥å 1 Ĥʻ礹롣
 *    (a) ֥åΥ֥åʻ
 *    (b) ֥åθΥ֥åʻ
 * 2) ե꡼ꥹΥ֥å 2 Ĥʻ礹롣
 * 3) ʻ礷ʤ֥åϡñ˥ե꡼ꥹŬ
 *    ֤롣
 *
 *
 * ֥å(뤤ϡե꡼ꥹΥ֥
 * ʻ)֤ϡξ
 *
 * current Υɥ쥹ϡ֥å⾮
 * NEXTB(current) ϡ֥å礭
 *
 * 㳰Ȥơ֥åե꡼ꥹΥ֥å
 * Τɤ⥢ɥ쥹礭礬롣
 * ξˤϡ֥åϡǤ⥢ɥ쥹ͤ礭
 * ֥åμ롣
 *
 * δؿϡ֤ͤʤ
 */
void
free (void *addr)
{
  block_t	*current;
  block_t	*addblock;

  if (addr == NULL)
    {
      return;
    }

  /*
   * Ϥ줿ɥ쥹ϡ֥åΥܥǥƬɥ쥹
   * ֥åƬɥ쥹Фaddblock ˤ
   * ɥ쥹롣
   */
  (char *)addr -= sizeof (block_t);
  addblock = addr;

  /* 
   * ֥åꥹȤˤĤʤõγ
   */
  if (freepivot < addblock)
    {
      current = NEXTB (&freelist);
    }
  else
    {
      current = freepivot;
    }

  /*
   * ֥åõ
   */
  while ((current < addblock) || (NEXTB (current) > addblock))
    {
      /* 
       * ꥹȤޤ֤ޤǤ
       */
      if (current > NEXTB (current))
	{
	  /*
	   * addblock  current 礭ˤϡ
	   * ե꡼ꥹȤΥɥ쥹礭֥å
	   * ⥢ɥ쥹礭
	   * addblock  current μƽ롣
	   */
	  if (current < addblock)
	    {
	      NEXTB (addblock) = NEXTB (current);
	      NEXTB (current) = addblock;
	      return;
	    }
	}
      current = NEXTB (current);
    }

  /*
   * ֥åϡaddblock ܤƤ롣
   * ֥åʻ礹롣
   */
  if (((char *)current + SIZEB(current)) == (char *)addblock)
    {
      SIZEB(current) += SIZEB (addblock);
      addblock = current;
    }

  /*
   * NEXTB (curernt) Υ֥åϡaddblock ܤƤ롣
   * ֥åʻ礹롣
   *
   * current  addblock ܤƤǤ⤳ΥåϹԤ
   * ξ硢current, NEXTB(current), addblock ϤҤȤĤΥ֥å
   * ޤȤ롣
   */
  if ((char *)addblock + SIZEB (NEXTB (current)))
    {
      NEXTB(addblock) = NEXTB (NEXTB (current));
      SIZEB(addblock) += SIZEB (NEXTB (current));

      /*
       * NEXTB (current)  addblock Υɥ쥹롣
       */
      if (current != addblock)
	{
	  NEXTB (current) = addblock;
	}
      return;
    }

  /*
   * ֥å򡢿֥åȤƥե꡼ꥹ
   * Ͽ롣
   */
  NEXTB (addblock) = NEXTB (current);
  NEXTB (current) = addblock;
  return;
}

/*
 * ֥å롣
 *
 * ֥åѤΥ򥷥ƥफե꡼
 * Ȥɲä롣
 *
 * δؿϡ֤ͤȤɲä֥åΥɥ쥹֤
 * 
 */
static void *
morecore (size_t grow_size)
     /*
      * grow_size	礷Υ
      */
{
  block_t	*newblock;

  grow_size = ALIGN (grow_size, PAGE_SIZE);

  /*
   * OS 鿷֥å餦
   * B-Free/POSIX ξˤϡgrowheap ƥॳѤ롣
   */
  if (growheap (grow_size, &newblock) != 0)
    {
      /* 
       * ꤬Ǥʤä
       * NULL ƤӽФ֤
       */
      return (NULL);
    }

  SIZEB (newblock) = grow_size;
  NEXTB (newblock) = (block_t *)NULL;

  /*
   * ե꡼֥åΥꥹȤˡ֥åɲä롣
   */
  free (newblock);

  /*
   *  malloc() ¹ԤȤˤϡnewblock 鸡褦
   * Ƥ
   */
  freepivot = newblock;

  /*
   * ֥å֤
   */
  return (newblock);
}
