/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* rs232c.c --- RS232C ɥ饤 (PC9801 )
 *
 * $Revision: 1.1 $
 *
 *
 * 󥿥ե
 *
 * init_rs232c		RS232C ɥ饤Фν
 *
 *
 * static ؿ
 *
 * rs232c_server	RS232C ɥ饤ФؤΥꥯȤμդ
 * rs232c_intr		RS232C ϡɥγꤳߥϥɥ
 * rs232c_read		RS232C ϡɥΥǡɤ߹
 * rs232c_write		RS232C ϡɥؤΥǡ񤭹
 * rs232c_stat		RS232C ɥ饤Фξ
 * rs232c_control	ɤ߽񤭰ʳRS232Cɥ饤Ф
 *
 */

#include "itron.h"
#include "errno.h"
#include "task.h"
#include "misc.h"
#include "func.h"
#include "interrupt.h"
#include "../io/io.h"
#include "../io/rs232c.h"


struct data_link
{
  struct data_link	*next;
  B			ch;
};


struct rs232c
{
  W	port;
  W	speed;
  W	bitlen;
  W	stoplen;
};

static ID	deviceid;	/* ǥХֹ(ǥХơ֥Υȥֹ) */
				/* ֹȤƻѤ롣*/
static ID	taskid;		/* ңӣåɥ饤ФΥɣ */

/* ΥեǻѤstaticؿ
 */
static void	rs232c_server (void);
static void	rs232c_intr (void);
static ER	rs232c_read (struct io_read_packet *);
static ER	rs232c_write (struct io_write_packet *);
static ER	rs232c_stat (struct io_stat_packet *);
static ER	rs232c_control (struct io_control_packet *);

/* ǥХåѿͤ TRUE λˤϥǥХå֤Ȥʤ
 */
static BOOL	rs232c_debug = TRUE;

/* ǥХåѤ printk 
 */
#define DPRINTK(x)	if (rs232c_debug) { printk x; }


/*****************************************************************************
 * init_rs232c --- ңӣåɥ饤
 *
 * 
 *	ʤ
 *
 * ֤͡
 *	顼ֹ
 *	E_OK	ｪλ
 *
 * ǽ
 *	RS232C νԤ
 *
 */
ER
init_rs232c (void)
{
  ER		err;
  T_CTSK	pktsk;

  err = def_dev (L"ңӣ", CHAR, ANY_DEVICE, &deviceid);
  if (err != E_OK)
    {
      printk ("cannot initialize for RS232C device. err = %d\n", err);
      return (err);
    }

  DPRINTK(("init_rs232c: setup\n"))

  pktsk.tskatr = TA_HLNG;
  pktsk.startaddr = rs232c_server;
  pktsk.itskpri = 1;
  pktsk.stksz = PAGE_SIZE * 2;
  pktsk.addrmap = NULL;
  err = new_task (&pktsk, &taskid, TRUE);
  if (err != E_OK)
    {
      printk ("cannot create task for RS232c. err = %d\n", err);
      return (err);
    }
  printk ("RS232C: TASK ID = %d\n", taskid);
  return (E_OK);
}


/*****************************************************************************
 * rs232c_server --- ɥ饤Фؤ׵åμؿ
 *
 * :
 *	ʤ
 *
 * ֤͡
 *	顼ֹ
 *
 */
static void
rs232c_server (void)
{
  T_IO_REQUEST	rcv_packet;
  T_IO_RESPONSE	res_packet;
  ER		err;
  
  printk ("RS232C: server start.\n");
  for (;;)
    {
      err = get_ioreq (deviceid, &rcv_packet);
      if (err == E_OK)
	{
	  printk ("RS232C: RReceive request %d\n", rcv_packet.command);
	  /* ޥɲ¹Ԥ */
	  switch (rcv_packet.command)
	    {
	      /* IO_NULL, IO_OPEN, IO_CLOSE ˤĤƤϲ⤷ʤ */
	    case IO_NULL:
	    case IO_OPEN:
	    case IO_CLOSE:
	      res_packet.stat = E_OK;
	      break;
	      
	    case IO_READ:
	      res_packet.stat = rs232c_read (&(rcv_packet.s.read_pack));
	      break;

	    case IO_WRITE:
	      res_packet.stat = rs232c_write (&(rcv_packet.s.write_pack));
	      break;

	    case IO_STAT:
	      res_packet.stat = rs232c_stat (&(rcv_packet.s.stat_pack));
	      break;

	    case IO_CONTROL:
	      res_packet.stat = rs232c_control (&(rcv_packet.s.control_pack));
	      break;

	    default:
	      res_packet.stat = E_PAR;
	      break;
	    }
	}
      
      put_res (deviceid, &rcv_packet, &res_packet);
    }
}


/********************************************************************************
 * rs232c_intr --- RS232C γߥϥɥ
 *
 * 
 *	ʤ
 *
 * ֤͡
 *	ʤ
 *
 * ǽ
 *
 */
static void
rs232c_intr (void)
{
  DPRINTK(("rs232c_intr\n"))
}


/**********************************************************************************
 * 
 *
 * 
 *
 * ֤͡
 *
 *
 * ǽ
 *
 */
static ER
rs232c_read (struct io_read_packet *packet)
{
  DPRINTK(("rs232c_read\n"))
}

/**********************************************************************************
 * 
 *
 * 
 *
 * ֤͡
 *
 *
 * ǽ
 *
 */
static ER	
rs232c_write (struct io_write_packet *packet)
{
  DPRINTK (("rs232c_write\n"));
}

/**********************************************************************************
 * 
 *
 * 
 *
 * ֤͡
 *
 *
 * ǽ
 *
 */
static ER
rs232c_stat (struct io_stat_packet *packet)
{
  DPRINTK (("rs232c_stat\n"));
}

/**********************************************************************************
 * 
 *
 * 
 *
 * ֤͡
 *
 *
 * ǽ
 *
 */
static ER
rs232c_control (struct io_control_packet *packet)
{
  DPRINTK (("rs232c_control\n"));
}
