/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* io.h --- ǥХɥ饤ФΤ
 *
 *
 */

#ifndef __IO_IO_H__
#define __IO_IO_H__	1

/* ǥХơ֥ */
#define UNDEF_DEVICE	-1	/* ΥȥϡȤƤʤ */
#define ANY_DEVICE	-2	/* ǤդΥǥХ */

/* ǥХɥ饤Фμ
 *
 * B-Free OS ǤΥǥХˤϡ֥åΥǥХȥ饯
 * ǥХ2ब롣
 *
 */
typedef enum io_type_t
{
  BLOCK,			/* ֥åǥХ */
  CHAR				/* 饯ǥХ */
} IO_TYPE;


/* ǥХɥ饤ФΥ顼ֹ 
 */
typedef enum
{
  IO_OK = 	0,		/* ｪλ		*/
  IO_TIMEOUT =  1,		/* ॢ		*/
  IO_PERM =     2		/* ѡߥå󥨥顼 */
} IO_ERR;


/* I/O ޥ --- ɥ饤Ф뤿Υޥ
 */
typedef enum io_command_t
{
  IO_NULL =	0x0000,		/* ⤷ʤޥ */
  IO_OPEN =	0x0001,		/* ɥ饤ФΥץ  */
				/* ٤ˤҤȤĤΥѤǤɥ饤Ф */
				/* ˻Ѥ */
  IO_CLOSE =	0x0002,		/* ɥ饤ФΥ:  */
  IO_READ =	0x0003,		/* ɥ饤ФΥǡɤ߼ */
  IO_WRITE =	0x0004,		/* ɥ饤ФؤΥǡν񤭹 */
  IO_STAT = 	0x0005,		/* ǥХ֤ɤ߼ */
  IO_CONTROL =  0x0006		/* ǥХΥȥ */
} T_IO_COMMAND;


/* IO_CONTROLޥɤǻѤ륵֥ޥ()
 *
 * ¾˥ǥХͭΥ֥ޥɤ뤳ȤǤ롣
 * ͭΥ֥ޥɤˤĤƤϡ鶦̥֥ޥɤȽŤʤʤ褦 
 * ƬΥӥåȤ1ˤ뤳(0x8000 Τ褦)
 */
#define IO_SYNC			0x0001
#define IO_ASYNC		0x0002


/* I/Oޥɤλѻ˥ɥ饤ФϤѥå */

 /* ץ˻Ѥѥå */
struct io_open_packet
{
  UINT			device;	/* ǥХֹ */
  W			mode;	/* ץ⡼ */
};

struct io_close_packet
{
  UINT			device;	/* ǥХֹ */
};

struct io_read_packet
{
  W			offset;	/* readϰ  */
				/* ǥХˤäƤϻѤʤ */
  W			size;	/* ɤ߹ॵ */
  VP			bufp;	/* ǡɤ߹ХåեؤΥݥ */
};

struct io_write_packet
{
  W			offset;	/* writeϰ */
  W			size;	/* 񤭹ॵ */
  VP			bufp;	/* ǡ񤭹ХåեؤΥݥ */
};

struct io_stat_packet
{
  W			statid;
};

struct io_control_packet
{
  W			control;
  VP			argp;
};

typedef struct io_request_t
{
  T_IO_COMMAND	command;
  ID		taskid;		/* ׵ḵΥɣ */
  ID		resport;	/* 쥹ݥѤΥݡ */

  union
    {
      struct io_open_packet	open_pack;
      struct io_close_packet	close_pack;
      struct io_read_packet	read_pack;
      struct io_write_packet	write_pack;
      struct io_stat_packet	stat_pack;
      struct io_control_packet	control_pack;
    } s;
} T_IO_REQUEST;


/* ꥯȤФ
 *
 * ΥѥåȤϡñ˥ޥɤμ¹Ԥ֤
 *
 */
typedef struct io_response_t
{
  IO_ERR		stat;
  
} T_IO_RESPONSE;


#endif	/* __IO_IO_H__ */
