/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* itron_memory.c
 *
 * itron ͤ˽򤷤Υ⥸塼
 *
 *
 * ΥեˤϡITRON ͤ˽򤷤ƥॳ
 * ¸Ƥ롣ITRONǤϡĹסǽΤ
 * ץȤĹסǽϡݡȤʤ
 * ĹסǽϡĹסǽˤä
 * Ʊν¸Ǥ뤿Ǥ롣
 *
 *
 * ITRON ǤϡʲδؿĹסǽȤƵꤵƤ롣
 *
 *	cre_mpl		ס
 *	del_mpl		Ĺסκ
 *	get_blk		Ĺ֥å
 *	pget_blk	Ĺ֥å(ݡ)
 *	tget_blk	Ĺ֥å(ॢͭ)
 *	rel_blk		Ĺ֥åֵ
 *	ref_mpl		Ĺסֻ
 * 
 * ʳδؿȤơסǽΤνΤ
 * δؿƤ롣
 *
 *	init_mpl	ס뵡ǽν
 *
 * 
 */

#include "itron.h"
#include "task.h"
#include "errno.h"
#include "func.h"
#include "misc.h"

/* ե꡼ΰ뤿ι¤Ρ
   ȤƤʤ۵ΰϡι¤Τˤä
   롣
 */
struct free_mem_entry
{
  struct free_mem_entry	*next;
  UW			size;		/* ե꡼ΰΥ (Хñ)	*/
  B			free[0];	/* ե꡼ΰƬɥ쥹 		*/
};


/* ס빽¤Ρ
 *	ס1ĤˤĤι¤Τ1ĻȤ롣
 */
struct memory_pool
{

  H		id;		/* ס ID 		*/
  UW		size;		/* סΥ 	*/
  T_TCB		*wait_tasks;	/* Υס뤫ΰꤿ wait ꥹ */
  INT		align;
  VP		area;


  /* Υס뤬뼫ͳΰΥꥹ
   */
  struct free_mem_entry	free_list;	/* ǽΥȥ (ߡ) */
  struct free_mem_entry	*pivot;		/* ߡȤƤ륨ȥؤ */
};

/* סơ֥
 * סϡMAX_MEMORY_POOL ʬǤ롣
 */
static struct memory_pool	memory_pool_table[MAX_MEMORY_POOL];

ER pget_blk (VP *pblk, ID mplid, INT blksz);


/* init_mpl	ס뵡ǽ롣
   
 */
ER
init_mpl (void)
{
  int		i;
#if 0
  struct free_mem_entry *p;
#endif

  /* סơ֥ memory_pool_table 롣
   */
  for (i = 0; i < MAX_MEMORY_POOL; i++)
    {
      memory_pool_table[i].id = -1;	/* ΥסϻѤƤʤ */
    }

  return (E_OK);
}


/* Ĺס롣
 *
 *	顼ֹ:
 *	E_ID	 ID ֹ (mplid )
 *	E_OBJ	ǤƱ ID βĹ ID ¸ߤ롣
 *
 */
ER
cre_mpl (ID mplid, T_CMPL *pk_cmpl)
{
  struct free_mem_entry *newp;

  if (mplid <= 0 || mplid > MAX_MEMORY_POOL)
    {
      return (E_ID);
    }

  /* mplid ǻꤵ줿 ID Υסν */
  if (memory_pool_table[mplid].id == mplid)	/* ǤˤΥסϽƤ */
    {
      return (E_OBJ);
    }

  memory_pool_table[mplid].id = mplid;
  memory_pool_table[mplid].size = pk_cmpl->mplsz;
  memory_pool_table[mplid].pivot = &(memory_pool_table[mplid].free_list);
  memory_pool_table[mplid].align = pk_cmpl->align;

  newp = (struct free_mem_entry *)kalloc (pk_cmpl->mplsz);
  if (newp == NULL)
    {
      /* ꤬Ǥʤä */
      return (E_NOMEM);
    }

  newp->size = pk_cmpl->mplsz;
  newp->next = &(memory_pool_table[mplid].free_list);
  memory_pool_table[mplid].free_list.next = newp;

  return (E_OK);
}


/* Ĺסκ
 *
 *	顼ֹ:
 *	E_ID	 ID ֹ
 *	E_OBJ	ǤƱ ID βĹ ID ¸ߤ롣
 *
 */
ER
del_mpl (ID mplid)
{
  if (mplid < 0 || mplid > MAX_MEMORY_POOL)
    {
      return (E_ID);
    }

  if (memory_pool_table[mplid].id != mplid)
    {
      return (E_OBJ);
    }

  /* סΰ򥷥ƥסֵѤ */
  memory_pool_table[mplid].id = NULL;
  kfree (memory_pool_table[mplid].area, memory_pool_table[mplid].size);

  return (E_OK);
}


/* Ĺ֥å
 *
 *	:
 *	pblk	
 *	mplid	֥åס ID 
 *	blksz	֥åΥ
 *
 *	֤:	顼ֹ
 *		E_OK	˥֥åϼǤ
 *		E_ID	mplid 
 *		E_OBJ	ǤƱ ID βĹ ID ¸ߤ롣
 *
 */
ER
get_blk (VP *pblk, ID mplid, INT blksz)
{
  ER			err;

retry:
  err = pget_blk (pblk, mplid, blksz);
  /* 顼ֹ椬ॢȰʳʤСΤޤޥ顼ֹ
   * ƤӽФ¦֤
   */
  if (err != E_TMOUT)
    return (err);

  /* ٤֥åդʤä
   * סΥԤˤĤʤꡢ
   * ꤬Ǥ褦ˤʤޤԤ. 
   */
  /* add_tcb_list ƤӽФΤϤ */
  memory_pool_table[mplid].wait_tasks = add_tcb_list (memory_pool_table[mplid].wait_tasks,
						      run_task);
  slp_tsk ();
  goto retry;
/* NOT REACHED */
}


/* Ĺ֥å (ݡ)
 *
 *	顼ֹ:
 *	E_ID	mplid
 *	E_OBJ	ǤƱ ID βĹ ID ¸ߤ롣
 *
 */
ER
pget_blk (VP *pblk, ID mplid, INT blksz)
{
  struct free_mem_entry	*p, *q;
  INT			align, head_size, size;

  if (mplid < 0 || mplid > MAX_MEMORY_POOL)
    {
      return (E_ID);
    }

  if (memory_pool_table[mplid].id != mplid)
    {
      return (E_OBJ);
    }

/* ǽ˼֥åΥȥס
   ƥȥΥإåȤƤ */
  align = memory_pool_table[mplid].align;
  head_size = MAX (sizeof (struct free_mem_entry), align);
  size = ROUNDUP (blksz, align);

  printk ("### pget_blk: align = %d, head_size = %d, size = %d\n",
	  align, head_size, size);

  if (mplid < 0 || mplid > MAX_MEMORY_POOL)
    {
      return (E_ID);
    }

  if (memory_pool_table[mplid].id != mplid)
    {
      return (E_OBJ);
    }

  /* סΥե꡼ꥹȤǽ˹פȥФ */
  for (p = memory_pool_table[mplid].pivot->next, q = memory_pool_table[mplid].pivot;
       p != memory_pool_table[mplid].pivot;
       q = p, p = p->next)
    {
      /* ֥åξ
       *	1) ֥åΥ
       *	ޤ
       *	2) (إåΥ + ֥åΥ) 
       *	   礭
       */
      if (p->size == size)
	{
	  /* ֥åΥˤϡ
	   * ֥åƤΥ֥åΥɥ쥹֤
	   */
	  q->next = p->next;
	  *pblk = p;
	  return (E_OK);
	}
      else if (p->size >= (size + head_size))
	{
	  /* ֥åΥ礭ˤϡ
	   * ֥åΥ򾮤ơ֥åθ֤
	   */
	  printk ("### pget_blk: p = 0x%x, p->size = 0x%x, size = 0x%x\n", 
		  p, p->size, size);
	  printk ("### pget_blk: p->size - size = %d\n", p->size - size);
	  *pblk = (VP)((W)p + ((W)(p->size) - (W)size));
	  p->size -= size;
	  printk ("### pget_blk: pblk = 0x%x, p->size = %d\n", *pblk, p->size);
	  return (E_OK);
	}
    }
  /* ٤֥åդʤäE_TMOUT ֤
   */
  return (E_TMOUT);
}


/* Ĺ֥å (ॢͭ) - ޤ
 *
 *	顼ֹ:
 *	E_ID	mplid
 *	E_OBJ	ꤵ줿 ID βĹ ID ¸ߤʤ
 *
 * 
 */
ER
tget_blk (VP *pblk, ID mplid, INT blksz, TMO tmout)
{
  if (mplid < 0 || mplid > MAX_MEMORY_POOL)
    {
      return (E_ID);
    }

  if (memory_pool_table[mplid].id != mplid)
    {
      return (E_OBJ);
    }
  return (E_OK);
}


/* Ĺ֥åֵ - ޤ
 *
 *	顼ֹ:
 *	E_ID	mplid
 *	E_OBJ	ǤƱ ID βĹ ID ¸ߤ롣
 *
 */
ER
rel_blk(ID mplid, VP blk)
{
  if (mplid < 0 || mplid > MAX_MEMORY_POOL)
    {
      return (E_ID);
    }

  if (memory_pool_table[mplid].id != mplid)
    {
      return (E_OBJ);
    }

  /*
   * ס˥֥åֵѤ롣
   */
  
  return (E_OK);
}



/* Ĺ֥åֻ
 *
 *	顼ֹ:
 *	E_ID	mplid
 *	E_OBJ	ǤƱ ID βĹ ID ¸ߤ롣
 *
 */
ER
ref_mpl	(ID mplid, T_RMPL *pk_rmpl)
{
  if (mplid < 0 || mplid > MAX_MEMORY_POOL)
    {
      return (E_ID);
    }

  if (memory_pool_table[mplid].id != mplid)
    {
      return (E_OBJ);
    }
  return (E_OK);
}


