/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* @(#)$Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/posix/usr/src/sys/lowlib/signal.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $ */
static char rcsid[] = "@(#)$Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/posix/usr/src/sys/lowlib/signal.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $";

/*
 * $Log: signal.c,v $
 * Revision 1.1  2011/12/27 17:13:35  liu1
 * Initial Version.
 *
 * Revision 1.7  1995-09-21 15:52:58  night
 * եƬ Copyright notice ɲá
 *
 * Revision 1.6  1995/09/02  09:34:54  night
 * ɲ
 *
 * Revision 1.5  1995/03/18  14:28:41  night
 * sig_stop() ؿƤ򵭽ҡ
 *
 * Revision 1.4  1995/02/21  15:23:17  night
 * ʥϥɥơ֥ѿʬ
 * ޤsig_user() ǥ桼Υʥϥɥɽѿ˵ϿȤˡ
 * 㥹ȤԤƤʤäΤǽ
 *
 * Revision 1.3  1995/02/21  15:13:39  night
 * ʥ뵡νؿ (init_signal()) εҤɲäȥʥϥ
 * ѤΥơ֥ (signal_handler[]) Ԥʤä
 * ޤʥϥɥȤưʲδؿΥȥ񤤤
 * (Ȥʤñ˴ؿ)
 *
 * 	sig_null	ñ˥ʥ̵ (IGNORE)롣
 * 	sig_user	桼ʥϥɥ¹Ԥ롣
 * 			桼ΥʥϥɥؤΥݥ󥿤ϡ
 * 			Ȥ sig_user() Ϥ
 * 	sig_core	פΤץλ롣
 * 			⤷ץ餫üǥХȷӤĤ
 * 			ƤˤϡüФ פ
 * 			Ȥɽ롣
 * 	sig_kill	ñ˥ץλ(פ⤷ʤ)
 * 	sig_stop	ץŪߤ롣
 * 	sig_cont	sig_stop ˤäưŪߤץν
 * 			Ƴ롣
 *
 * Revision 1.2  1995/02/20  15:26:34  night
 * ʥϥɥ¹Բǽ֤ˤؿinit_signal_handler_table()
 * ΤȤδؿϲ⤷Ƥʤ
 *
 * Revision 1.1  1995/02/20  15:16:44  night
 * ϤƤϿ
 *
 *
 */

/*
 * POSIX ͤ륷ʥ¸뤿δؿäƤե
 *  
 *
 * ΥեƤѿ signal_handler_table ϡ
 * ʥ ( 32 ĤޤǤ) ΤΤΤΥϥɥ
 * Ƥ롣
 *
 * ϥɥؿˤϡμब롧
 *
 *	sig_null	ñ˥ʥ̵ (IGNORE)롣
 *	sig_user	桼ʥϥɥ¹Ԥ롣
 *			桼ΥʥϥɥؤΥݥ󥿤ϡ
 *			Ȥ sig_user() Ϥ
 *	sig_core	פΤץλ롣
 *			⤷ץ餫üǥХȷӤĤ
 *			ƤˤϡüФ פ
 *			Ȥɽ롣
 *	sig_kill	ñ˥ץλ(פ⤷ʤ)
 *	sig_stop	ץŪߤ롣
 *	sig_cont	sig_stop ˤäưŪߤץν
 *			Ƴ롣
 * 
 * Υϥɥϡ桼ץ¹ԤƤ祿Ȥ̸
 * ΥʥѥǼ¹Ԥ뤳Ȥդ뤳ȡ
 *
 * POSIX ץޥ͡ϡ桼ץ˥ʥˤϡ
 * ʥѥФƥʥå롣
 * Τ˻ѤåݡȤϡinit_signal() ؿ/
 * 롣
 * 
 */

#include <sys/types.h>
#include <limits.h>
#include <sys/perrno.h>
#include <signal.h>
#include "global.h"


/*
 * 桼ʥϥɥǤ뤫ɤ򼨤
 */
#define USER_OK		1
#define USER_NOK	0


/*
 * ΥեǤΤ߻Ѥ빽¤
 */
struct signal_handler
{
  int	(*handler)();	/* ʥȤƤӽФϥɥؿ */
  void	*argp;		/* ϥɥؿϤ (ǥեȤ NULL) */
  int	user_flag;	/* 桼ʥϥɥǤ뤫Υ */
			/* 饰 */
};


/*
 * ΥեǤΤ߻Ȳǽʴؿ (static function)
 */
static int	sig_null (void *arg);	/* ⤷ʤ */
static int	sig_user (void *arg);	/* 桼ϥɥ¹ */
static int	sig_core (void *arg);	/* פ */
static int	sig_kill (void *arg);	/* λ */
static int	sig_stop (void *arg);	/* ץߤ */
static int	sig_cont (void *arg);	/* ץμ¹ԤƳ */

/*
 * ѿ (ºݤ˾ݤ)
 */

struct signal_handler signal_handler_table[MAX_SIGNAL] =
{
  { sig_core, NULL }, /* SIGHUP */
  { sig_core, NULL }, /* SIGINT */
  { sig_core, NULL }, /* SIGQUIT */
  { sig_core, NULL }, /* SIGILL */
  { sig_core, NULL }, /* SIGABRT */
  { sig_core, NULL }, /* SIGFPE */
  { sig_stop, NULL }, /* SIGTTIN */
  { sig_stop, NULL }, /* SIGTTOU */
  { sig_kill, NULL }, /* SIGKILL */
  { sig_core, NULL }, /* SIGSEGV */
  { sig_core, NULL }, /* SIGALRM */
  { sig_stop, NULL }, /* SIGSTOP */
  { sig_null, NULL }, /* SIGUSR1 */
  { sig_null, NULL }, /* SIGUSR2 */
  { sig_core, NULL }, /* SIGTERM */
  { sig_null, NULL }, /* SIGCHLD */
  { sig_stop, NULL }, /* SIGTSTP */
  { sig_cont, NULL }, /* SIGCONT */
  { sig_core, NULL }, /* SIGPIPE */
};



/*
 * ǥʥ뵡
 * 
 * 
 *	(1) ʥѤΥåݡȤν
 *	    ITRON ˤΥƥॳǥåХåե롣
 *	    åХåեϡץޥ͡ (ץ
 *	    Ȥ) Ͽ롣
 *	(2) ʥѤΥư롣
 */
int
init_signal (void)
{
  ID	sigport;

  /*
   * ʥѤΥåݡȤ롣
   */
  sigport = alloc_port ();		/* åХåեμ */

  /*
   * ʥݡȤץޥ͡Ͽ롣
   *  proc_set_signal_port () ϡPOSIX ץޥ̿͡
   * 뤿δؿ
   */
  proc_set_signal_port (my_pid, sigport);

  /*
   * ʥ뤿Υư롣
   * 󡢥ʥϢδؿ/ϿݡȤѤ롣
   */
  
}

/*
 * ʥäƤ⡢⤷ʤؿ
 */
static int
sig_null (void *arg)
{
  return (PE_OK);  /* ｪλȤ֤*/
}

/*
 * 桼ϥɥ (祿ΥƥȤ) ¹Ԥ롣
 *
 * 桼ϥɥϡĤͳ桼ץ¹ԤƤ
 * 祿¹Ԥɬפ롣
 * Τ sig_user() ϡ
 *
 *   (1) 祿ߤ (SUS_TSK)
 *   (2) ¹ԤƤ륢ɥ쥹褦å񤭴
 *   (3) Ǹ˥ʥϥɥ¹Ԥ褦ƥȾ
 *       ѹ롣
 *
 */
static int
sig_user (void *arg)
{
  int	(*user_handler)();

  user_handler = (int (*)())arg;

  sus_tsk (main_task);	/* 祿 */

  /* åν񤭴 */

  /* ƥȾν񤭴 */

  return (PE_OK);
}


/*
 * פ롣
 */
static int
sig_core (void *arg)
{
  /* 桼Υǡΰ褪ӥåΰcoreեǤФ */

}


/*
 * ץλ롣
 */
static int
sig_kill (void *arg)
{


}


/*
 * ץŪߤ롣
 *
 * ᥤ󥿥򥷥ʥ뤬äƤޤߤ롣
 *
 */
static int
sig_stop (void *arg)
{
  /*
   * ᥤ󥿥Ф slp_tsk () ¹Ԥ롣
   */
  slp_tsk (main_task);

  /*
   * ץޥ͡Фƥץ stop ֤ˤʤäȤΤ
   * 롣
   */
  
  return (PE_OK);
}


/*
 * ߤץƳ롣
 */
static int
sig_cont (void *arg)
{

}


