/* @(#)$Header: /cvsroot/bfree-info/B-Free/Program/PC9801/src/kernel/device/console/device.h,v 1.1 2011/12/27 17:13:36 liu1 Exp $ */

/*
 * $Log: device.h,v $
 * Revision 1.1  2011/12/27 17:13:36  liu1
 * Initial Version.
 *
 * Revision 1.1  1995-09-12 18:18:14  night
 * ǽϿ
 *
 *
 */

/* device.h --- ǥХɥ饤ФΤι¤Τ
 *
 */


#ifndef __DEVICE_H__
#define __DEVICE_H__	1

#define DRIVER_BUFSIZE	1024

typedef enum { CHAR_DEV, BLOCK_DEV } DEVICE_TYPE;

/**************************************************************************
 *	DEV_STATE	ǥХδ
 */
typedef struct
{
  UW	attr;		/* ǥХ°			*/
  UW	mode;		/* ߤΥ⡼			*/
  W	blksz;		/* ʪ֥å(Хȿ)		*/
  W	wptr;		/* 0:񤭹ߵ   1:񤭹߶ػ	*/
} DEV_STATE;

/***********************************************************************
 * DEVICE --- ǥХɥ饤ФΤξ
 *
 */
typedef struct 
{
  DEVICE_TYPE	type;			/* ǥХɥ饤ФΥ	  */
  TPTR		name;			/* ǥХɥ饤Ф̾	  */
  W		(*init_dev)();		/* ؿؤΥݥ	  */
  W		(*open_dev)();		/* opn_dev ƥॳǻ	  */
  W		(*close_dev)();		/* cls_dev ƥॳǻ	  */
  W		(*read_dev)();		/* rea_dev ƥॳǻ	  */
  W		(*write_dev)();		/* wri_dev ƥॳǻ	  */
  W		(*control_dev)();	/* ctl_dev ƥॳǻ	  */
  W		(*change_access)();	/* chg_dmd ƥॳǻ	  */
  W		(*dev_status)();	/* dev_sts ƥॳǻ	  */
  W		(*dev_intr)();		/* ߥϥɥ		  */
  W		intr_vec;		/* ߥ٥ֹ		  */
  W		intr_level;		/* ߥޥ٥		  */
  UW		mode;			/* ǥХΥ⡼       */
} DEVICE;


/*
 * ɥ饤ФϤޥɰ
 */
enum driver_command
{
  init_dev,
  open_dev,
  read_dev,
  write_dev,
  control_dev,
};

/*
 * ɥ饤ФȤΤȤ˻Ѥåѥå
 */
struct driver_packet
{
  enum driver_command	command;
  W			rerrno;		/* ֤ */

  W			offset;
  W			length;

  unsigned char		buf[DRIVER_BUFSIZE];
};

typedef struct driver_packet driver_packet_t;


#define DEVID(id)	(id >> 16)
#define UNIT(id)	((id >> 8) & 0xff)
#define SUBUNIT(id)	(id & 0xff)
#define MAKEDEVID(dev,unit,subunit)	((dev << 16) | (unit << 8) | subunit)

#endif __INCLUDE_DEVICE_H__
