#ifndef _HERMIT_HERMIT_PARAM_H_
#define _HERMIT_HERMIT_PARAM_H_

#if !defined(FLASH_OPTION_START)
#error FLASH_OPTION_START is not defined.
#endif

#if (FLASH_OPTION_SIZE < 0x2000)
#error FLASH_OPTION_SIZE is smaller than 0x2000.
#endif

/*
 * hermit param map:
 *
 *     HERMIT_PARAM_START +-----------------------
 *       PARAM_BOOT_START |+----------------------
 *                        || Boot Param
 *         PARAM_BOOT_END |+----------------------
 *                        || Reserved
 *     PARAM_REGION_START |+----------------------
 *                        || Dynamic Regeon Param
 *       PARAM_REGION_END |+----------------------
 *       HERMIT_PARAM_END |+----------------------
 */
#define HERMIT_PARAM_START	(FLASH_OPTION_START)
#define HERMIT_PARAM_SIZE	(FLASH_OPTION_SIZE)
#define HERMIT_PARAM_END	(HERMIT_PARAM_START + HERMIT_PARAM_SIZE)

#define PARAM_BOOT_START	(HERMIT_PARAM_START)
#define PARAM_BOOT_SIZE		(HERMIT_PARAM_SIZE - 0x0800)
#define PARAM_BOOT_END		(HERMIT_PARAM_END - 0x0800)

#define PARAM_REGION_START	(HERMIT_PARAM_END - 0x0800)
#define PARAM_REGION_SIZE	(0x0800)
#define PARAM_REGION_END	(HERMIT_PARAM_END)

/* partial_write: erase flag */
#define ERASE_PARAM_BOOT	(1 << 0)
#define ERASE_PARAM_REGION	(1 << 1)


#include <target/command.h>
void get_param(char **param, int count);
int get_param_count(void);
int check_param(char *label);
void param_partial_write(u32 start, u32 size, u8* buf, u32 erase);
int sethermit_param(int argc, char **argv, char *label);

extern const command_t setenv_command;
extern const command_t clearenv_command;

#endif
