package org.momiage.andcw;

import android.app.Activity;
import android.content.Intent;
import android.media.AudioManager;
import android.media.ToneGenerator;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;



public class MainActivity extends Activity {

	final long CW_INTERVAL=400;
	private long interval;

	ToneGenerator tg = new ToneGenerator(AudioManager.STREAM_SYSTEM, ToneGenerator.MAX_VOLUME);
	Timer tm = new Timer();

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		ImageButton btn = (ImageButton)findViewById(R.id.imageButton1);
		btn.setOnTouchListener(new View.OnTouchListener() {
			@Override
			public boolean onTouch(View v, MotionEvent event) {
				if (event.getAction() == MotionEvent.ACTION_DOWN){
					Log.v("OnTouch", "Touch Down");
					startBeep(v);
				}
				else if (event.getAction() == MotionEvent.ACTION_UP){
					Log.v("OnTouch", "Touch UP");
					endBeep(v);
				}
				return false;
			}
		});
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.activity_main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
//		Toast toast = Toast.makeText(this, item.getTitle(), Toast.LENGTH_LONG);
//		toast.show();

		switch(item.getItemId()){
			//	Config
			case R.id.item1:
				Intent i = new Intent(this, ConfigActivity.class);
				startActivity(i);
				break;
			// Mode
			case R.id.item2:
				break;
			// About
			case R.id.item3:
				break;
		}
		return true;
	}

	public void startBeep(View v) {
		TextView tv = (TextView)findViewById(R.id.textView);
		tm.start();
		if (tm.getInterval() < -(CW_INTERVAL * 1.2)) {
			tv.append(" ");
		}
		tg.startTone(ToneGenerator.TONE_CDMA_DIAL_TONE_LITE);
	}

	public void endBeep(View v) {
		TextView tv = (TextView)findViewById(R.id.textView);
		tg.stopTone();
		tm.end();
		interval = tm.getInterval();
		Log.v("Interval", String.valueOf(interval));
		if (interval < CW_INTERVAL) {
			tv.append(".");
		} else {
			tv.append("-");
		}
	}

}
