// HalSIS.h: CHalSIS NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#if !defined(_HALSIS_H__INCLUDED_)
#define _HALSIS_H__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef MAX_PATH
#define MAX_PATH 260
#endif /* MAX_PATH */

// HalSIS configuration
#define HALSIS_DEFAULT_INSTALL_DRIVE 'E'
#define HALSIS_PREFERRED_LANGUAGE 32 // Japanese

// HalSIS macro definitions
#define SIS_HEADER_SIZE 0x100
#define MAX_NUM_OF_LNGS 0x100

#define CONFIRM_INSTALLER_VER 0xC8
#define CONFIRM_INSTALLER_OFFSET 0x20

#define MCS_UNZIP_BUF_SIZE 1024


// Package info repository
typedef struct _HalSISPackage {
	int m_packageType;
	int m_FileInfo_no;
	int m_FileInfo_language;
	int m_languageCount;
	int m_FileInfo_type;
	int m_FileInfo_option;
	int	m_FileInfo_srcFileNameLength;
	int m_FileInfo_srcFileNamePointer;
	wchar_t m_FileInfo_srcFileName[MAX_PATH];
	int m_FileInfo_dstFileNameLength;
	int m_FileInfo_dstFileNamePointer;
	wchar_t m_FileInfo_dstFileName[MAX_PATH];
	int m_selectedLanguageIndex; // defined from m_SelectedLanguageIndex and FileInfo_type.
	int m_FileInfo_compressedSize[MAX_NUM_OF_LNGS];
	int m_FileInfo_originalSize[MAX_NUM_OF_LNGS];
	int m_FileInfo_offset[MAX_NUM_OF_LNGS];
} HalSISPackage;

class CHalSIS  
{
public:
	int ExtractSIS();

	void ReadHeaderTableFixedPart();
	void ReadHeaderTableDependencyPart();
	void ReadPackageInfo();
	int  ExtractPackage(HalSISPackage* pPackage);
	void CreateInstallSIS(void);

	static int decompress(FILE *dstFilePtr, FILE *sisFilePtr, size_t dataLength);
	static int getNumberFromArray(unsigned char *aTable, int aPositionOfArray, int aLength);
	static int getDirectory(char *aCompletedDirectory, char *aSourceDirectory);
	static int scanCharFromEnd(char *aTargetStrings, unsigned char aTargetChar);
	static int scanWcharFromEnd(wchar_t *aTargetStrings, wchar_t aTargetChar);
	static void convByte2Wchar(wchar_t *pDst, unsigned char *pSrc, size_t srcLength);
	static int makeDirectory(const char* absolutePath);
	int setLanguageIndex(int laguage); // This function can be called only after ReadHeaderTable function call.
	
	// constructor/desctructor
	CHalSIS();
	CHalSIS(CHalSIS* pParams);
	CHalSIS(const char* strSISFileName, const char* strDstDirectory);
	virtual ~CHalSIS();

	// member variables

	// SIS file info
	char m_sisFileName[MAX_PATH];
	FILE *m_sisFilePtr;

	// installation info
	char m_dstDirectoryName[MAX_PATH]; // destination directory
	char m_installDriveSetting; // data range: 'C' or 'E'

	// Header Information
	unsigned char m_headerBuffer[SIS_HEADER_SIZE]; // hex data

	int m_UID0;
	int m_UID1;
	int m_UID2;
	int m_UIDCheckSum;
	int m_SISCheckSum;
	int m_LanguageCount;
	int m_FileCount;
	int m_Dependency;
	int m_LanguageUsed;
	int m_NumberOfFilesAlreadyInstalled;
	int m_InstallDrive;
	int m_Capabilities;
	int m_InstallerVersion;
	int m_Flags;
	int m_Type;

	int m_Version0;
	int m_Version1;
	int m_Version2;

	int m_LanguageOffset;
	int m_PackageFilesOffset;
	int m_DependenciesOffset;
	int m_CertificatesOffset;
	int m_AppNamesOffset;
	int m_SignatureOffset;
	int m_CapabilityOffset;
	int m_SpaceUsed;
	int m_MaxInstallSize;

	int m_SelectedLanguageIndex;
	int m_PreferredLanguage; // preferred languaged given by user
//	unsigned short m_Languages[MAX_NUM_OF_LNGS];
	short m_Languages[MAX_NUM_OF_LNGS];
	// end of header info

	// Package info
	HalSISPackage *m_pPackage; // dynamic memory wil be allocated for this

	// system/install/*.SIS creation
	int m_AppNameLength;
	int m_AppNameOffset;
	wchar_t m_AppName[MAX_PATH];
	int m_totalExtractedDataAmount;

	int m_SisLength;
	int m_SisOffset;

private:
	void InitParameters();
};

#endif // !defined(_HALSIS_H__INCLUDED_)
