///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//@file  fexibleconverter.h
//brief: CӃ|[g𐶐ϊsRo[^[R|[lg
//$Date$ 2009/12/13
//@author eno 
//@mail:enoreplies@gmail.com
//@WebPage:http://www15.atpages.jp/~technotes/wiki/
//$Id$ 
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
/*
fexibleconverter

The MIT License

Copyright (c) 2009 eno <enoreplies@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
#ifndef FLEXIBLECONVERTER_H
#define FLEXIBLECONVERTER_H

#include <rtm/idl/BasicDataTypeSkel.h>
#include <rtm/Manager.h>
#include <rtm/DataFlowComponentBase.h>
#include <rtm/CorbaPort.h>
#include <rtm/DataInPort.h>
#include <rtm/DataOutPort.h>

#include <iostream>
#include <string>
#include <vector>
#include <stdlib.h>
// Service implementation headers
// <rtc-template block="service_impl_h">

// </rtc-template>

// Service Consumer stub headers
// <rtc-template block="consumer_stub_h">

// </rtc-template>

using namespace RTC;
using namespace std;
const string InPortName("In");
const string OutPortName("out");

class flexibleconverter  : public RTC::DataFlowComponentBase
{
public:
	flexibleconverter(RTC::Manager* manager);
	~flexibleconverter();

	// The initialize action (on CREATED->ALIVE transition)
	// formaer rtc_init_entry() 
	virtual RTC::ReturnCode_t onInitialize();

	// The finalize action (on ALIVE->END transition)
	// formaer rtc_exiting_entry()
	// virtual RTC::ReturnCode_t onFinalize();

	// The startup action when ExecutionContext startup
	// former rtc_starting_entry()
	// virtual RTC::ReturnCode_t onStartup(RTC::UniqueId ec_id);

	// The shutdown action when ExecutionContext stop
	// former rtc_stopping_entry()
	// virtual RTC::ReturnCode_t onShutdown(RTC::UniqueId ec_id);
	virtual int Convert(int InPortTypeID,int OutPortTypeID);

	virtual int SetInPort(int InPortTypeID);
	virtual int SetOutPort(int OutPortTypeID);
	virtual int deleteInPort(int InPortTypeID);
	virtual int deleteOutPort(int OutPortTypeID);

	virtual int ConvertSeq(int InPortTypeID,int OutPortTypeID);
	// The activated action (Active state entry action)
	// former rtc_active_entry()
	virtual RTC::ReturnCode_t onActivated(RTC::UniqueId ec_id);

	// The deactivated action (Active state exit action)
	// former rtc_active_exit()
	virtual RTC::ReturnCode_t onDeactivated(RTC::UniqueId ec_id);

	// The execution action that is invoked periodically
	// former rtc_active_do()
	virtual RTC::ReturnCode_t onExecute(RTC::UniqueId ec_id);

	// The aborting action when main logic error occurred.
	// former rtc_aborting_entry()
	// virtual RTC::ReturnCode_t onAborting(RTC::UniqueId ec_id);

	// The error action in ERROR state
	// former rtc_error_do()
	// virtual RTC::ReturnCode_t onError(RTC::UniqueId ec_id);

	// The reset action that is invoked resetting
	// This is same but different the former rtc_init_entry()
	// virtual RTC::ReturnCode_t onReset(RTC::UniqueId ec_id);

	// The state update action that is invoked after onExecute() action
	// no corresponding operation exists in OpenRTm-aist-0.2.0
	// virtual RTC::ReturnCode_t onStateUpdate(RTC::UniqueId ec_id);

	// The action that is invoked when execution context's rate is changed
	// no corresponding operation exists in OpenRTm-aist-0.2.0
	// virtual RTC::ReturnCode_t onRateChanged(RTC::UniqueId ec_id);

	int TypeCheck(string TypeName);
protected:
	// Configuration variable declaration
	// <rtc-template block="config_declare">
	double m_scale;
	string m_InPortType;
	string m_OutPortType;

	// </rtc-template>

	// DataInPort declaration
	// <rtc-template block="inport_declare">
	TimedShort InData_TimedShort;
	TimedLong InData_TimedLong;
	TimedUShort InData_TimedUShort;
	TimedULong InData_TimedULong;
	TimedFloat InData_TimedFloat;
	TimedDouble InData_TimedDouble;
	TimedChar InData_TimedChar;
	TimedBoolean InData_TimedBoolean;
	TimedOctet InData_TimedOctet;

	std::vector<InPort<TimedShort>* > InPort_TimedShort;
	std::vector<InPort<TimedLong>* > InPort_TimedLong;
	std::vector<InPort<TimedUShort>* > InPort_TimedUShort;
	std::vector<InPort<TimedULong>* > InPort_TimedULong;
	std::vector<InPort<TimedFloat>* > InPort_TimedFloat;
	std::vector<InPort<TimedDouble>* > InPort_TimedDouble;
	std::vector<InPort<TimedChar>* > InPort_TimedChar;
	std::vector<InPort<TimedBoolean>* > InPort_TimedBoolean;
	std::vector<InPort<TimedOctet>* > InPort_TimedOctet;


	TimedShortSeq InData_TimedShortSeq;
	TimedLongSeq InData_TimedLongSeq;
	TimedUShortSeq InData_TimedUShortSeq;
	TimedULongSeq InData_TimedULongSeq;
	TimedFloatSeq InData_TimedFloatSeq;
	TimedDoubleSeq InData_TimedDoubleSeq;
	TimedCharSeq InData_TimedCharSeq;
	TimedBooleanSeq InData_TimedBooleanSeq;
	TimedOctetSeq InData_TimedOctetSeq;

	std::vector<InPort<TimedShortSeq>* > InPort_TimedShortSeq;
	std::vector<InPort<TimedLongSeq>* > InPort_TimedLongSeq;
	std::vector<InPort<TimedUShortSeq>* > InPort_TimedUShortSeq;
	std::vector<InPort<TimedULongSeq>* > InPort_TimedULongSeq;
	std::vector<InPort<TimedFloatSeq>* > InPort_TimedFloatSeq;
	std::vector<InPort<TimedDoubleSeq>* > InPort_TimedDoubleSeq;
	std::vector<InPort<TimedCharSeq>* > InPort_TimedCharSeq;
	std::vector<InPort<TimedBooleanSeq>* > InPort_TimedBooleanSeq;
	std::vector<InPort<TimedOctetSeq>* > InPort_TimedOctetSeq;

	// </rtc-template>

	// DataOutPort declaration
	// <rtc-template block="outport_declare">
	TimedShort OutData_TimedShort;
	TimedLong OutData_TimedLong;
	TimedUShort OutData_TimedUShort;
	TimedULong OutData_TimedULong;
	TimedFloat OutData_TimedFloat;
	TimedDouble OutData_TimedDouble;
	TimedChar OutData_TimedChar;
	TimedBoolean OutData_TimedBoolean;
	TimedOctet OutData_TimedOctet;

	std::vector<OutPort<TimedShort>* > OutPort_TimedShort;
	std::vector<OutPort<TimedLong>* > OutPort_TimedLong;
	std::vector<OutPort<TimedUShort>* > OutPort_TimedUShort;
	std::vector<OutPort<TimedULong>* > OutPort_TimedULong;
	std::vector<OutPort<TimedFloat>* > OutPort_TimedFloat;
	std::vector<OutPort<TimedDouble>* > OutPort_TimedDouble;
	std::vector<OutPort<TimedChar>* > OutPort_TimedChar;
	std::vector<OutPort<TimedBoolean>* > OutPort_TimedBoolean;
	std::vector<OutPort<TimedOctet>* > OutPort_TimedOctet;


	TimedShortSeq OutData_TimedShortSeq;
	TimedLongSeq OutData_TimedLongSeq;
	TimedUShortSeq OutData_TimedUShortSeq;
	TimedULongSeq OutData_TimedULongSeq;
	TimedFloatSeq OutData_TimedFloatSeq;
	TimedDoubleSeq OutData_TimedDoubleSeq;
	TimedCharSeq OutData_TimedCharSeq;
	TimedBooleanSeq OutData_TimedBooleanSeq;
	TimedOctetSeq OutData_TimedOctetSeq;

	std::vector<OutPort<TimedShortSeq>* > OutPort_TimedShortSeq;
	std::vector<OutPort<TimedLongSeq>* > OutPort_TimedLongSeq;
	std::vector<OutPort<TimedUShortSeq>* > OutPort_TimedUShortSeq;
	std::vector<OutPort<TimedULongSeq>* > OutPort_TimedULongSeq;
	std::vector<OutPort<TimedFloatSeq>* > OutPort_TimedFloatSeq;
	std::vector<OutPort<TimedDoubleSeq>* > OutPort_TimedDoubleSeq;
	std::vector<OutPort<TimedCharSeq>* > OutPort_TimedCharSeq;
	std::vector<OutPort<TimedBooleanSeq>* > OutPort_TimedBooleanSeq;
	std::vector<OutPort<TimedOctetSeq>* > OutPort_TimedOctetSeq;

	// </rtc-template>

	// CORBA Port declaration
	// <rtc-template block="corbaport_declare">

	// </rtc-template>

	// Service declaration
	// <rtc-template block="service_declare">

	// </rtc-template>

	// Consumer declaration
	// <rtc-template block="consumer_declare">

	// </rtc-template>


private:
	int InPortTypeID;
	int OutPortTypeID;
	int active_count;
	Time tm;
};


extern "C"
{
	void flexibleconverterInit(RTC::Manager* manager);
};

#endif // FLEXIBLECONVERTER_H

