///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//@file  fexibleconverter.cpp
//brief: CӃ|[g𐶐ϊsRo[^[R|[lg
//$Date$ 2009/12/13
//@author eno 
//@mail:enoreplies@gmail.com
//@WebPage:http://www15.atpages.jp/~technotes/wiki/
//$Id$ 
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
/*
fexibleconverter

The MIT License

Copyright (c) 2009 eno <enoreplies@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

#include "flexibleconverter.h"


const int TimedShortType	=0;
const int TimedLongType		=1;
const int TimedUShortType	=2;
const int TimedULongType	=3;
const int TimedFloatType	=4;
const int TimedDoubleType	=5;
const int TimedCharType		=6;
const int TimedBooleanType	=7;
const int TimedOctetType	=8;

const int TimedShortSeqType		=10;
const int TimedLongSeqType		=11;
const int TimedUShortSeqType	=12;
const int TimedULongSeqType		=13;
const int TimedFloatSeqType		=14;
const int TimedDoubleSeqType	=15;
const int TimedCharSeqType		=16;
const int TimedBooleanSeqType	=17;
const int TimedOctetSeqType		=18;

// Module specification
// <rtc-template block="module_spec">
static const char* flexibleconverter_spec[] =
{
	"implementation_id", "flexibleconverter",
	"type_name",         "flexibleconverter",
	"description",       "flexible Converter Component",
	"version",           "1.0",
	"vendor",            "eno",
	"category",          "Converter",
	"activity_type",     "SPORADIC",
	"kind",              "DataFlowComponent",
	"max_instance",      "10",
	"language",          "C++",
	"lang_type",         "compile",
	// Configuration variables
	"conf.default.scale", "1.0",
	"conf.default.InPortType", "TimedLong",
	"conf.default.OutPortType", "TimedLong",
	""
};
// </rtc-template>

flexibleconverter::flexibleconverter(RTC::Manager* manager)
// <rtc-template block="initializer">
: RTC::DataFlowComponentBase(manager)
// </rtc-template>
{
	// Registration: InPort/OutPort/Service
	// <rtc-template block="registration">
	// Set InPort buffers

	// Set OutPort buffer

	// Set service provider to Ports

	// Set service consumers to Ports

	// Set CORBA Service Ports

	// </rtc-template>

}

flexibleconverter::~flexibleconverter()
{
}


int flexibleconverter::deleteOutPort(int old_OutPortTypeID){
	switch(old_OutPortTypeID){
		case TimedShortType:
			OutPort_TimedLong.clear();
			break;
		case TimedLongType:
			OutPort_TimedLong.clear();
			break;
		case TimedUShortType:
			OutPort_TimedUShort.clear();
			break;
		case TimedULongType:
			OutPort_TimedULong.clear();
			break;
		case TimedFloatType:
			OutPort_TimedFloat.clear();
			break;
		case TimedDoubleType:
			OutPort_TimedDouble.clear();
			break;
		case TimedBooleanType:
			OutPort_TimedBoolean.clear();
			break;
		case TimedOctetType:
			OutPort_TimedOctet.clear();
			break; 

		case TimedShortSeqType:
			OutPort_TimedShortSeq.clear();
			break;
		case TimedLongSeqType:
			OutPort_TimedLongSeq.clear();
			break;
		case TimedUShortSeqType:
			OutPort_TimedUShortSeq.clear();
			break;
		case TimedULongSeqType:
			OutPort_TimedULongSeq.clear();
			break;
		case TimedFloatSeqType:
			OutPort_TimedFloatSeq.clear();
			break;
		case TimedDoubleSeqType:
			OutPort_TimedDoubleSeq.clear();
			break;
		case TimedBooleanSeqType:
			OutPort_TimedBooleanSeq.clear();
			break;
		case TimedOctetSeqType:
			OutPort_TimedOctetSeq.clear();
			break; 
	}
	return 0;
}


int flexibleconverter::deleteInPort(int old_InPortTypeID){

	switch(old_InPortTypeID){
		case TimedShortType:
			InPort_TimedLong.clear();
			break;
		case TimedLongType:
			InPort_TimedLong.clear();
			break;
		case TimedUShortType:
			InPort_TimedUShort.clear();
			break;
		case TimedULongType:
			InPort_TimedULong.clear();
			break;
		case TimedFloatType:
			InPort_TimedFloat.clear();
			break;
		case TimedDoubleType:
			InPort_TimedDouble.clear();
			break;
		case TimedBooleanType:
			InPort_TimedBoolean.clear();
			break;
		case TimedOctetType:
			InPort_TimedOctet.clear();
			break; 

		case TimedShortSeqType:
			InPort_TimedShortSeq.clear();
			break;
		case TimedLongSeqType:
			InPort_TimedLongSeq.clear();
			break;
		case TimedUShortSeqType:
			InPort_TimedUShortSeq.clear();
			break;
		case TimedULongSeqType:
			InPort_TimedULongSeq.clear();
			break;
		case TimedFloatSeqType:
			InPort_TimedFloatSeq.clear();
			break;
		case TimedDoubleSeqType:
			InPort_TimedDoubleSeq.clear();
			break;
		case TimedBooleanSeqType:
			InPort_TimedBooleanSeq.clear();
			break;
		case TimedOctetSeqType:
			InPort_TimedOctetSeq.clear();
			break; 
	}
	return 0;
}

int flexibleconverter::SetInPort(int InPortTypeID){


	switch(InPortTypeID){
	case TimedShortType:
		InPort_TimedShort.push_back(new InPort<TimedShort>(InPortName.c_str(), InData_TimedShort));
		registerInPort(InPortName.c_str(), *(InPort_TimedShort.back()));
		break;

	case TimedLongType:
		InPort_TimedLong.push_back(new InPort<TimedLong>(InPortName.c_str(), InData_TimedLong));
		registerInPort(InPortName.c_str(), *(InPort_TimedLong.back()));
		break;

	case TimedUShortType:
		InPort_TimedUShort.push_back(new InPort<TimedUShort>(InPortName.c_str(), InData_TimedUShort));
		registerInPort(InPortName.c_str(), *(InPort_TimedUShort.back()));
		break;

	case TimedULongType:
		InPort_TimedULong.push_back(new InPort<TimedULong>(InPortName.c_str(), InData_TimedULong));
		registerInPort(InPortName.c_str(), *(InPort_TimedULong.back()));
		break;	

	case TimedFloatType:
		InPort_TimedFloat.push_back(new InPort<TimedFloat>(InPortName.c_str(), InData_TimedFloat));
		registerInPort(InPortName.c_str(), *(InPort_TimedFloat.back()));
		break;	

	case TimedDoubleType:
		InPort_TimedDouble.push_back(new InPort<TimedDouble>(InPortName.c_str(), InData_TimedDouble));
		registerInPort(InPortName.c_str(), *(InPort_TimedDouble.back()));
		break;	

	case TimedBooleanType:
		InPort_TimedBoolean.push_back(new InPort<TimedBoolean>(InPortName.c_str(), InData_TimedBoolean));
		registerInPort(InPortName.c_str(), *(InPort_TimedBoolean.back()));
		break;	

	case TimedOctetType:
		InPort_TimedOctet.push_back(new InPort<TimedOctet>(InPortName.c_str(), InData_TimedOctet));
		registerInPort(InPortName.c_str(), *(InPort_TimedOctet.back()));
		break;

	case TimedShortSeqType:
		InPort_TimedShortSeq.push_back(new InPort<TimedShortSeq>(InPortName.c_str(), InData_TimedShortSeq));
		registerInPort(InPortName.c_str(), *(InPort_TimedShortSeq.back()));
		break;

	case TimedLongSeqType:
		InPort_TimedLongSeq.push_back(new InPort<TimedLongSeq>(InPortName.c_str(), InData_TimedLongSeq));
		registerInPort(InPortName.c_str(), *(InPort_TimedLongSeq.back()));
		break;

	case TimedUShortSeqType:
		InPort_TimedUShortSeq.push_back(new InPort<TimedUShortSeq>(InPortName.c_str(), InData_TimedUShortSeq));
		registerInPort(InPortName.c_str(), *(InPort_TimedUShortSeq.back()));
		break;

	case TimedULongSeqType:
		InPort_TimedULongSeq.push_back(new InPort<TimedULongSeq>(InPortName.c_str(), InData_TimedULongSeq));
		registerInPort(InPortName.c_str(), *(InPort_TimedULongSeq.back()));
		break;	

	case TimedFloatSeqType:
		InPort_TimedFloatSeq.push_back(new InPort<TimedFloatSeq>(InPortName.c_str(), InData_TimedFloatSeq));
		registerInPort(InPortName.c_str(), *(InPort_TimedFloatSeq.back()));
		break;	

	case TimedDoubleSeqType:
		InPort_TimedDoubleSeq.push_back(new InPort<TimedDoubleSeq>(InPortName.c_str(), InData_TimedDoubleSeq));
		registerInPort(InPortName.c_str(), *(InPort_TimedDoubleSeq.back()));
		break;	

	case TimedBooleanSeqType:
		InPort_TimedBooleanSeq.push_back(new InPort<TimedBooleanSeq>(InPortName.c_str(), InData_TimedBooleanSeq));
		registerInPort(InPortName.c_str(), *(InPort_TimedBooleanSeq.back()));
		break;	

	case TimedOctetSeqType:
		InPort_TimedOctetSeq.push_back(new InPort<TimedOctetSeq>(InPortName.c_str(), InData_TimedOctetSeq));
		registerInPort(InPortName.c_str(), *(InPort_TimedOctetSeq.back()));
		break;

	default:
		cout<<"InPortTypeError"<<endl;
		//return RTC::RTC_ERROR;
	}

	cout<<"Port:"<<InPortName<<"/ Type:"<<m_InPortType<<" generation"<<endl;

	return 0;
}

int flexibleconverter::SetOutPort(int OutPortTypeID){


	switch(OutPortTypeID){
	case TimedShortType:
		OutPort_TimedShort.push_back(new OutPort<TimedShort>(OutPortName.c_str(), OutData_TimedShort));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedShort.back()));
		break;
	case TimedLongType:
		OutPort_TimedLong.push_back(new OutPort<TimedLong>(OutPortName.c_str(), OutData_TimedLong));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedLong.back()));
		break;
	case TimedUShortType:
		OutPort_TimedUShort.push_back(new OutPort<TimedUShort>(OutPortName.c_str(), OutData_TimedUShort));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedUShort.back()));
		break;
	case TimedULongType:
		OutPort_TimedULong.push_back(new OutPort<TimedULong>(OutPortName.c_str(), OutData_TimedULong));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedULong.back()));
		break;
	case TimedFloatType:
		OutPort_TimedFloat.push_back(new OutPort<TimedFloat>(OutPortName.c_str(), OutData_TimedFloat));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedFloat.back()));
		break;
	case TimedDoubleType:
		OutPort_TimedDouble.push_back(new OutPort<TimedDouble>(OutPortName.c_str(), OutData_TimedDouble));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedDouble.back()));
		break;
	case TimedBooleanType:
		OutPort_TimedBoolean.push_back(new OutPort<TimedBoolean>(OutPortName.c_str(), OutData_TimedBoolean));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedBoolean.back()));
		break;
	case TimedOctetType:
		OutPort_TimedOctet.push_back(new OutPort<TimedOctet>(OutPortName.c_str(), OutData_TimedOctet));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedOctet.back()));
		break;

	case TimedLongSeqType:
		OutPort_TimedLongSeq.push_back(new OutPort<TimedLongSeq>(OutPortName.c_str(), OutData_TimedLongSeq));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedLongSeq.back()));
		break;

	case TimedShortSeqType:
		OutPort_TimedShortSeq.push_back(new OutPort<TimedShortSeq>(OutPortName.c_str(), OutData_TimedShortSeq));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedShortSeq.back()));
		break;


	case TimedUShortSeqType:
		OutPort_TimedUShortSeq.push_back(new OutPort<TimedUShortSeq>(OutPortName.c_str(), OutData_TimedUShortSeq));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedUShortSeq.back()));
		break;

	case TimedULongSeqType:
		OutPort_TimedULongSeq.push_back(new OutPort<TimedULongSeq>(OutPortName.c_str(), OutData_TimedULongSeq));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedULongSeq.back()));
		break;	

	case TimedFloatSeqType:
		OutPort_TimedFloatSeq.push_back(new OutPort<TimedFloatSeq>(OutPortName.c_str(), OutData_TimedFloatSeq));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedFloatSeq.back()));
		break;	

	case TimedDoubleSeqType:
		OutPort_TimedDoubleSeq.push_back(new OutPort<TimedDoubleSeq>(OutPortName.c_str(), OutData_TimedDoubleSeq));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedDoubleSeq.back()));
		break;	

	case TimedBooleanSeqType:
		OutPort_TimedBooleanSeq.push_back(new OutPort<TimedBooleanSeq>(OutPortName.c_str(), OutData_TimedBooleanSeq));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedBooleanSeq.back()));
		break;	

	case TimedOctetSeqType:
		OutPort_TimedOctetSeq.push_back(new OutPort<TimedOctetSeq>(OutPortName.c_str(), OutData_TimedOctetSeq));
		registerOutPort(OutPortName.c_str(), *(OutPort_TimedOctetSeq.back()));
		break;
	default:
		cout<<"OutPortTypeError"<<endl;

	}
	cout<<"Port:"<<OutPortName<<"/ Type:"<<m_OutPortType<<" generation"<<endl;

	return 0;
}
RTC::ReturnCode_t flexibleconverter::onInitialize()
{
	// <rtc-template block="bind_config">
	// Bind variables and configuration variable
	bindParameter("scale", m_scale, "1.0");
	bindParameter("InPortType", m_InPortType, "TimedLong");
	bindParameter("OutPortType", m_OutPortType, "TimedDouble");

	InPortTypeID=TypeCheck(m_InPortType);
	OutPortTypeID=TypeCheck(m_OutPortType);
	active_count=0;

	//////////////////////////////////////////////////////////////////////////////////
	//Port Detection
	SetInPort(InPortTypeID);
	SetOutPort(OutPortTypeID);

	// </rtc-template>
	return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t flexibleconverter::onFinalize()
{
return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t flexibleconverter::onStartup(RTC::UniqueId ec_id)
{
return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t flexibleconverter::onShutdown(RTC::UniqueId ec_id)
{
return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t flexibleconverter::onActivated(RTC::UniqueId ec_id)
{

	int	old_InPortTypeID=InPortTypeID;
	int	old_OutPortTypeID=OutPortTypeID;

	InPortTypeID=TypeCheck(m_InPortType);
	OutPortTypeID=TypeCheck(m_OutPortType);

	//cout<<m_InPortType<<InPortTypeID<<endl;
	//cout<<m_OutPortType<<OutPortTypeID<<endl;

	if(old_InPortTypeID!=InPortTypeID) {
		deletePortByName(InPortName.c_str());
		cout<<"Port:"<<InPortName<<" delete"<<endl;
		deleteInPort(old_InPortTypeID);
		SetInPort(InPortTypeID);
	}

	if(old_OutPortTypeID!=OutPortTypeID) {
		deletePortByName(OutPortName.c_str());
		cout<<"Port:"<<OutPortName<<" delete"<<endl;
		deleteOutPort(old_OutPortTypeID);
		SetOutPort(OutPortTypeID);
	}



	active_count++;
	return RTC::RTC_OK;
}

RTC::ReturnCode_t flexibleconverter::onDeactivated(RTC::UniqueId ec_id)
{

	//	cout<<endl;

	return RTC::RTC_OK;
}

int flexibleconverter::Convert(int InPortTypeID,int OutPortTypeID){

	long double output=0.0;
	long double input=0.0;

	switch(InPortTypeID){
	case TimedShortType:
		if(InPort_TimedShort[0]->isNew())	 InPort_TimedShort[0]->read();
		input=InData_TimedShort.data;
		tm=InData_TimedShort.tm;
		break;
	case TimedLongType:
		if(InPort_TimedLong[0]->isNew())	 InPort_TimedLong[0]->read();
		input=InData_TimedLong.data;
		tm=InData_TimedLong.tm;
		break;
	case TimedUShortType:
		if(InPort_TimedUShort[0]->isNew())	 InPort_TimedUShort[0]->read();
		input=InData_TimedUShort.data;
		tm=InData_TimedUShort.tm;
		break;
	case TimedULongType:
		if(InPort_TimedULong[0]->isNew())	 InPort_TimedULong[0]->read();
		input=InData_TimedULong.data;
		tm=InData_TimedULong.tm;
		break;
	case TimedFloatType:
		if(InPort_TimedFloat[0]->isNew())	 InPort_TimedFloat[0]->read();
		input=InData_TimedFloat.data;
		tm=InData_TimedFloat.tm;
		break;
	case TimedDoubleType:
		if(InPort_TimedDouble[0]->isNew())	 InPort_TimedDouble[0]->read();
		input=InData_TimedDouble.data;
		tm=InData_TimedDouble.tm;
		break;
	case TimedBooleanType:
		if(InPort_TimedBoolean[0]->isNew())	 InPort_TimedBoolean[0]->read();
		input=InData_TimedBoolean.data;
		tm=InData_TimedBoolean.tm;
		break;
	case TimedOctetType:
		if(InPort_TimedOctet[0]->isNew())	 InPort_TimedOctet[0]->read();
		input=InData_TimedOctet.data;
		tm=InData_TimedOctet.tm;
		break; 
	default:
		cout<<"OutPortTypeError"<<endl;
		input=0;
		//	return RTC::RTC_ERROR;
	}

	////////////////////////
	//Convert
	output=input*m_scale;
	//////////////////////
	//	cout<<"in:"<<input<<"\t"<<"scale:"<<m_scale<<"\t"<<"out:"<<output<<endl;

	switch(OutPortTypeID){
	case TimedShortType:
		OutData_TimedShort.data=static_cast<short int>(output);
		OutData_TimedShort.tm=tm;		
		OutPort_TimedShort[0]->write();
		break;
	case TimedLongType:
		OutData_TimedLong.data=static_cast<long>(output);
		OutData_TimedLong.tm=tm;		
		OutPort_TimedLong[0]->write();
		break;
	case TimedUShortType:
		OutData_TimedUShort.data=static_cast<unsigned short>(output);
		OutData_TimedUShort.tm=tm;		
		OutPort_TimedUShort[0]->write();
		break;
	case TimedULongType:
		OutData_TimedULong.data=static_cast<unsigned long>(output);
		OutData_TimedULong.tm=tm;		
		OutPort_TimedULong[0]->write();
		break;
	case TimedFloatType:
		OutData_TimedFloat.data=static_cast<float>(output);
		OutData_TimedFloat.tm=tm;		
		OutPort_TimedFloat[0]->write();
		break;
	case TimedDoubleType:
		OutData_TimedDouble.data=static_cast<double>(output);
		OutData_TimedDouble.tm=tm;		
		OutPort_TimedDouble[0]->write();

		break;
	case TimedBooleanType:
		if(output==0.0)
			OutData_TimedBoolean.data=false;
		else
			OutData_TimedBoolean.data=true;
		OutData_TimedBoolean.tm=tm;		
		OutPort_TimedBoolean[0]->write();
		break;
	case TimedOctetType:
		OutData_TimedOctet.data=static_cast<char>(output);
		OutData_TimedOctet.tm=tm;		
		OutPort_TimedOctet[0]->write();
		break;



	default:
		cout<<"OutPortTypeError"<<endl;
		//return RTC::RTC_ERROR;
	}

	return RTC::RTC_OK;
}


int flexibleconverter::ConvertSeq(int InPortTypeID,int OutPortTypeID){
	vector<long double> outputseq;
	vector<long double> inputseq;
	int vector_size(1);

	switch(InPortTypeID){
	case TimedShortSeqType:
		if(InPort_TimedShortSeq[0]->isNew())	 
			InPort_TimedShortSeq[0]->read();
		vector_size=InData_TimedShortSeq.data.length();
		inputseq.resize(vector_size);
		outputseq.resize(vector_size);

		for(int i=0;i<vector_size;i++){
			inputseq[i]=static_cast<long double>(InData_TimedShortSeq.data[i]);
		}
		tm=InData_TimedShortSeq.tm;
		break;

	case TimedLongSeqType:
		if(InPort_TimedLongSeq[0]->isNew())	 
			InPort_TimedLongSeq[0]->read();
		vector_size=InData_TimedLongSeq.data.length();
		inputseq.resize(vector_size);
		outputseq.resize(vector_size);

		for(int i=0;i<vector_size;i++){
			inputseq[i]=static_cast<long double>(InData_TimedLongSeq.data[i]);
		}
		tm=InData_TimedLongSeq.tm;
		break;

	case TimedUShortSeqType:
		if(InPort_TimedUShortSeq[0]->isNew())	 
			InPort_TimedUShortSeq[0]->read();
		vector_size=InData_TimedUShortSeq.data.length();
		inputseq.resize(vector_size);
		outputseq.resize(vector_size);

		for(int i=0;i<vector_size;i++){
			inputseq[i]=static_cast<long double>(InData_TimedUShortSeq.data[i]);
		}
		tm=InData_TimedUShortSeq.tm;
		break;



	case TimedFloatSeqType:
		if(InPort_TimedFloatSeq[0]->isNew())	 
			InPort_TimedFloatSeq[0]->read();
		vector_size=InData_TimedFloatSeq.data.length();
		inputseq.resize(vector_size);
		outputseq.resize(vector_size);

		for(int i=0;i<vector_size;i++){
			inputseq[i]=static_cast<long double>(InData_TimedFloatSeq.data[i]);
		}
		tm=InData_TimedFloatSeq.tm;
		break;


	case TimedDoubleSeqType:
		if(InPort_TimedDoubleSeq[0]->isNew())	 
			InPort_TimedDoubleSeq[0]->read();
		vector_size=InData_TimedDoubleSeq.data.length();
		inputseq.resize(vector_size);
		outputseq.resize(vector_size);

		for(int i=0;i<vector_size;i++){
			inputseq[i]=static_cast<long double>(InData_TimedDoubleSeq.data[i]);
		}
		tm=InData_TimedDoubleSeq.tm;
		break;

	case TimedBooleanSeqType:
		if(InPort_TimedBooleanSeq[0]->isNew())	 
			InPort_TimedBooleanSeq[0]->read();
		vector_size=InData_TimedBooleanSeq.data.length();
		inputseq.resize(vector_size);
		outputseq.resize(vector_size);

		for(int i=0;i<vector_size;i++){
			inputseq[i]=static_cast<long double>(InData_TimedBooleanSeq.data[i]);
		}
		tm=InData_TimedBooleanSeq.tm;
		break;


	case TimedOctetSeqType:
		if(InPort_TimedOctetSeq[0]->isNew())	 
			InPort_TimedOctetSeq[0]->read();
		vector_size=InData_TimedOctetSeq.data.length();
		inputseq.resize(vector_size);
		outputseq.resize(vector_size);

		for(int i=0;i<vector_size;i++){
			inputseq[i]=static_cast<long double>(InData_TimedOctetSeq.data[i]);
		}
		tm=InData_TimedOctetSeq.tm;
		break;
	default:
		cout<<"OutPortTypeError"<<endl;
	}

	////////////////////////
	//Convert
	for(int i=0;i<vector_size;i++){
		outputseq[i]=inputseq[i]*m_scale;
		//cout<<"in:"<<inputseq[i]<<" "<<"scale:"<<m_scale<<" "<<"out:"<<outputseq[i]<<endl;

	}

	switch(OutPortTypeID){
	case TimedShortSeqType:
		OutData_TimedShortSeq.data.length(vector_size);
		for(int i=0;i<vector_size;i++){
			OutData_TimedShortSeq.data[i]=static_cast<short>(outputseq[i]);
			//cout<<OutData_TimedShortSeq.data[i]<<" ";
		}
		//cout<<endl;
		OutData_TimedShortSeq.tm=tm;		
		OutPort_TimedShortSeq[0]->write();
		break;


	case TimedLongSeqType:
		OutData_TimedLongSeq.data.length(vector_size);
		for(int i=0;i<vector_size;i++){
			OutData_TimedLongSeq.data[i]=static_cast<long>(outputseq[i]);
			//cout<<OutData_TimedLongSeq.data[i]<<" ";
		}
		//cout<<endl;
		OutData_TimedLongSeq.tm=tm;		
		OutPort_TimedLongSeq[0]->write();
		break;

	case TimedUShortSeqType:
		OutData_TimedUShortSeq.data.length(vector_size);
		for(int i=0;i<vector_size;i++){
			OutData_TimedUShortSeq.data[i]=static_cast<unsigned short>(outputseq[i]);
			//cout<<OutData_TimedUShortSeq.data[i]<<" ";
		}
		//cout<<endl;
		OutData_TimedUShortSeq.tm=tm;		
		OutPort_TimedUShortSeq[0]->write();
		break;

	case TimedULongSeqType:
		OutData_TimedULongSeq.data.length(vector_size);
		for(int i=0;i<vector_size;i++){
			OutData_TimedULongSeq.data[i]=static_cast<unsigned long>(outputseq[i]);
			//cout<<OutData_TimedULongSeq.data[i]<<" ";
		}
		//cout<<endl;
		OutData_TimedULongSeq.tm=tm;		
		OutPort_TimedULongSeq[0]->write();
		break;

	case TimedFloatSeqType:
		OutData_TimedFloatSeq.data.length(vector_size);
		for(int i=0;i<vector_size;i++){
			OutData_TimedFloatSeq.data[i]=static_cast<float>(outputseq[i]);
			//cout<<OutData_TimedFloatSeq.data[i]<<" ";
		}
		//cout<<endl;
		OutData_TimedFloatSeq.tm=tm;		
		OutPort_TimedFloatSeq[0]->write();
		break;

	case TimedDoubleSeqType:
		OutData_TimedDoubleSeq.data.length(vector_size);
		for(int i=0;i<vector_size;i++){
			OutData_TimedDoubleSeq.data[i]=static_cast<double>(outputseq[i]);
			//cout<<OutData_TimedDoubleSeq.data[i]<<" ";
		}
		//cout<<endl;
		OutData_TimedDoubleSeq.tm=tm;		
		OutPort_TimedDoubleSeq[0]->write();
		break;

	case TimedBooleanSeqType:
		OutData_TimedBooleanSeq.data.length(vector_size);
		for(int i=0;i<vector_size;i++){
			if(outputseq[i]==0.0)			OutData_TimedBooleanSeq.data[i]=false;
			else OutData_TimedBooleanSeq.data[i]=true;
			//cout<<OutData_TimedBooleanSeq.data[i]<<" ";
		}
		//cout<<endl;
		OutData_TimedBooleanSeq.tm=tm;		
		OutPort_TimedBooleanSeq[0]->write();
		break;

	case TimedOctetSeqType:
		OutData_TimedOctetSeq.data.length(vector_size);
		for(int i=0;i<vector_size;i++){
			OutData_TimedOctetSeq.data[i]=static_cast<char>(outputseq[i]);
			//cout<<OutData_TimedOctetSeq.data[i]<<" ";
		}
		//cout<<endl;
		OutData_TimedOctetSeq.tm=tm;		
		OutPort_TimedOctetSeq[0]->write();
		break;



	default:
		cout<<"OutPortTypeError"<<endl;
		//return RTC::RTC_ERROR;
	}
	return RTC::RTC_OK;
}

RTC::ReturnCode_t flexibleconverter::onExecute(UniqueId ec_id) {


	if((InPortTypeID<10)&&(OutPortTypeID<10))
		Convert( InPortTypeID, OutPortTypeID);
	else if((InPortTypeID>=10)&&(OutPortTypeID>=10)) 
		ConvertSeq( InPortTypeID, OutPortTypeID);
	else 
		cout<<"Error: SinglePort and Sequence Port"<<endl;

	return RTC::RTC_OK;
}
/*
RTC::ReturnCode_t flexibleconverter::onAborting(RTC::UniqueId ec_id)
{
return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t flexibleconverter::onError(RTC::UniqueId ec_id)
{
return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t flexibleconverter::onReset(RTC::UniqueId ec_id)
{
return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t flexibleconverter::onStateUpdate(RTC::UniqueId ec_id)
{
return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t flexibleconverter::onRateChanged(RTC::UniqueId ec_id)
{
return RTC::RTC_OK;
}
*/
int flexibleconverter::TypeCheck(string TypeName){
	if(TypeName=="TimedShort")		return TimedShortType;
	else if(TypeName=="TimedLong")		return TimedLongType;
	else if(TypeName=="TimedUShort")		return TimedUShortType;
	else if(TypeName=="TimedULong")		return TimedULongType;
	else if(TypeName=="TimedFloat")		return TimedFloatType;
	else if(TypeName=="TimedDouble")		return TimedDoubleType;
	else if(TypeName=="TimedChar")		return TimedCharType;
	else if(TypeName=="TimedBoolean")	return TimedBooleanType;
	else if(TypeName=="TimedOctet")		return TimedOctetType;

	else if(TypeName=="TimedShortSeq")		return TimedShortSeqType;
	else if(TypeName=="TimedLongSeq")		return TimedLongSeqType;
	else if(TypeName=="TimedUShortSeq")		return TimedUShortSeqType;
	else if(TypeName=="TimedULongSeq")		return TimedULongSeqType;
	else if(TypeName=="TimedFloatSeq")		return TimedFloatSeqType;
	else if(TypeName=="TimedDoubleSeq")		return TimedDoubleSeqType;
	else if(TypeName=="TimedCharSeq")		return TimedCharSeqType;
	else if(TypeName=="TimedBooleanSeq")	return TimedBooleanSeqType;
	else if(TypeName=="TimedOctetSeq")		return TimedOctetSeqType;

	else return -1;
}

extern "C"
{

	void flexibleconverterInit(RTC::Manager* manager)
	{
		RTC::Properties profile(flexibleconverter_spec);
		manager->registerFactory(profile,
			RTC::Create<flexibleconverter>,
			RTC::Delete<flexibleconverter>);
	}

};



