<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
					doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
					 doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template match="COUNT_AND_SIZE">
	<tr>
	<xsl:attribute name="class">
		<xsl:choose>
			<xsl:when test="0 = (position() mod 2)">tr2</xsl:when>
			<xsl:otherwise>tr1</xsl:otherwise>
		</xsl:choose>
	</xsl:attribute>
	
	<td align="right">(<xsl:value-of select="@key"/>)</td>
	<td align="right"><xsl:value-of select="@countAll"/></td>
	<td align="right"><xsl:value-of select="@countLost"/></td>
	<td align="right"><xsl:value-of select="@countComplete"/></td>
	<td align="right"><xsl:value-of select="@countIncomplete"/></td>
	<td align="right"><xsl:value-of select="@sizeAll"/></td>
	<td align="right"><xsl:value-of select="@countUnidentified"/></td>
	</tr>
</xsl:template>

<xsl:template match="CONTACT">
	<li><xsl:value-of select="."/></li>
</xsl:template>

<xsl:template name="formattime">
<xsl:param name="ms"/>
	<xsl:value-of select="floor($ms div 3600000)"/>
	<xsl:text>:</xsl:text>
	<xsl:value-of select="floor( ($ms div 60000) mod 60 )"/>
	<xsl:text>:</xsl:text>
	<xsl:value-of select="floor( ($ms div 1000) mod 60 )"/>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>

<xsl:template match="SIMPLE_CONTENTS_AND_VARIATION">
	<li><a href="{URL}"><xsl:value-of select="URL"/></a></li>
</xsl:template>

<xsl:template match="NEST_TABLE_CONTENTS_AND_VARIATION">
	<li>
		[<xsl:value-of select="MAX_NEST_TABLE"/>]
		<a href="{URL}"><xsl:value-of select="URL"/></a>
	</li>
</xsl:template>

<xsl:template match="WRONG_CHAR">
	<li>機種依存文字使用ページ
		<div class="boxscrl">
			<ol>
				<xsl:apply-templates select="SIMPLE_CONTENTS_AND_VARIATION"/>
			</ol>
		</div>
	</li>
</xsl:template>

<xsl:template match="HALF_KANA">
	<li>半角カタカナ文字使用ページ
		<div class="boxscrl">
			<ol>
				<xsl:apply-templates select="SIMPLE_CONTENTS_AND_VARIATION"/>
			</ol>
		</div>
	</li>
</xsl:template>

<xsl:template match="TABLE_NEST">
	<li>table多重使用ページ(三重以上)
		<div class="boxscrl">
			<ol>
				<xsl:apply-templates select="NEST_TABLE_CONTENTS_AND_VARIATION"/>
			</ol>
		</div>
	</li>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	
	<head>
	<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
	<title>Ridual：Overview</title>
	<link rel="index" href="index.html"/>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="css/import_style.css" rel="stylesheet"
									 type="text/css" media="screen,print"/>
	<link href="css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="overview">

	<!-- #layout -->
	<div id="layout">

	<xsl:apply-templates select="RidualReportOverview"/>

	<hr/>

	<!-- #footer -->
	<div id="footer">
		<p>
			<img alt="Powered by Nomura Research Institute,Ltd."
				title="Powered by Nomura Research Institute,Ltd."
					height="15" width="300" src="img/logo_nri.gif"/>
		</p>
	</div>
	<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualReportOverview">
	<xsl:apply-templates select="ANALYZE_HISTORY"/>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<xsl:variable name="startURL" select="ANALYZE_SITE_CONFIG/START_URIS"/>

	<!-- #header -->
	<div id="header">

	<!-- #logo -->	
	<div id="logo">
		<div class="ridual">
			<a target="_blank" href="http://www.ridual.jp">
				<img alt="Ridual logo" height="30" width="70"
											src="img/R_logo.gif"/>
			</a>
			<xsl:apply-templates select="../RIDUAL_VERSION"/>
		</div>
	</div>
	<!-- /#logo -->	

	<!-- #line -->
	<div id="line">
		<p>
			<a target="_blank" href="{$startURL}">
				<xsl:value-of select="$startURL"/>
			</a>
		</p>
	</div>
	<!-- /#line -->

	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="index.html">Overview</a></li>
			<li class="sitemap"><a name="sitemap.html">Sitemap</a></li>
			<li class="pages"><a href="pages.html">Pages</a></li>
			<li class="resources"><a href="resources.html">Resources</a></li>
			<li class="outlink"><a href="outlink.html">OutLink</a></li>
			<li class="form"><a href="form.html">Form</a></li>
			<li class="script"><a href="script.html">Script</a></li>
			<li class="css"><a href="css.html">CSS</a></li>
			<li class="objects"><a href="objects.html">Objects</a></li>
			<li class="lost"><a href="lost.html">Lost</a></li>
			<li class="quality"><a href="quality.html">Quality</a></li>
			<li class="report"><a href="report.html">Report</a></li>
			<li class="datalist"><a name="data.html">Data</a></li>
		</ul>
	</div>
	<!-- /#menu -->
	
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<h1>OverView</h1>
		<p class="countn">count = 
			<xsl:choose>
				<xsl:when test="count(SUM_EXTENSION/COUNT_AND_SIZE[@key='.html'])!=0">
					<xsl:value-of select="number(SUM_EXTENSION/COUNT_AND_SIZE[@key='.html']/@countAll)"/>
				</xsl:when>
				<xsl:otherwise>
					0
				</xsl:otherwise>
			</xsl:choose>
			<span class="cdate">( checked on <xsl:value-of select="TIMESTAMP_BEGIN"/> )</span>
		</p>
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">

	<!-- #summary -->
	<div id="summary">


	<!--ctitle-->
	<div class="ctitle">
	<h2>解析情報</h2>
	<a name="top">[Top]</a>
	</div>
	<!--ctitle-->
	<ul>
		<li>URL : <xsl:value-of select="$startURL"/></li>
		<li>
			<p>解析日時 / 解析状況</p>
			<p>
				<xsl:value-of select="TIMESTAMP_BEGIN"/>
				(解析所要時間=<xsl:call-template name="formattime">
					<xsl:with-param name="ms" select="number(TIME_DISTANCE)"/>
				</xsl:call-template>,
				解析link数=<xsl:value-of select="COUNT_RELATIONS"/>)
			</p>
		</li>
		<li>
			<p>解析条件</p>
			<p>
<!--
				Depth-limit:<xsl:value-of select="ANALYZE_SITE_CONFIG/DEPTH_LIMIT"/>,
				File-count-limit:<xsl:value-of select="ANALYZE_SITE_CONFIG/FILE_COUNT_LIMIT"/>,
-->
				Depth-limit:<xsl:value-of select="DEPTH_LIMIT"/>,
				File-count-limit:<xsl:value-of select="PAGES_LIMIT"/>,
				Profile:<xsl:value-of select="ANALYZE_SITE_CONFIG/RATING_PROFILE/NAME"/>
			</p>
		</li>

		<li>inner-URL:<xsl:value-of select="ANALYZE_SITE_CONFIG/INNER_SITE_PATHS"/></li>
	</ul>

	<!--ctitle-->
	<div class="ctitle">
	<h2>サイト情報</h2>
	<a href="#top">[Top]</a>
	</div>
	<!--ctitle-->
	<ul>
		<xsl:apply-templates select="CONTACT"/>
	</ul>

	<!--ctitle-->
	<div class="ctitle">
	<h2>エラー系ページ情報</h2>
	<a href="#top">[Top]</a>
	</div>
	<!--ctitle-->
	<ul class="problempages">
		<xsl:apply-templates select="WRONG_CHAR"/>
		<xsl:apply-templates select="HALF_KANA"/>
		<xsl:apply-templates select="TABLE_NEST"/>
	</ul>

	</div>
	<!-- /summary -->

	<!--ctitle-->
	<div class="ctitle">
	<h2>拡張子分布</h2>
	<a href="#top">[Top]</a>
	</div>
	<!--ctitle-->
	<xsl:apply-templates select="SUM_EXTENSION"/>
	
	<!--ctitle-->
	<div class="ctitle">
	<h2>Content-Type分布</h2>
	<a href="#top">[Top]</a>
	</div>
	<!--ctitle-->
	<xsl:apply-templates select="SUM_CONTENT_TYPE"/>
	
	<!--ctitle-->
	<div class="ctitle">
	<a href="#top">[Top]</a>
	<h2>サイト内/外分布</h2>
	</div>
	<!--ctitle-->
	<xsl:apply-templates select="SUM_IS_INNER"/>

	</div>
	<!-- /#content -->
</xsl:template>
		
<xsl:template match="SUM_EXTENSION">
	<!-- .box -->
	<div class="box">
	
	<table summary="ページ内の拡張子の数やサイズを計算したものです。">
		<tr>
    		<th class="th1">ファイル分類(拡張子)</th>
    		<th class="th1">ファイル総数</th>
    		<th class="th1">LOST数</th>
    		<th class="th1">解析完了数</th>
    		<th class="th1">未解析数</th>
    		<th class="th1">総サイズ(Byte)</th>
    		<th class="th1">サイズ不明ファイル数</th>
		</tr>

		<xsl:apply-templates select="COUNT_AND_SIZE"/>
	</table>
	
	</div>
	<!-- /.box -->
</xsl:template>

<xsl:template match="SUM_CONTENT_TYPE">
	<!-- .box -->
	<div class="box">
	
	<table summary="Content-Typeの解析、数値化したもの">
		<tr>
			<th class="th1">ファイル分類(Content-Type)</th>
			<th class="th1">ファイル総数</th>
			<th class="th1">LOST数</th>
			<th class="th1">解析完了数</th>
			<th class="th1">未解析数</th>
			<th class="th1">総サイズ(Byte)</th>
			<th class="th1">サイズ不明ファイル数</th>
		</tr>

		<xsl:apply-templates select="COUNT_AND_SIZE"/>
	</table>
	
	</div>
	<!-- /.box -->
</xsl:template>

<xsl:template match="SUM_IS_INNER">
	<!-- .box -->
	<div class="box">

	<table summary="サイト内/外のパラメータを解析">
		<tr>
			<th class="th1">カウント方法</th>
			<th class="th1">内部URL数</th>
			<th class="th1">外部URL数</th>
		</tr>
		
		<tr class="tr1">
			<td class="lt">パラメータが異なっていても同じファイルとしてカウント</td>
			<td><xsl:value-of select="@innerContents"/></td>
			<td><xsl:value-of select="@outerContents"/></td>
		</tr>
			
		<tr class="tr2">
			<td class="lt">パラメータが異なるものは別ファイルとしてカウント</td>
			<td><xsl:value-of select="@innerVariation"/></td>
			<td><xsl:value-of select="@outerVariation"/></td>
		</tr>
	</table>
	
	</div>
	<!-- /.box -->
</xsl:template>

</xsl:stylesheet>
