<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->
<xsl:template name="lower">
<xsl:param name="str"/>
	<xsl:value-of select="translate($str, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxwz')"/>
</xsl:template>

<xsl:template name="classid2icon">
<xsl:param name="classid"/>
	<xsl:variable name="val">
		<xsl:call-template name="lower">
			<xsl:with-param name="str" select="$classid"/>
		</xsl:call-template>
	</xsl:variable>
	
	<xsl:choose>
		<xsl:when test="$val='clsid:d27cdb6e-ae6d-11cf-96b8-444553540000'">
			<img width="22" height="22" src="img/objects/flash.gif"/>
		</xsl:when>
		<xsl:when test="$val='clsid:02bf25d5-8c17-4b23-bc80-d3488abddc6b'">
			<img width="22" height="22" src="img/objects/quicktime.gif"/>
		</xsl:when>
		<xsl:when test="$val='clsid:cfcdaa03-8be4-11cf-b84b-0020afbbccfa'">
			<img width="22" height="22" src="img/objects/real.gif"/>
		</xsl:when>
		<xsl:when test="$val='clsid:166b1bca-3f9c-11cf-8075-444553540000'">
			<img width="22" height="22" src="img/objects/shockwave.gif"/>
		</xsl:when>
		<xsl:when test="$val='clsid:22d6f312-b0f6-11d0-94ab-0080c74c7e95'">
			<img width="22" height="22" src="img/objects/wmp.gif"/>
		</xsl:when>
		<xsl:when test="$val='clsid:6bf52a52-394a-11d3-b153-00c04f79faa6'">
			<!-- ver7以降 -->
			<img width="22" height="22" src="img/objects/wmp.gif"/>
		</xsl:when>
		<xsl:otherwise>
			<img width="22" height="22" src="img/objects/unknown.gif"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- HTML attribute -->
<xsl:template match="HTML_ATTRIBUTE">
	<xsl:text> </xsl:text>
	<xsl:value-of select="NAME"/>
	<xsl:text>=&quot;</xsl:text>
	<xsl:value-of select="VALUE"/>
	<xsl:text>&quot;</xsl:text>
</xsl:template>

<!-- HTML tag -->
<xsl:template match="HTML_ELEMENT">
	<li class="objrp">
		<xsl:text>&lt;</xsl:text>
		<xsl:value-of select="NAME"/>
		<xsl:apply-templates select="HTML_ATTRIBUTE"/>
		<xsl:text>&gt;</xsl:text>
		
		<xsl:if test="HTML_ATTRIBUTE[NAME='classid']">
			<xsl:call-template name="classid2icon">
				<xsl:with-param name="classid"
							 select="HTML_ATTRIBUTE[NAME='classid']/VALUE"/>
			</xsl:call-template>
		</xsl:if>
		
		<ul>
			<xsl:apply-templates select="HTML_ELEMENT"/>
		</ul>
	</li>
</xsl:template>

<!-- 1件分の情報 -->
<xsl:template match="CONTENTS_AND_VARIATION">
<xsl:param name="isOutputDetail"/>
	<li>
		<a href="{URL}"><xsl:value-of select="URL"/></a>
		<ul>
			<xsl:apply-templates select="HTML_ELEMENT"/>
		</ul>
	</li>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
	<title>Ridual：Objects tag / deail</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="objectsdetail">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualReportObjectsTagDetail"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualReportObjectsTagDetail">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<p><xsl:apply-templates select="ANALYZE_SITE_CONFIG"/></p>
		</div>
		<!-- /#line -->
		
		<xsl:apply-templates select="ANALYZE_HISTORY"/>
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<h1>Objects</h1>
<!--
		<p class="xmlicon"><a href="xml/objects.tag.detail.xml">XML</a></p>
		<p class="csvicon"><a href="csv/objects.tag.detail.csv">CSV</a></p>
		<p class="countn">count = <xsl:value-of select="count(CONTENTS_AND_VARIATION)"/>
			<span class="cdate">( checked on <xsl:value-of select="ANALYZE_HISTORY/TIMESTAMP_BEGIN"/> )</span>
		</p>
-->
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">
	
	<!-- #switch -->
	<div id="switch">
		<p class="objcont">
			<a href="objects.html">[contents]</a> 
		</p>
		<p class="objsummary">
			<a href="objects.tag.html">[summary]</a> 
		</p>
		<p class="description">Object tag list / detail</p>
		<br/>
	</div>
	<!-- /#switch -->

	<div class="box">
		<ol>
			<xsl:variable name="sw" select="ANALYZE_HISTORY/IS_OUTPUT_DETAIL"/>
			<xsl:apply-templates select="CONTENTS_AND_VARIATION">
				<xsl:with-param name="isOutputDetail" select="$sw"/>
			</xsl:apply-templates>
		</ol>
	</div>
	
	</div>
	<!-- /#content -->
</xsl:template>

<xsl:template match="ANALYZE_SITE_CONFIG">
	<a target="_blank" href="{START_URIS}">
		<xsl:value-of select="START_URIS"/>
	</a>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="index.html">Overview</a></li>
			<li class="sitemap"><a name="sitemap.html">Sitemap</a></li>
			<li class="pages"><a href="pages.html">Pages</a></li>
			<li class="resources"><a href="resources.html">Resources</a></li>
			<li class="outlink"><a href="outlink.html">OutLink</a></li>
			<li class="form"><a href="form.html">Form</a></li>
			<li class="script"><a href="script.html">Script</a></li>
			<li class="css"><a href="css.html">CSS</a></li>
			<li class="objects"><a href="objects.html">Objects</a></li>
			<li class="lost"><a href="lost.html">Lost</a></li>
			<li class="quality"><a href="quality.html">Quality</a></li>
			<li class="report"><a href="report.html">Report</a></li>
			<li class="datalist"><a name="data.html">Data</a></li>
		</ul>
	</div>
	<!-- /#menu -->
</xsl:template>

</xsl:stylesheet>
