<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->
<xsl:template name="inputText">
<xsl:param name="type"/>
<xsl:param name="caption"/>
<xsl:param name="postname"/>
<xsl:param name="value"/>
<xsl:param name="labelclass"/>
<xsl:param name="ex"/>
	<label for="{$postname}" class="{$labelclass}">
		<xsl:value-of select="$caption"/>:
	</label>
	<span class="control">
		<input type="{$type}" id="{$postname}" name="{$postname}"
											value="{$value}"/>
		<xsl:if test="$ex!=''">
			<p class="remark">
				<xsl:value-of select="$ex"/>
			</p>
		</xsl:if>
	</span>
<!--
	<br/>
-->
</xsl:template>

<xsl:template match="DBMS">
<xsl:param name="dbms"/>
	<option value="{.}">
		<xsl:if test="$dbms=.">
			<xsl:attribute name="selected">selected</xsl:attribute>
		</xsl:if>
		<xsl:value-of select="."/>
	</option>
</xsl:template>

<xsl:template match="RIDUAL_SERVER_MESSAGE">
	<p><xsl:value-of select="."/></p>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
		<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
		<title>Ridual：Admin-SetUp</title>
		<link href="mailto:ridual@nri.co.jp" rev="made"/>
		<link title="Ridual" href="../css/import_style.css" rel="stylesheet"
										type="text/css" media="screen,print"/>
		<link href="../css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="admin">

	<!-- #layout -->
	<div id="layout">

	<xsl:apply-templates select="RidualServerConfig"/>

	<!-- #footer -->
	<div id="footer">
		<p>
			<img alt="Powered by Nomura Research Institute,Ltd."
				title="Powered by Nomura Research Institute,Ltd."
					height="15" width="300" src="../img/logo_nri.gif"/>
		</p>
	</div>
	<!--/ #footer -->

	</div>
	<!--/ #layout -->
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualServerConfig">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
															src="../img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>

			<ul>
				<li class="analyzer"><a href="../index.html">Analyzer</a></li>
				<li class="sitelist"><a href="../sitelist">Sitelist</a></li>
				<li class="admin"><a href="setup">Admin</a></li>
				<li class="help"><a href="../help/help.html">Help</a></li>
			</ul>

		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
				<p>Admin</p>
		</div>
		<!-- /#line -->

		<!-- #menu -->
		<div id="menu">
			<ul>
				<li class="setup"><a href="setup">Setup</a></li>
				<li class="serverlog"><a href="serverlog">ServerLog</a></li>
				<li class="logout"><a href="../index.html">Logout</a></li>
				<li class="adhelp"><a href="adhelp.html">Help</a></li>
			</ul>
		</div>
		<!-- /#menu -->
		<div>
			<xsl:apply-templates select="RIDUAL_SERVER_MESSAGE"/>
		</div>
	</div>
	<!-- /#header -->
	
	<hr/>
	
	<!-- #path -->
	<div id="path">
		<h1>Setup</h1>
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">
	<fieldset>
	
	<!-- Robots -->
	<form action="setrobocount" method="post">Analyze Robot count
		<input id="c" name="c" type="text" value="{ANALYZE_ROBO_COUNT}"/>
			停止中: <xsl:value-of select="ANALYZE_ROBO_RESERVE_STOPPING_COUNT"/>
		<br/>
		<input alt="OK" class="ok" src="../img/btn_ok.gif" type="image"/>
	</form>

	<br/>

	<!-- AdminInfo -->
	<form action="reloadlicense" method="post">
	<fieldset>
	<legend>AdminInfo</legend>
	
		<xsl:call-template name="inputText">
		<xsl:with-param name="type" select="'text'"/>
		<xsl:with-param name="caption" select="'admin'"/>
		<xsl:with-param name="postname" select="'admin'"/>
		<xsl:with-param name="value"
				select="RIDUAL_SERVER_CONFIG[NAME='admin.name']/VALUE"/>
		<xsl:with-param name="labelclass" select="'label2'"/>
		</xsl:call-template>
		<br/>
		
		<xsl:call-template name="inputText">
		<xsl:with-param name="type" select="'text'"/>
		<xsl:with-param name="caption" select="'mail'"/>
		<xsl:with-param name="postname" select="'adminmail'"/>
		<xsl:with-param name="value"
				select="RIDUAL_SERVER_CONFIG[NAME='admin.mail']/VALUE"/>
		<xsl:with-param name="labelclass" select="'label2'"/>
		</xsl:call-template>
		<br/>
		ReloadLicense<input alt="Reload" class="ok" src="../img/btn_ok.gif" type="image"/>
		<br/>
	</fieldset>

	<br/>
	</form>
	<!-- /AdminInfo -->

<!--
	<form action="setrobocount" method="post">

	<fieldset>
	<legend>Robots</legend>
		<label for="c" class="label1">Analyze Robot count:</label>
		<span class="control">
		<input id="c" name="c" type="text" value="{ANALYZE_ROBO_COUNT}"/>
		停止中: <xsl:value-of select="ANALYZE_ROBO_RESERVE_STOPPING_COUNT"/>
		</span>
		<br/>
		<input alt="OK" class="ok" src="../img/btn_ok.gif" type="image"/>
		<br/>
	</fieldset>
	
	<br/>
	
	</form>
-->
	<!-- /Robots -->

	<br/>
		
	<form method="post" action="savesetup">
	
	<!-- Ridual server -->
	<fieldset>
	<legend>Ridual server</legend>
		<xsl:call-template name="inputText">
		<xsl:with-param name="type" select="'text'"/>
		<xsl:with-param name="caption" select="'Ridual server name'"/>
		<xsl:with-param name="postname" select="'rsname'"/>
		<xsl:with-param name="value" select="RIDUAL_SERVER_CONFIG[NAME='ridual.server.name']/VALUE"/>
		<xsl:with-param name="labelclass" select="'label1'"/>
		</xsl:call-template>
		<br/>
		
		<xsl:call-template name="inputText">
		<xsl:with-param name="type" select="'text'"/>
		<xsl:with-param name="caption" select="'Static HTML output directory'"/>
		<xsl:with-param name="postname" select="'staticdir'"/>
		<xsl:with-param name="value" select="RIDUAL_SERVER_CONFIG[NAME='ridual.dir.static']/VALUE"/>
		<xsl:with-param name="labelclass" select="'label1'"/>
		</xsl:call-template>
		<br/>
	</fieldset>
	<!-- /Ridual server -->
	
	<br/>

	<!-- DB connection -->
	<fieldset>
	<legend>DB connection</legend>
		<div class="lbox">
		
		<label for="cdbms" class="label2">DB: </label>
		<span class="control">
			<select id="cdbms" name="cdbms">
				<option value="">---- 選んでください ----</option>
				<xsl:apply-templates select="DBMS">
					<xsl:with-param name="dbms"
						 select="RIDUAL_SERVER_CONFIG[NAME='db.dbms']/VALUE"/>
				</xsl:apply-templates>
			</select>
		</span>
		
		</div>
		
		<div class="rbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'text'"/>
			<xsl:with-param name="caption" select="'DB name'"/>
			<xsl:with-param name="postname" select="'cdbname'"/>
			<xsl:with-param name="value"
						select="RIDUAL_SERVER_CONFIG[NAME='db.dbname']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
			</xsl:call-template>
		</div>
		
		<br/>
		
		<div class="lbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'text'"/>
			<xsl:with-param name="caption" select="'host'"/>
			<xsl:with-param name="postname" select="'chost'"/>
			<xsl:with-param name="value"
						select="RIDUAL_SERVER_CONFIG[NAME='db.host']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
			</xsl:call-template>
		</div>
		<div class="rbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'text'"/>
			<xsl:with-param name="caption" select="'port'"/>
			<xsl:with-param name="postname" select="'cport'"/>
			<xsl:with-param name="value"
						 select="RIDUAL_SERVER_CONFIG[NAME='db.port']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
			</xsl:call-template>
		</div>
		
		<br/>
		
		<div class="lbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'text'"/>
			<xsl:with-param name="caption" select="'user'"/>
			<xsl:with-param name="postname" select="'cuser'"/>
			<xsl:with-param name="value"
			select="RIDUAL_SERVER_CONFIG[NAME='hibernate.connection.username']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
		</xsl:call-template>
		</div>
		<div class="rbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'password'"/>
			<xsl:with-param name="caption" select="'password'"/>
			<xsl:with-param name="postname" select="'cpass'"/>
			<xsl:with-param name="value"
				select="RIDUAL_SERVER_CONFIG[NAME='hibernate.connection.password']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
			</xsl:call-template>
		</div>
		<br/>
	</fieldset>
	<!-- /DB connection -->
	
	<br/>

	<!-- HTTP proxy -->
	<fieldset>
	<legend>HTTP proxy</legend>
	
		<div class="lbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'text'"/>
			<xsl:with-param name="caption" select="'host'"/>
			<xsl:with-param name="postname" select="'phost'"/>
			<xsl:with-param name="value"
					select="RIDUAL_SERVER_CONFIG[NAME='proxy.host']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
			</xsl:call-template>
		</div>

		<div class="rbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'text'"/>
			<xsl:with-param name="caption" select="'port'"/>
			<xsl:with-param name="postname" select="'pport'"/>
			<xsl:with-param name="value"
					select="RIDUAL_SERVER_CONFIG[NAME='proxy.port']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
			</xsl:call-template>
		</div>
		<br/>
	
		<div class="lbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'text'"/>
			<xsl:with-param name="caption" select="'user'"/>
			<xsl:with-param name="postname" select="'puser'"/>
			<xsl:with-param name="value"
					select="RIDUAL_SERVER_CONFIG[NAME='proxy.user']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
			</xsl:call-template>
		</div>
		<div class="rbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'password'"/>
			<xsl:with-param name="caption" select="'password'"/>
			<xsl:with-param name="postname" select="'ppass'"/>
			<xsl:with-param name="value"
					select="RIDUAL_SERVER_CONFIG[NAME='proxy.password']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
			</xsl:call-template>
		</div>
		<br/>
		
		<xsl:call-template name="inputText">
		<xsl:with-param name="type" select="'text'"/>
		<xsl:with-param name="caption" select="'non proxy host'"/>
		<xsl:with-param name="postname" select="'nphost'"/>
		<xsl:with-param name="value"
			select="RIDUAL_SERVER_CONFIG[NAME='proxy.host.nonproxy']/VALUE"/>
		<xsl:with-param name="labelclass" select="'label2'"/>
		<xsl:with-param name="ex" select="'ex.) 127.0.0.* | *.sub.ridual.jp | 127.0.0.1 | ridual.nri.co.jp | localhost'"/>
		</xsl:call-template>
		<br/>
			
	</fieldset>
	<!-- HTTP proxy -->

	<br/>

	<!-- send mail (SMTP) -->
	<fieldset>
	<legend>send mail (SMTP)</legend>
	
		<div class="lbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'text'"/>
			<xsl:with-param name="caption" select="'host'"/>
			<xsl:with-param name="postname" select="'shost'"/>
			<xsl:with-param name="value"
					select="RIDUAL_SERVER_CONFIG[NAME='mail.smtp.host']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
			</xsl:call-template>
		</div>
		<div class="rbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'text'"/>
			<xsl:with-param name="caption" select="'port'"/>
			<xsl:with-param name="postname" select="'sport'"/>
			<xsl:with-param name="value"
					select="RIDUAL_SERVER_CONFIG[NAME='mail.smtp.port']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
			</xsl:call-template>
		</div>
		<br/>
		
		<div class="lbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'text'"/>
			<xsl:with-param name="caption" select="'user'"/>
			<xsl:with-param name="postname" select="'suser'"/>
			<xsl:with-param name="value"
					select="RIDUAL_SERVER_CONFIG[NAME='mail.smtp.user']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
		</xsl:call-template>
		</div>
		<div class="rbox">
			<xsl:call-template name="inputText">
			<xsl:with-param name="type" select="'password'"/>
			<xsl:with-param name="caption" select="'password'"/>
			<xsl:with-param name="postname" select="'spass'"/>
			<xsl:with-param name="value"
				select="RIDUAL_SERVER_CONFIG[NAME='mail.smtp.password']/VALUE"/>
			<xsl:with-param name="labelclass" select="'label2'"/>
			</xsl:call-template>
		</div>
		<br/>
		
		<xsl:call-template name="inputText">
		<xsl:with-param name="type" select="'text'"/>
		<xsl:with-param name="caption" select="'from'"/>
		<xsl:with-param name="postname" select="'mfrom'"/>
		<xsl:with-param name="value"
						select="RIDUAL_SERVER_CONFIG[NAME='mail.from']/VALUE"/>
		<xsl:with-param name="labelclass" select="'label2'"/>
		</xsl:call-template>
		<br/>

	</fieldset>
	<!-- /send mail (SMTP) -->
	
	<br/>

	<input alt="OK" class="ok" src="../img/btn_ok.gif" type="image"/>
	
	</form>

	</fieldset>
	
	</div>
	<!-- /#content -->
</xsl:template>

</xsl:stylesheet>
