<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template name="formattime">
<xsl:param name="ms"/>
	<xsl:value-of select="floor($ms div 3600000)"/>
	<xsl:text>:</xsl:text>
	<xsl:value-of select="floor( ($ms div 60000) mod 60 )"/>
	<xsl:text>:</xsl:text>
	<xsl:value-of select="floor( ($ms div 1000) mod 60 )"/>
</xsl:template>

<!-- RATING -->
<xsl:template match="RATING">
	<xsl:variable name="method">
		<xsl:choose>
			<xsl:when test="'true'!=ACTIVE">3</xsl:when>
			<xsl:when test="'0'=WEIGHT">0</xsl:when>
			<xsl:when test="'0'=METHOD">0</xsl:when>
			<xsl:when test="'1'=METHOD">1</xsl:when>
			<xsl:when test="'2'=METHOD">2</xsl:when>
			<xsl:otherwise>3</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="enabled">
		<xsl:choose>
			<xsl:when test="('true'=ACTIVE) and ('true'=EXECUTION)">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<li>
		<xsl:if test="'0'=$enabled">
			<xsl:attribute name="class">disabled</xsl:attribute>
		</xsl:if>
		<p>
			<a href="../../help/help.html#report">
				<xsl:choose>
					<xsl:when test="'0'=$method">
						<img alt="zero checkitem" width="19" height="15"
													 src="../../img/zero.jpg"/>
					</xsl:when>
					<xsl:when test="'1'=$method">
						<img alt="positive checkitem" width="19" height="15"
												 src="../../img/posi.jpg"/>
					</xsl:when>
					<xsl:when test="'2'=$method">
						<img alt="negative checkitem" width="19" height="15"
													 src="../../img/nega.jpg"/>
					</xsl:when>
					<xsl:when test="'3'=$method">
						<img alt="plan checkitem" width="19" height="15"
													 src="../../img/plan.jpg"/>
					</xsl:when>
				</xsl:choose>
			</a>
			<xsl:value-of select="CAPTION"/>
		</p>
		<span class="rbox">
			<xsl:if test="'1'=$enabled">
				<xsl:choose>
					<xsl:when test="('1'=METHOD) or ('2'=METHOD)">
						<span class="num1">
							<xsl:text>重み=</xsl:text>
							<xsl:value-of select="WEIGHT"/>
						</span>
						<span class="num2">
							<xsl:if test="'2'=$method">-</xsl:if>
							<xsl:value-of select="PAGE"/>p
						</span>
						<span class="num3"><xsl:value-of select="RATE"/>%</span>
					</xsl:when>
					<xsl:otherwise>
						<span class="num1">重み=-</span>
						<span class="num2">
							<xsl:if test="'2'=$method">-</xsl:if>
							<xsl:value-of select="PAGE"/>p
						</span>
						<!-- span class="num3">-%</span -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</span>
	</li>
</xsl:template>

<xsl:template match="GLOBAL_RATING[MODE='score']">
	<div class="score">
<!--
	<p>&nbsp;</p>
-->
		<p class="ct">
			<span class="pnt"><xsl:value-of select="COUNT"/></span>
			<span class="manten">/ <xsl:value-of select="ALL"/></span>
		</p>
	</div>
</xsl:template>

<xsl:template name="globalratingformat">
	<li>
		<p><xsl:value-of select="CAPTION"/></p>
		<span class="rbox2">
			<xsl:choose>
				<xsl:when test="'code'=TYPE">
					<xsl:choose>
						<xsl:when test="VALUE=''">
							<span class="unknown">unknown</span>
						</xsl:when>
						<xsl:when test="VALUE!='NULL'">
							<xsl:value-of select="VALUE"/>
						</xsl:when>
						<xsl:otherwise>
							<span class="none">none</span>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="'text'=TYPE">
					<xsl:value-of select="VALUE"/>
				</xsl:when>
				<xsl:when test="'int'=TYPE">
					<xsl:value-of select="VALUE"/>
				</xsl:when>
				<xsl:when test="'date'=TYPE">
					<xsl:value-of select="VALUE"/>
				</xsl:when>
				<xsl:when test="'time'=TYPE">
					<xsl:call-template name="formattime">
						<xsl:with-param name="ms" select="number(VALUE)"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="'ratio'=TYPE">
					<xsl:value-of select="COUNT"/> /
					<xsl:value-of select="ALL"/>
				</xsl:when>
			</xsl:choose>
		</span>
	</li>
</xsl:template>

<xsl:template match="GLOBAL_RATING[MODE='analyzeinfo']">
	<xsl:call-template name="globalratingformat"/>
</xsl:template>

<xsl:template match="GLOBAL_RATING[MODE='siteinfo1']">
	<xsl:call-template name="globalratingformat"/>
</xsl:template>

<xsl:template match="GLOBAL_RATING[MODE='siteinfo2']">
	<xsl:call-template name="globalratingformat"/>
</xsl:template>

<xsl:template match="GLOBAL_RATING[MODE='siteinfo3']">
	<xsl:call-template name="globalratingformat"/>
</xsl:template>

<!--
<xsl:template match="GLOBAL_RATING">
	<li>
		<p><xsl:value-of select="CAPTION"/></p>
		<span class="rbox">
			<xsl:choose>
				<xsl:when test="'text'=TYPE">
					<xsl:choose>
						<xsl:when test="VALUE='unknown'">
							<span class="unknown"><xsl:value-of select="VALUE"/></span>
						</xsl:when>
						<xsl:when test="VALUE!='NULL'">
							<xsl:value-of select="VALUE"/>
						</xsl:when>
						<xsl:otherwise>
							<span class="none">none</span>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="'int'=TYPE">
					<xsl:value-of select="VALUE"/>
				</xsl:when>
				<xsl:when test="'date'=TYPE">
					<xsl:value-of select="VALUE"/>
				</xsl:when>
				<xsl:when test="'ratio'=TYPE">
					<xsl:value-of select="COUNT"/> /
					<xsl:value-of select="ALL"/>
				</xsl:when>
			</xsl:choose>
		</span>
	</li>
</xsl:template>
-->

<!-- GROUP -->
<xsl:template match="GROUP">
	<li>
		<span class="discrive"><xsl:value-of select="CAPTION"/></span>
		<ol class="uline">
			<xsl:apply-templates select="RATING"/>
		</ol>
	</li>
</xsl:template>

<xsl:template match="GLOBAL_GROUP">
	<!--scorebox-->
	<div class="scorebox">
		<xsl:apply-templates select="GLOBAL_RATING[MODE='score']"/>

		<!--.scoreinfo-->
		<div class="scoreinfo">
			<ul class="uline">
				<xsl:apply-templates select="GLOBAL_RATING[MODE='analyzeinfo']"/>
			</ul>
		</div>
		<!--/.scoreinfo-->
	</div>
	<br/>
	<!--/scorebox-->

	<!--anabox-->
	<div class="anabox">
		<div class="ctitle">
			<h3><xsl:value-of select="CAPTION"/></h3>
		</div>
		<div class="anainfo01">
			<ul class="uline">
				<xsl:apply-templates select="GLOBAL_RATING[MODE='siteinfo1']"/>
			</ul>
		</div>
		<div class="anainfo02">
			<ul class="uline">
				<xsl:apply-templates select="GLOBAL_RATING[MODE='siteinfo2']"/>
			</ul>
		</div>
		<div class="anainfo03">
			<ul class="uline">
				<xsl:apply-templates select="GLOBAL_RATING[MODE='siteinfo3']"/>
			</ul>
		</div>
	</div>
	<!--/anabox-->

<!--
	<li>
		<span class="discrive"><xsl:value-of select="CAPTION"/></span>
		<ol>
			<xsl:apply-templates select="GLOBAL_RATING"/>
		</ol>
	</li>
-->
</xsl:template>

<!-- CATEGORY -->
<xsl:template match="CATEGORY">
	<div class="box">
		<div class="ctitle">
			<h2><xsl:value-of select="CAPTION"/></h2>
			<a href="#top">[Top]</a>
		</div>
		<ol>
			<xsl:apply-templates select="GROUP"/>
		</ol>
	</div>
</xsl:template>

<xsl:template match="GLOBAL_CATEGORY">
	<div class="ctitle">
		<h2><xsl:value-of select="CAPTION"/></h2>
	</div>
	<xsl:apply-templates select="GLOBAL_GROUP"/>
<!--
	<ol>
		<xsl:apply-templates select="GLOBAL_GROUP"/>
	</ol>
-->
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<title>Ridual：Report</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="../../css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="../../css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="report">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualReportReport"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="../../img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualReportReport">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="../../img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>

			<ul>
				<li class="analyzer"><a href="../../index.html">Analyzer</a></li>
				<li class="sitelist"><a href="../../sitelist">Sitelist</a></li>
				<li class="admin"><a href="../../admin/setup">Admin</a></li>
				<li class="help"><a href="../../help/help.html">Help</a></li>
			</ul>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<p><xsl:apply-templates select="ANALYZE_SITE_CONFIG"/></p>
		</div>
		<!-- /#line -->

		<!-- menu -->
		<xsl:apply-templates select="ANALYZE_HISTORY"/>
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<h1>Report</h1>
		<p class="xmlicon"><a href="xml/report.xml">XML</a></p>
		<p class="csvicon"><a href="csv/report.csv">CSV</a></p>
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">
		<!-- .box -->
		<div class="box">
			<xsl:apply-templates select="GLOBAL_CATEGORY"/>
			<br/>
		</div>
		<!-- /.box -->

		<!-- .box -->
		<div class="box">
			<xsl:apply-templates select="CATEGORY"/>
		</div>
		<!-- /.box -->
	</div>
	<!-- /#content -->
</xsl:template>

<xsl:template match="ANALYZE_SITE_CONFIG">
	<a target="_blank" href="{START_URIS}">
		<xsl:value-of select="START_URIS"/>
	</a>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="index.html">Overview</a></li>
			<li class="sitemap"><a href="sitemap.html">Sitemap</a></li>
			<li class="pages"><a href="pages.html">Pages</a></li>
			<li class="resources"><a href="resources.html">Resources</a></li>
			<li class="outlink"><a href="outlink.html">OutLink</a></li>
			<li class="form"><a href="form.html">Form</a></li>
			<li class="script"><a href="script.html">Script</a></li>
			<li class="css"><a href="css.html">CSS</a></li>
			<li class="objects"><a href="objects.html">Objects</a></li>
			<li class="lost"><a href="lost.html">Lost</a></li>
			<li class="quality"><a href="quality.html">Quality</a></li>
			<li class="report"><a href="report.html">Report</a></li>
			<li class="datalist"><a href="data.html">Data</a></li>
		</ul>
	</div>
	<!-- /#menu -->
</xsl:template>

</xsl:stylesheet>
