<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<title>Ridual : Data</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="../../css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link title="Ridual" href="../../css/import_style.css" rel="stylesheet"
										type="text/css" media="screen,print"/>
	<link href="../../css/print.css" rel="stylesheet" type="text/css"
														media="print"/>
	</head>

	<body id="datalist">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualReportData"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
					height="15" width="300" src="../../img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualReportData">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img height="30" width="70" alt="Ridual logo"
													src="../../img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>

			<ul>
				<li class="analyzer"><a href="../../index.html">Analyzer</a></li>
				<li class="sitelist"><a href="../../sitelist">Sitelist</a></li>
				<li class="admin"><a href="../../admin/setup">Admin</a></li>
				<li class="help"><a href="../../help/help.html">Help</a></li>
			</ul>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<p><xsl:apply-templates select="ANALYZE_SITE_CONFIG"/></p>
		</div>
		<!-- /#line -->

		<!-- menu -->
		<xsl:apply-templates select="ANALYZE_HISTORY"/>
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<h1>Data</h1>
		<p class="xmlicon"><a href="xml/data.xml">XML</a></p>
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">

	<!-- #switch -->
	<div id="switch">
		<p class="description">Output data list</p>
		<br/>
	</div>
	<!-- /#switch -->

	<!-- .box0 -->
	<div class="box">
		<br/>
		
		<table id="odlist" class="noborder">
		<caption>Output data list</caption>
		
		<tr>
			<th class="th1">Category</th>
			<th class="th1">data</th>
			<th class="th1">description</th>
		</tr>

		<tr class="tr1">
			<td class="ltt">
				<span><a href="index.html">Overview</a></span>
			</td>
			<td class="ltic">
				<ul>
				<li class="xmlicon"><a href="xml/index.xml">XML</a></li>
				<li class="csvicon"><a href="csv/index.csv">CSV</a></li>
				</ul>
			</td>
			<td class="ltd">
				<p id="odov">指定サイト内の拡張子別ファイル数など、ファイル構成などの概要情報</p>
			</td>
		</tr>

		<tr class="tr2">
			<td class="ltt">
				<span><a href="sitemap.html">Sitemap</a></span>
				<span>&gt;</span>
				<span><a href="sitemap.html">Circlemap</a></span>
			</td>
			<td class="ltic">
				<ul>
					<li class="xmlicon">
						<a href="rmap_c.xml">XML</a>
					</li>
					<li class="htmlicon">
						<a href="map/rmap_c.html">HTML</a>
					</li>
				</ul>
			</td>	
			<td class="ltd">
				<p id="odmapc">入り口のページからのクリック数に応じてページを同心円状に配置し、サイトの規模感を視覚化したもの</p>
			</td>
		</tr>
		
		<tr class="tr1">
			<td class="ltt">
				<span><a href="sitemap.html">Sitemap</a></span>
				<span>&gt;</span>
				<span><a href="sitemap.html">Sitemap</a></span>
			</td>
			<td class="ltic">
				<ul>
					<li class="xmlicon">
						<a href="rmap_s.xml">XML</a>
					</li>
					<li class="htmlicon">
						<a href="map/rmap_s.html">HTML</a>
					</li>
				</ul>
			</td>
			<td class="ltd">
				<p id="odmaps">サイトの構造を射影法的な視点で視覚化したもの/デザイナ的な観点でのサイト構造図</p>
			</td>
		</tr>
		
		<tr class="tr2">
			<td class="ltt">
				<span><a href="sitemap.html">Sitemap</a></span>
				<span>&gt;</span>
				<span><a href="sitemap.html">Hiermap</a></span>
			</td>
			<td class="ltic">
				<ul>
					<li class="xmlicon">
						<a href="rmap_h.xml">XML</a>
					</li>
					<li class="htmlicon">
						<a href="map/rmap_h.html">HTML</a>
					</li>
				</ul>
			</td>	
			<td class="ltd">
				<p id="odmaph">サイトの構造を上から下に並べるように視覚化したもの/システム的な観点でのサイト構造</p>
			</td>
		</tr>
		
		<tr class="tr1">
			<td class="ltt">
				<span><a href="pages.html">Pages</a></span>
			</td>
			<td class="ltic">
				<ul>
					<li class="xmlicon"><a href="xml/pages.xml">XML</a></li>
					<li class="csvicon"><a href="csv/pages.csv">CSV</a></li>
				</ul>
			</td>
			<td class="ltd">
				<p id="odpg">ページの一覧表/タイトル,http-status,DOCTYPE,charsetなどの簡易チェック用</p>
			</td>
		</tr>
		
		<tr class="tr2">
			<td class="ltt">
				<span><a href="resources.html">Resources</a></span>
			</td>
			<td class="ltic">
				<ul>
					<li class="xmlicon"><a href="xml/resources.xml">XML</a></li>
					<li class="csvicon"><a href="csv/resources.csv">CSV</a></li>
				</ul>
			</td>
			<td class="ltd">
				<p id="odres">リソース一覧表/拡張子,http-statusなどの簡易チェック用</p>
			</td>
		</tr>
		
		<tr class="tr1">
			<td class="ltt">
				<span><a href="outlink.html">OutLink</a></span>
			</td>
			<td class="ltic">
					<ul>
					<li class="xmlicon"><a href="xml/outlink.xml">XML</a></li>
					<li class="csvicon"><a href="csv/outlink.csv">CSV</a></li>
				</ul>
			</td>
		
			<td class="ltd">
				<p id="odol">指定サイト外へのリンク一覧表 / リンク切れチェック用</p>
			</td>
		</tr>
		
		<tr class="tr2">
			<td class="ltt">
				<span><a href="form.html">Form ( tag base )</a></span>
			</td>
			<td class="ltic">
				<ul>
					<li class="xmlicon"><a href="xml/form.xml">XML</a></li>
					<li class="csvicon"><a href="csv/form.csv">CSV</a></li>
				</ul>
			</td>
			<td class="ltd"><p id="odft">formタグに関する情報一覧</p></td>
		</tr>
		
		<tr class="tr1">
			<td class="ltt">
				<span><a href="form.html">Form( action base )</a></span>
			</td>
			<td class="ltic">
				<ul>
					<li class="xmlicon"><a href="xml/form.act.xml">XML</a></li>
					<li class="csvicon"><a href="csv/form.act.csv">CSV</a></li>
				</ul>
			</td>
			<td class="ltd">
				<p id="odfa">formタグに指定されている action 別情報一覧</p>
			</td>
		</tr>
		
		<tr class="tr2">
			<td class="ltt"><span><a href="script.html">Script</a></span></td>
			<td class="ltic">
				<ul>
					<li class="xmlicon"><a href="xml/script.xml">XML</a></li>
					<li class="csvicon"><a href="csv/script.csv">CSV</a></li>
				</ul>
			</td>
			<td class="ltd"><p id="odsc">外部 Script ファイル一覧</p></td>
		</tr>
		
		<tr class="tr1">
			<td class="ltt"><span><a href="css.html">CSS</a></span></td>
			<td class="ltic">
				<ul>
					<li class="xmlicon"><a href="xml/css.xml">XML</a></li>
					<li class="csvicon"><a href="csv/css.csv">CSV</a></li>
				</ul>
			</td>
			<td class="ltd">
				<p id="odcss">外部 CSS ファイルとその定義に関する情報一覧</p>
			</td>
		
		</tr>
		
		<tr class="tr2">
			<td class="ltt"><span><a href="objects.html">Objects/contents</a></span></td>
			<td class="ltic">
				<ul>
					<li class="xmlicon"><a href="xml/objects.xml">XML</a></li>
					<!-- li class="csvicon"><a href="csv/objects.csv">CSV</a></li -->
				</ul>
			</td>
			<td class="ltd">
				<p id="odlost">objectタグなどで埋め込まれたコンテンツリスト</p>
			</td>
		</tr>
		
		<tr class="tr1">
			<td class="ltt"><span><a href="objects.tag.html">Objects/tag</a></span></td>
			<td class="ltic">
				<ul>
					<li class="xmlicon"><a href="xml/objects.tag.xml">XML</a></li>
				</ul>
			</td>
			<td class="ltd">
				<p id="odqua">objectタグなどで埋め込まれたコンテンツリスト</p>
			</td>
		</tr>
		
		<tr class="tr2">
			<td class="ltt"><span><a href="lost.html">Lost</a></span></td>
			<td class="ltic">
				<ul>
					<li class="xmlicon"><a href="xml/lost.xml">XML</a></li>
					<li class="csvicon"><a href="csv/lost.csv">CSV</a></li>
				</ul>
			</td>
			<td class="ltd">
				<p id="odlost">リンク切れファイルおよびリソース一覧</p>
			</td>
		</tr>
		
		<tr class="tr1">
			<td class="ltt"><span><a href="quality.html">Quality</a></span></td>
			<td class="ltic">
				<ul>
					<li class="xmlicon"><a href="xml/quality.xml">XML</a></li>
				</ul>
			</td>
			<td class="ltd"><p id="odqua">(X)HTML としての品質チェック</p></td>
		</tr>
		
		<tr class="tr2">
			<td class="ltt"><span><a href="report.html">Report</a></span></td>
			<td class="ltic">
				<ul>
					<li class="xmlicon"><a href="xml/report.xml">XML</a></li>
					<li class="csvicon"><a href="csv/report.csv">CSV</a></li>
				</ul>
			</td>
			<td class="ltd">
				<p id="odrepo">指定した評価シートに対する評価レポート</p>
			</td>
		</tr>
		
		<tr class="tr1">
			<td class="ltt"><span>Google Sitemap</span></td>
			<td class="ltic">
				<ul>
					<li class="xmlicon"><a href="xml/sitemap4google.xml">XML</a></li>
				</ul>
			</td>
			<td class="ltd"><p id="odall">GoogleSitemap用XML</p></td>
		</tr>

		<tr class="tr2">
			<td class="ltt"><span>All</span></td>
			<td class="ltic">
				<ul>
					<li class="zipicon"><a href="r2report.zip">ZIP</a></li>
				</ul>
			</td>
			<td class="ltd"><p id="odall">アーカイブ</p></td>
		</tr>
		
		</table>

	</div>
	<!-- /.box0 -->
	
	</div>
	<!-- /#content -->
</xsl:template>

<xsl:template match="ANALYZE_SITE_CONFIG">
	<a target="_blank" href="{START_URIS}">
		<xsl:value-of select="START_URIS"/>
	</a>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="index.html" title="Overview">Overview</a></li>
			<li class="sitemap"><a href="sitemap.html" title="Sitemap">Sitemap</a></li>
			<li class="pages"><a href="pages.html" title="Pages">Pages</a></li>
			<li class="resources"><a href="resources.html" title="Resources">Resources</a></li>
			<li class="outlink"><a href="outlink.html" title="OutLink">OutLink</a></li>
			<li class="form"><a href="form.html" title="Form">Form</a></li>
			<li class="script"><a href="script.html" title="Script">Script</a></li>
			<li class="css"><a href="css.html" title="CSS">CSS</a></li>
			<li class="objects"><a href="objects.html" title="Objects">Objects</a></li>
			<li class="lost"><a href="lost.html" title="Lost">Lost</a></li>
			<li class="quality"><a href="quality.html" title="Quality">Quality</a></li>
			<li class="report"><a href="report.html" title="Report">Report</a></li>
			<li class="datalist"><a href="data.html" title="Data">Data</a></li>
		</ul>
	</div>
	<!-- /#menu -->
</xsl:template>

</xsl:stylesheet>
