<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<!-- RATING -->
<xsl:template match="RATING">
	<li>
		<input type="hidden" name="rclass" value="{CLASS}">
			<xsl:if test="'true'!=ACTIVE">
				<xsl:attribute name="disabled">disabled</xsl:attribute>
			</xsl:if>
		</input>
		<input type="checkbox" value="{CLASS}" name="rexec" id="{CLASS}">
			<xsl:if test="'true'!=ACTIVE">
				<xsl:attribute name="disabled">disabled</xsl:attribute>
			</xsl:if>
		</input>
		<label for="{CLASS}">
			<xsl:if test="'true'!=ACTIVE">
				<xsl:attribute name="class">disabled</xsl:attribute>
			</xsl:if>
			
			<xsl:if test="''!=RECOMMENDACTIVE">
				推奨:[<xsl:value-of select="RECOMMENDACTIVE"/>]
			</xsl:if>
		</label>
		<select name="rwt">
			<xsl:if test="('true'!=ACTIVE) or (('1'!=METHOD) and ('2'!=METHOD))">
				<xsl:attribute name="disabled">disabled</xsl:attribute>
			</xsl:if>
			
			<option value="0" selected="selected"> 0 </option>
			<option value="1"> 1 </option>
			<option value="2"> 2 </option>
			<option value="3"> 3 </option>
			<option value="4"> 4 </option>
			<option value="5"> 5 </option>
		</select>
		<xsl:if test="'null'!=RECOMMENDWEIGHT">
		</xsl:if>
		<label for="{CLASS}">
			<xsl:if test="'true'!=ACTIVE">
				<xsl:attribute name="class">disabled</xsl:attribute>
			</xsl:if>
			<xsl:if test="''!=RECOMMENDWEIGHT">
				推奨値:[<xsl:value-of select="RECOMMENDWEIGHT"/>]
			</xsl:if>
			
			<a href="help/help.html#report">
				<xsl:choose>
					<xsl:when test="'true'!=ACTIVE">
						<img alt="plan checkitem" width="19" height="15"
													 src="img/plan.jpg"/>
					</xsl:when>
					<xsl:when test="'0'=METHOD">
						<img alt="zero checkitem" width="19" height="15"
													 src="img/zero.jpg"/>
						<input type="hidden" name="rwt" value="0"/>
					</xsl:when>
					<xsl:when test="'1'=METHOD">
						<img alt="positive checkitem" width="19" height="15"
												 src="img/posi.jpg"/>
					</xsl:when>
					<xsl:when test="'2'=METHOD">
						<img alt="negative checkitem" width="19" height="15"
													 src="img/nega.jpg"/>
					</xsl:when>
				</xsl:choose>
			</a>
			
			<xsl:value-of select="CAPTION"/>
		</label>
	</li>
</xsl:template>

<!-- GROUP -->
<xsl:template match="GROUP">
	<li>
		<span class="discrive"><xsl:value-of select="CAPTION"/></span>
		<ol>
			<xsl:apply-templates select="RATING"/>
		</ol>
	</li>
</xsl:template>

<!-- CATEGORY -->
<xsl:template match="CATEGORY">
	<xsl:variable name="pos" select="position()"/>
	
	<div class="ctitle">
	
		<h2><xsl:value-of select="CAPTION"/></h2>
		
		<a>
		<xsl:choose>
			<xsl:when test="1 = $pos">
				<xsl:attribute name="name">top</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="href">#top</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		[Top]
		</a>
	</div>
		
	<ol>
		<xsl:apply-templates select="GROUP"/>
	</ol>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<title>Ridual：Check Item Profile Edit / new</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="pronew">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualRatingProfileNew"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualRatingProfileNew">
	<form action="saveprof" method="post">
	
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>
		</div>
		<!-- /#logo -->	
	</div>
	<!-- #header -->
	
	<hr/>

	<!-- #content -->
	<div id="content">
	
	<!-- .box -->
	<div class="box">
	
	<!-- #msgbox -->
	<div id="msgbox">

	<!-- #remake -->
	<div id="remake">

	<!-- .ms -->
	<div class="ms">
		<h1>新規作成</h1>
		<p>新しいプロファイルの名前をつけて下さい</p>
		<span class="control"> 
			<input type="text" size="40" name="proname" id="profname"/>
		</span>
		<input type="image" src="img/btn_regist.gif" id="profnew" alt="新規登録"/>
	</div>
	<!-- .ms -->
	
	<br class="clear"/>
	
	</div>
	<!-- /#remake -->

	</div>
	<!-- /#msgbox -->
	
	<!--#checkitem-->
	<div id="checkitem">
		<xsl:apply-templates select="CATEGORY"/>
	</div>
	<!-- /#checkitem -->
	
	</div>
	<!-- /.box -->
	
	</div>
	<!-- /#content -->
	
	</form>
</xsl:template>

</xsl:stylesheet>
