<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<!-- 1件分のデータ -->
<xsl:template match="LOCAL_FILE">
	<xsl:variable name="pos" select="position()"/>

	<tr>
	<xsl:attribute name="class">
		<xsl:choose>
			<xsl:when test="0 = ($pos mod 2)">tr2</xsl:when>
			<xsl:otherwise>tr1</xsl:otherwise>
		</xsl:choose>
	</xsl:attribute>
	
	<td class="ct"><xsl:value-of select="$pos"/></td>
	<td class="lt"><xsl:value-of select="EXTENSION"/></td>
	<td class="lt"><xsl:value-of select="PATH"/></td>
	<td class="rt"><xsl:value-of select="SIZE"/></td>
	<td class="lt"><xsl:value-of select="TIMESTAMP"/></td>
	</tr>
</xsl:template>

<xsl:template match="DIRECTORY_MAP" mode="body">
	<table>
	<caption>
		Page情報一覧
		<xsl:text> </xsl:text>
		<xsl:value-of select="URL"/>
		<xsl:text> : </xsl:text>
		<xsl:value-of select="DIR"/>
	</caption>
		<tr>
		<th class="th1">#</th>
		<th class="th1">extention</th>
		<th class="th1">name(path)</th>
		<th class="th1">size</th>
		<th class="th1">date</th>
		</tr>

		<xsl:apply-templates select="LOCAL_FILE"/>
	</table>
</xsl:template>

<xsl:template match="DIRECTORY_MAP" mode="head">
	<p>
		<xsl:value-of select="URL"/>
		<xsl:text> : </xsl:text>
		<xsl:value-of select="DIR"/>
	</p>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
	<title>Ridual：Local-Pages</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="localpg">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualLocalPages"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualLocalPages">
	<xsl:apply-templates select="LOCAL_HISTORY"/>
</xsl:template>

<xsl:template match="LOCAL_HISTORY">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="../RIDUAL_VERSION"/>
			</div>

			<ul>
				<li class="analyzer"><a href="index.html">Analyzer</a></li>
				<li class="sitelist"><a href="sitelist">Sitelist</a></li>
				<li class="admin"><a href="admin/setup">Admin</a></li>
				<li class="help"><a href="help/help.html">Help</a></li>
			</ul>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<xsl:apply-templates select="DIRECTORY_MAP" mode="head"/>
		</div>
		<!-- /#line -->
		
		<!-- #menu -->
		<div id="menu">
		<ul>
			<li class="overview"><a href="loverview?lh={ID}">Overview</a></li>
			<li class="pages"><a href="lpages?lh={ID}">Pages</a></li>
			<li class="resources"><a href="lresources?lh={ID}">Resources</a></li>
			<li class="difference"><a href="ldifference?lh={ID}">Difference</a></li>
		</ul>
		</div>
		<!-- /#menu -->
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<h1>Pages</h1>
		<p class="xmlicon"><a href="lpages?lh={ID}&amp;f=xml">XML</a></p>
		<p class="csvicon"><a href="lpages?lh={ID}&amp;f=csv">CSV</a></p>
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">

	<xsl:value-of select="count(.//LOCAL_FILE)"/>

	<!-- .box -->
	<div class="box">
		<xsl:apply-templates select="DIRECTORY_MAP" mode="body"/>
	</div>
	<!-- /.box -->
	
	</div>
	<!-- /#content -->
</xsl:template>

</xsl:stylesheet>
