<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->
<xsl:template match="RATING_PROFILE">
	<option value="{ID}"><xsl:value-of select="NAME"/></option>
</xsl:template>

<xsl:template match="RIDUAL_SERVER_MESSAGE">
	<p><xsl:value-of select="."/></p>
</xsl:template>

<xsl:template match="RIDUAL_LICENSE">
	<xsl:choose>
		<xsl:when test="'0'=MODE">
			<span class="rlmdemo">
				<a class="license" href="help/license.html#license">demo</a>
			</span>
		</xsl:when>
		<xsl:when test="'1'=MODE">
			<span class="rlminvalid">
				<a class="license" href="help/license.html#license">invalid</a>
			</span>
		</xsl:when>
		<xsl:when test="'2'=MODE">
			<span class="rlmvalid">
				<a class="license" href="help/license.html#license">valid</a>
			</span>
		</xsl:when>
		<xsl:when test="'3'=MODE">
			<span class="rlmexpired">
				<a class="license" href="help/license.html#license">expired</a>
			</span>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<p class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</p>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<title>Ridual：Analyzer</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="analyzer">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualAnalyzeStartup"/>
	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualAnalyzeStartup">
	<!-- #header -->
	<!--#bgbox-->
	<div id="bgbox">
	<form method="post" action="ana">	<!-- depth,files,sitedir,start,mail,phost,pport,puser,ppass -->

		<!--.firstbox-->
		<div id="firstbox">

			<!--.logo-->
			<div id="logo">

				<!--.ridual-->
				<div class="ridual">
				<a href="http://www.ridual.jp" target="_blank"><img src="img/ridual_logo.gif" width="110" height="45" title="Ridual logo" alt="Ridual logo"/></a>
				</div>
				<!--/.ridual-->

				<ul>
					<li class="analyzer"><a href="index.html">Analyzer</a></li>
					<li class="sitelist"><a href="sitelist">Sitelist</a></li>
					<li class="admin"><a href="admin/setup">Admin</a></li>
					<li class="help"><a href="help/help.html">Help</a></li>
				</ul>
			</div>
			<!--/.logo-->

			<!--.title-->
			<div id="title">
				<h1>Analyzer</h1>

				<!--.rlm-->
				<div id="rlm">
					<p>
						<xsl:apply-templates select="RIDUAL_LICENSE"/>
					</p>
				<br class="clear"/>
				</div>
				<!--.rlm-->

			</div>
			<!--/.title-->

			<hr />
		</div>
		<!--/.firstbox-->

		<!--/.secondbox-->
		<div id="secondbox">

			<!--.gline1-->
			<div class="gline1">
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>
			<!--/.gline1-->

			<!--.urlsetting-->
			<div id="urlsetting">
				<table class="noborder">
				<caption>URL</caption>
				<tr>
				    <td class="rt"><p class="urlt"><img src="img/url.gif" width="21" height="9" alt="URL" title="URL"/></p></td>
					<td class="lt"><p><input value="http://" id="start" name="start" type="text"/></p></td>
				</tr>
				<tr>
					<td> </td> <!-- &nbsp; -->
					<td class="ct">
						<p>
						<input alt="go analyze" class="gobtn" src="img/btn_go.gif" type="image"/>
						<!-- <input alt="Reset" class="resetbtn" src="img/btn_reset.gif" type="image"/> -->
						</p>
					</td>
				</tr>
				</table>
			</div>
			<!--.urlsetting-->

			<xsl:apply-templates select="RIDUAL_SERVER_MESSAGE"/>

			<!--.gline2-->
			<div class="gline2">
			<hr />
			</div>
			<!--/.gline2-->

		</div>
		<!--/.secondbox-->


	<!-- /#header -->


	<!-- <hr/> -->

	<!-- #content -->
	<div id="content">

		<!--.option setting-->
		<div id="optionsetting">

			<!--解析条件　Depth　Files-->
			<table class="noborder">
			<caption>option setting</caption>
			<tr>
				<td class="td1">Depth</td>
				<td class="lt">
					<fieldset>
					<span class="depth">
					<input id="d0" value="0" name="depth" type="radio"/><label for="d0">0</label>
					<input id="d1" value="1" name="depth" type="radio"/><label for="d1">1</label>
					<input id="d2" value="2" name="depth" type="radio"/><label for="d2">2</label>
					<input id="d3" value="3" name="depth" type="radio" checked="checked" /><label for="d3">3</label>
					<input id="d5" value="5" name="depth" type="radio"/><label for="d5">5</label>
					<input id="d10" value="10" name="depth" class="radio" type="radio"/><label for="d10">10</label>
					<input id="d20" value="20" name="depth" class="radio" type="radio"/><label for="d20">20</label>
					</span>
					</fieldset>
				</td>
			</tr>
			<tr>
				<td>Files</td>
				<td class="lt">
					<fieldset>
					<span class="files">
					<input id="p1"    value="1"    name="files" type="radio"/><label for="p1"   >1</label>
					<input id="p10"   value="10"   name="files" type="radio"/><label for="p10"  >10</label>
					<input id="p50"   value="50"   name="files" type="radio"/><label for="p50"  >50</label>
					<input id="p100"  value="100"  name="files" type="radio"/><label for="p100" >100</label>
					<input id="p500"  value="500"  name="files" type="radio" checked="checked"/><label for="p500" >500</label>
					<input id="p1000" value="1000" name="files" type="radio"/><label for="p1000">1000</label>
					<input id="p3000" value="3000" name="files" type="radio"/><label for="p3000">3000</label>
					<input id="all"   value="0"    name="files" class="radio" type="radio" /><label for="all">all</label>
					</span>
					<br/>
					注）実際に解析できるのは<a href="help/license.html#license">ライセンス</a>に依存します
					</fieldset>
				</td>
			</tr>
			<!--/解析条件　Depth　Files-->

			<!--出力条件　detail-page-->
			<tr>
				<td>detail-page</td>
				<td class="lt">
					<fieldset>
					<input type="checkbox" id="detailpage" value="detailpage" name="sw" checked="checked"/>
						<label for="detailpage">ページの詳細情報は作成しない(概要のみ)</label>
						<br/>
						<input type="checkbox" id="toomany" value="toomany" name="sw" checked="checked"/>
						<label for="toomany">上記設定に関わらず50p以上の場合は、詳細情報は作成しない</label>
					</fieldset>
				</td>
			</tr>
			<!--/出力条件　detail-page-->

			<!--analyze option-->
			<tr>
				<td>analyze option</td>
				<td class="lt">
					<fieldset>
					<input id="flashlink" value="flashlink" name="sw" type="checkbox"/>
						<label for="flashlink">Link from Flash(SWF)</label>
					</fieldset>
				</td>
			</tr>
			<!--/analyze option-->

			<!--web capture-->
			<tr>
				<td>page-capture</td>
				<td class="lt">
					<fieldset>
					<input id="htmlthum" value="htmlthum" name="sw" type="checkbox"/>
					<label for="htmlthum">use WebCapture
						<span class="remark">( <a href="help/install.html#webcapture">別途必要</a> )</span>
					</label>
					</fieldset>
				</td>
			</tr>
			<!--/web capture-->

			<!--Check Item Profile　-->
			<tr>
				<td>Check Item Profile</td>
				<td class="lt">
					<fieldset>
					<select name="pro">
						<xsl:apply-templates select="RATING_PROFILE"/>
					</select>
					<a class="proconfig" href="proconfig"><img class="btn" alt="編集" title="編集" src="img/btn_edit.gif"/></a>
					</fieldset>
				</td>
			</tr>
			<!--/Check Item Profile　-->

			<!--ユーザ情報（告知mail用）　notify　Mail address with zip-->
			<tr>
				<td>notify</td>
				<td class="lt">
					<fieldset>
					<input id="notify" value="notify" name="sw" type="checkbox" class="notify"/>
					<label for="mailaddress">Mail address</label>
					<input id="mailaddress" value="" name="mail" type="text" class="mail"/>
					<input id="zip" value="zip" name="sw" type="checkbox" class="zp"/><label for="zip">with ZIP</label>
					</fieldset>
				</td>
			</tr>
			<!--/ユーザ情報（告知mail用）　notify　Mail address with zip-->

			<!--罫線border-->
			<tr>
				<td colspan="2">
				<div class="idpassline"><hr /></div>
				</td>
			</tr>
			<!--罫線border-->

			<!--id password-->
			<tr>
				<td>Login Info</td>
				<td class="lt">
					<fieldset>
					<p class="lid"><label for="loginid">ID : </label>
					<input type="text" name="loginid" value="" id="loginid" class="logid"/></p>
					<p class="pw"><label for="loginpw">PW : </label>
					<input type="text" name="loginpw" value="" id="loginpw" class="logpw"/></p>
					<br class="clear"/>
					<span class="remark">注意）DBに格納されるので、テスト専用ID/PWの使用を推奨</span>
					</fieldset>
				</td>
			</tr>
			<!--/id password-->

			<!--解析条件-->
			<tr class="hrline">
				<td>Inner URL</td>
				<td class="lt">
					<fieldset>
					<input id="innerurl" value="" name="sitedir" type="text"/>
					<br/>
					<span class="remark">ex) http://aa.bb.cc/dd/ を解析する場合には http://aa.bb.cc など</span>
					</fieldset>
				</td>
			</tr>
			<!--/解析条件-->

			</table>
		</div>
		<!--/.option setting-->

	</div>
	<!-- /#content -->

<!--hidden start-->
<!--解析内容　Information-->
<!--HTML information-->			<input id="htmlnode" value="htmlnode" name="sw" type="hidden"/>
<!--CSS information-->			<input id="cssnode" value="cssnode" name="sw" type="hidden"/>
<!--Link from HTML-->			<input id="htmllink" value="htmllink" name="sw" type="hidden"/>
<!--Link from CSS-->			<input id="csslink" value="csslink" name="sw" type="hidden"/>
<!--Image thumbnail-->			<input id="imagethum" value="imagethum" name="sw" type="hidden"/>
<!--capture Flash-->			<input id="flashthum" value="flashthum" name="sw" type="hidden"/>
<!--image-->					<input id="image" value="image" name="sw" type="hidden" disabled="disabled"/>
<!--HTML Title-->				<input id="title" value="title" name="sw" type="hidden" disabled="disabled"/>
<!--Script information-->		<input id="script" value="script" name="sw" type="hidden" disabled="disabled"/>
<!--Form information-->			<input id="form" value="form" name="sw" type="hidden" disabled="disabled"/>
<!--Template information-->		<input id="template" value="template" name="sw" type="hidden" disabled="disabled"/>
<!--Accessibility-->			<input id="x8341" value="x8341" name="sw"  type="hidden" disabled="disabled"/>
<!--Sitemap-->					<input id="sm" value="1" name="sw" class="checkbox" type="hidden" disabled="disabled"/>
<!--Hiremap-->					<input id="hm" value="1" name="sw" class="checkbox" type="hidden" disabled="disabled"/>
<!--Circlemap-->				<input id="cm" value="1" name="sw" class="checkbox" type="hidden" disabled="disabled"/>
<!--/解析内容　Information　Sitemap-->
<!--/hidden start-->
<!--Quality-->
<!--Warning: &lt;table&gt; lacks "summary" attribute を表示しない-->
<input disabled="disabled" id="table_summary" value="off" name="table_summary" type="hidden" checked="checked"/>
<!--The table summary attribute should be used to describe... 等説明を表示しない-->
<input disabled="disabled" id="table_summary_desc" value="off" name="table_summary_desc" type="hidden" checked="checked"/>
<!--tags. HTML elements should be properly nested... 等説明を表示しない-->
<input disabled="disabled" id="tag_nest_desc" value="off" name="tag_nest_desc" type="hidden" checked="checked"/>
<!--For further advice on how to make your pages accessible... 等説明を表示しない-->
<input disabled="disabled" id="more_info_desc" value="off" name="more_info_desc" type="hidden" checked="checked"/>
<!--Warning: img lacks "alt" attribute を表示しない-->
<input disabled="disabled" id="img_alt" value="on" name="img_alt" type="hidden"/>
<!--Warning: &lt;script&gt; lacks "type" attribute を表示しない-->
<input disabled="disabled" id="script_type" value="off" name="script_type" type="hidden" checked="checked"/>
<!--Warning: &lt;link&gt; lacks "type" attribute を表示しない-->
<input disabled="disabled" id="link_type" value="off" name="link_type" type="hidden" checked="checked"/>
<!--Warning: unescaped &amp; or unknown entity "&amp;..." を表示しない-->
<input disabled="disabled" id="param_amp" value="off" name="param_amp" type="hidden" checked="checked"/>
<!--Quality-->
<!--hidden end-->


	</form>
	
		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p class="nrilogo">
			<img src="img/logo_nri.gif" width="300" height="15" 
					title="Powered by Nomura Research Institute,Ltd." 
					alt="Powered by Nomura Research Institute,Ltd." />
			</p>
			<p><a href="help/credit.html" class="credit" target="R2credit">credit</a></p>
		</div>
		<!--/ #footer -->

	</div>
	<!-- /#bgbox-->
</xsl:template>

</xsl:stylesheet>
