<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="Shift_JIS"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template name="tranDQ">
<xsl:param name="str"/>
	<xsl:choose>
	
	<xsl:when test="contains($str,'&quot;')">
		<xsl:value-of select="substring-before($str,'&quot;')"/>
		<xsl:text>&quot;&quot;</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="substring-after($str,'&quot;')"/>
		</xsl:call-template>
	</xsl:when>
	
	<xsl:otherwise>
		<xsl:value-of select="$str"/>
	</xsl:otherwise>
	
	</xsl:choose>

</xsl:template>

<xsl:template name="httpstatus">
<xsl:param name="status"/>
	<xsl:choose>
		<xsl:when test="$status=-1">
			<span class="c0an">未解析</span>
		</xsl:when>
		<xsl:when test="$status=-2">
			unknown-host
		</xsl:when>
		<xsl:when test="$status=-3">
			connect-error
		</xsl:when>
		<xsl:when test="$status=-4">	<!-- mailto,tel 未実装 -->
			<span class="c0in">情報</span>
		</xsl:when>
		<xsl:when test="$status=-5">	<!-- mailto,tel以外 未実装 -->
			<span class="c0uk">不明</span>
		</xsl:when>
		<xsl:when test="(100 &lt;= $status) and ($status &lt; 200)">
			<span class="c100"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(200 &lt;= $status) and ($status &lt; 300)">
			<span class="c200"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(300 &lt;= $status) and ($status &lt; 400)">
			<span class="c300"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(400 &lt;= $status) and ($status &lt; 500)">
			<span class="c400"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(500 &lt;= $status) and ($status &lt; 600)">
			<span class="c500"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="600 &lt;= $status">
			<span class="c500"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:otherwise>
			<span class="c5ov"><xsl:value-of select="$status"/></span>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- JSファイル 1件分の情報 -->
<xsl:template match="CONTENTS_AND_VARIATION">
	<xsl:text>"</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="HTTP_CONTENT_TYPE"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="httpstatus">
			<xsl:with-param name="status" select="HTTP_STATUS"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="URL"/>
		</xsl:call-template>
	<xsl:text>"
</xsl:text>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<xsl:apply-templates select="RidualReportScript"/>
</xsl:template>

<xsl:template match="RidualReportScript">
	<xsl:text>"http-contentType","http-status","URL"
</xsl:text>
	<xsl:apply-templates select="CONTENTS_AND_VARIATION"/>
</xsl:template>

<xsl:template match="ANALYZE_SITE_CONFIG">
	<a target="_blank" href="{START_URIS}">
		<xsl:value-of select="START_URIS"/>
	</a>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="index.html">Overview</a></li>
			<li class="sitemap"><a href="sitemap.html">Sitemap</a></li>
			<li class="pages"><a href="pages.html">Pages</a></li>
			<li class="resources"><a href="resources.html">Resources</a></li>
			<li class="outlink"><a href="outlink.html">OutLink</a></li>
			<li class="form"><a href="form.html">Form</a></li>
			<li class="script"><a href="script.html">Script</a></li>
			<li class="css"><a href="css.html">CSS</a></li>
			<li class="lost"><a href="lost.html">Lost</a></li>
			<li class="quality"><a href="quality.html">Quality</a></li>
			<li class="search"><a href="search.html">Search</a></li>
			<li class="inout"><a href="inout.html">IN/OUT</a></li>
			<li class="report"><a href="report.html">Report</a></li>
		</ul>
	</div>
	<!-- /#menu -->
</xsl:template>

</xsl:stylesheet>
