<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="Shift_JIS"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template name="tranDQ">
<xsl:param name="str"/>
	<xsl:choose>
	
	<xsl:when test="contains($str,'&quot;')">
		<xsl:value-of select="substring-before($str,'&quot;')"/>
		<xsl:text>&quot;&quot;</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="substring-after($str,'&quot;')"/>
		</xsl:call-template>
	</xsl:when>
	
	<xsl:otherwise>
		<xsl:value-of select="$str"/>
	</xsl:otherwise>
	
	</xsl:choose>

</xsl:template>

<xsl:template name="existsstr">
<xsl:param name="exists"/>
	<xsl:choose>
	<xsl:when test="$exists='FILE'">
		<xsl:text>ex-file</xsl:text>
	</xsl:when>
	<xsl:when test="$exists='TAG'">
		<xsl:text>tag</xsl:text>
	</xsl:when>
	<xsl:when test="$exists='BOTH'">
		<xsl:text>file-tag</xsl:text>
	</xsl:when>
	<xsl:otherwise>
		<xsl:text>none</xsl:text>
	</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- 1件分のデータ -->
<xsl:template match="CONTENTS_AND_VARIATION">
	<xsl:text>"</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="URL"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str"
						select="CONTENTS_SUPPLEMENT[NAME='HTML.title']/VALUE"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:value-of select="SIZE"/>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="existsstr">
			<xsl:with-param name="exists" select="EXISTS/STYLE"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="existsstr">
			<xsl:with-param name="exists" select="EXISTS/SCRIPT"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:if test="EXISTS/FRAMESET">1</xsl:if>
	<xsl:text>","</xsl:text>
		<xsl:choose>
			<xsl:when test="CONTENTS_SUPPLEMENT[NAME='HTML.doctype']/VALUE=''">
				<xsl:text>unknown</xsl:text>
			</xsl:when>
			<xsl:when test="CONTENTS_SUPPLEMENT[NAME='HTML.doctype']/VALUE!='NULL'">
				<xsl:call-template name="tranDQ">
					<xsl:with-param name="str" 
						select="CONTENTS_SUPPLEMENT[NAME='HTML.doctype']/VALUE"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>none</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<!-- xsl:call-template name="tranDQ">
			<xsl:with-param name="str"
					select="CONTENTS_SUPPLEMENT[NAME='HTML.doctype']/VALUE"/>
		</xsl:call-template -->
	<xsl:text>","</xsl:text>
		<xsl:choose>
			<xsl:when test="RIDUAL_ENCODING=''">
				<xsl:text>unknown</xsl:text>
			</xsl:when>
			<xsl:when test="RIDUAL_ENCODING!='NULL'">
				<xsl:call-template name="tranDQ">
					<xsl:with-param name="str" select="RIDUAL_ENCODING"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>none</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
<!--
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="RIDUAL_ENCODING"/>
		</xsl:call-template>
-->
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="LAST_MODIFIED"/>
		</xsl:call-template>
	<xsl:text>"
</xsl:text>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<xsl:apply-templates select="RidualReportPages"/>
</xsl:template>

<xsl:template match="RidualReportPages">
	<xsl:text>"URL","title","size","style","script","frame","doctype","charset","date"
</xsl:text>
	<xsl:apply-templates select="CONTENTS_AND_VARIATION"/>
</xsl:template>

</xsl:stylesheet>
