<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="Shift_JIS"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template name="tranDQ">
<xsl:param name="str"/>
	<xsl:choose>
	
	<xsl:when test="contains($str,'&quot;')">
		<xsl:value-of select="substring-before($str,'&quot;')"/>
		<xsl:text>&quot;&quot;</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="substring-after($str,'&quot;')"/>
		</xsl:call-template>
	</xsl:when>
	
	<xsl:otherwise>
		<xsl:value-of select="$str"/>
	</xsl:otherwise>
	
	</xsl:choose>

</xsl:template>

<xsl:template match="COUNT_AND_SIZE">
	<xsl:text>"</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="@key"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="@countAll"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="@countLost"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="@countComplete"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="@countIncomplete"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="@sizeAll"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="@countUnidentified"/>
		</xsl:call-template>
	<xsl:text>"
</xsl:text>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<xsl:apply-templates select="RidualReportOverview"/>
</xsl:template>

<xsl:template match="RidualReportOverview">
	<xsl:apply-templates select="ANALYZE_HISTORY"/>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<xsl:text>"extension","ファイル数","lost数","解析完了数","未解析数","総サイズ","サイズ不明数"
</xsl:text>
	<xsl:apply-templates select="SUM_EXTENSION"/>
</xsl:template>
		
<xsl:template match="SUM_EXTENSION">
	<xsl:apply-templates select="COUNT_AND_SIZE"/>
</xsl:template>

</xsl:stylesheet>
