<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="Shift_JIS"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template name="tranDQ">
<xsl:param name="str"/>
	<xsl:choose>
	
	<xsl:when test="contains($str,'&quot;')">
		<xsl:value-of select="substring-before($str,'&quot;')"/>
		<xsl:text>&quot;&quot;</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="substring-after($str,'&quot;')"/>
		</xsl:call-template>
	</xsl:when>
	
	<xsl:otherwise>
		<xsl:value-of select="$str"/>
	</xsl:otherwise>
	
	</xsl:choose>

</xsl:template>

<xsl:template name="httpstatus">
<xsl:param name="status"/>
	<xsl:choose>
		<xsl:when test="$status=-1">
			<xsl:text>未解析</xsl:text>
		</xsl:when>
		<xsl:when test="$status=-2">
			<xsl:text>unknown-host</xsl:text>
		</xsl:when>
		<xsl:when test="$status=-3">
			<xsl:text>connect-error</xsl:text>
		</xsl:when>
		<xsl:when test="$status=-4">	<!-- mailto,tel 未実装 -->
			<xsl:text>情報</xsl:text>
		</xsl:when>
		<xsl:when test="$status=-5">	<!-- mailto,tel以外 未実装 -->
			<xsl:text>不明</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$status"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- lost contents にリンクしているページ -->
<xsl:template match="PARENT_CONTENTS_AND_VARIATION">
<xsl:param name="url"/>
<xsl:param name="status"/>
	
	<xsl:text>"</xsl:text>
		<xsl:call-template name="httpstatus">
			<xsl:with-param name="status" select="$status"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$url"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="URL"/>
		</xsl:call-template>
	<xsl:text>"
</xsl:text>
</xsl:template>

<!-- lost link 1件分の情報 -->
<xsl:template match="CONTENTS_AND_VARIATION">
	<xsl:apply-templates select="PARENT_CONTENTS_AND_VARIATION">
			<xsl:with-param name="url" select="URL"/>
			<xsl:with-param name="status" select="HTTP_STATUS"/>
	</xsl:apply-templates>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<xsl:apply-templates select="RidualReportLost"/>
</xsl:template>

<xsl:template match="RidualReportLost">
	<xsl:text>"http-status","URL","from-URL"
</xsl:text>
	<xsl:apply-templates select="CONTENTS_AND_VARIATION"/>
</xsl:template>

</xsl:stylesheet>
