<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="Shift_JIS"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template name="tranDQ">
<xsl:param name="str"/>
	<xsl:choose>
	
	<xsl:when test="contains($str,'&quot;')">
		<xsl:value-of select="substring-before($str,'&quot;')"/>
		<xsl:text>&quot;&quot;</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="substring-after($str,'&quot;')"/>
		</xsl:call-template>
	</xsl:when>
	
	<xsl:otherwise>
		<xsl:value-of select="$str"/>
	</xsl:otherwise>
	
	</xsl:choose>

</xsl:template>

<xsl:template name="formcolumn">
<xsl:param name="url"/>
<xsl:param name="isForm"/>
<xsl:param name="name"/>
<xsl:param name="action"/>
<xsl:param name="method"/>
<xsl:param name="type"/>
<xsl:param name="iname"/>
<xsl:param name="value"/>
<xsl:param name="checked"/>
<xsl:param name="vonhtml"/>
	<xsl:text>"</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$url"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$isForm"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$name"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$action"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$method"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$type"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$iname"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$value"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$checked"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$vonhtml"/>
		</xsl:call-template>
	<xsl:text>"
</xsl:text>
</xsl:template>

<!-- <input> -->
<xsl:template match="HTML_ELEMENT[NAME='input']">
<xsl:param name="url"/>
<xsl:param name="isForm"/>
<xsl:param name="name"/>
<xsl:param name="action"/>
<xsl:param name="method"/>
	<xsl:variable name="typeval">input(<xsl:value-of select="HTML_ATTRIBUTE[NAME='type']/VALUE"/>)</xsl:variable>
	<xsl:call-template name="formcolumn">
		<xsl:with-param name="url" select="$url"/>
		<xsl:with-param name="isForm" select="$isForm"/>
		<xsl:with-param name="name" select="$name"/>
		<xsl:with-param name="action" select="$action"/>
		<xsl:with-param name="method" select="$method"/>
		<xsl:with-param name="type" select="$typeval"/>
		<xsl:with-param name="iname" select="HTML_ATTRIBUTE[NAME='name']/VALUE"/>
		<xsl:with-param name="value" select="HTML_ATTRIBUTE[NAME='value']/VALUE"/>
		<xsl:with-param name="checked" select="HTML_ATTRIBUTE[NAME='checked']/VALUE"/>
		<xsl:with-param name="vonhtml" select="''"/>
	</xsl:call-template>
</xsl:template>

<!-- <option> -->
<xsl:template match="HTML_ELEMENT[NAME='option']">
<xsl:param name="url"/>
<xsl:param name="isForm"/>
<xsl:param name="name"/>
<xsl:param name="action"/>
<xsl:param name="method"/>
<xsl:param name="type"/>
<xsl:param name="iname"/>

	<xsl:variable name="optval">"<xsl:value-of select="HTML_ATTRIBUTE[NAME='value']/VALUE"/>"="<xsl:apply-templates select="HTML_TEXT"/>"</xsl:variable>

	<xsl:call-template name="formcolumn">
		<xsl:with-param name="url" select="$url"/>
		<xsl:with-param name="isForm" select="$isForm"/>
		<xsl:with-param name="name" select="$name"/>
		<xsl:with-param name="action" select="$action"/>
		<xsl:with-param name="method" select="$method"/>
		<xsl:with-param name="type" select="$type"/>
		<xsl:with-param name="iname" select="$iname"/>
		<xsl:with-param name="value" select="NAME"/>
		<xsl:with-param name="checked" select="''"/>
		<xsl:with-param name="vonhtml" select="$optval"/>
	</xsl:call-template>
	<p>
	</p>
</xsl:template>

<!-- <select> -->
<xsl:template match="HTML_ELEMENT[NAME='select']">
<xsl:param name="url"/>
<xsl:param name="isForm"/>
<xsl:param name="name"/>
<xsl:param name="action"/>
<xsl:param name="method"/>
	<xsl:variable name="opts" select="count(./HTML_ELEMENT[NAME='option'])"/>
	
	<xsl:variable name="iname" select="HTML_ATTRIBUTE[NAME='name']/VALUE"/>
	
	<xsl:choose>
	<xsl:when test="0 = $opts">	<!-- <option>等の無い空の<select> -->
		<xsl:call-template name="formcolumn">
			<xsl:with-param name="url" select="$url"/>
			<xsl:with-param name="isForm" select="$isForm"/>
			<xsl:with-param name="name" select="$name"/>
			<xsl:with-param name="action" select="$action"/>
			<xsl:with-param name="method" select="$method"/>
			<xsl:with-param name="type" select="NAME"/>
			<xsl:with-param name="iname" select="$iname"/>
			<xsl:with-param name="value" select="''"/>
			<xsl:with-param name="checked" select="''"/>
			<xsl:with-param name="vonhtml" select="''"/>
		</xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
		<xsl:apply-templates select="HTML_ELEMENT[NAME='option']">
			<xsl:with-param name="url" select="$url"/>
			<xsl:with-param name="isForm" select="$isForm"/>
			<xsl:with-param name="name" select="$name"/>
			<xsl:with-param name="action" select="$action"/>
			<xsl:with-param name="method" select="$method"/>
			<xsl:with-param name="type" select="NAME"/>
			<xsl:with-param name="iname" select="$iname"/>
		</xsl:apply-templates>
		<!-- xsl:apply-templates select="HTML_ELEMENT[(NAME='option') and (1=position())]">
			<xsl:with-param name="url" select="$url"/>
			<xsl:with-param name="isForm" select="$isForm"/>
			<xsl:with-param name="name" select="$name"/>
			<xsl:with-param name="action" select="$action"/>
			<xsl:with-param name="method" select="$method"/>
			<xsl:with-param name="type" select="NAME"/>
			<xsl:with-param name="iname" select="$iname"/>
		</xsl:apply-templates>
		
		<xsl:apply-templates select="HTML_ELEMENT[(NAME='option') and (1&lt;position())]">
			<xsl:with-param name="url" select="''"/>
			<xsl:with-param name="isForm" select="''"/>
			<xsl:with-param name="name" select="''"/>
			<xsl:with-param name="action" select="''"/>
			<xsl:with-param name="method" select="''"/>
			<xsl:with-param name="type" select="''"/>
			<xsl:with-param name="iname" select="''"/>
		</xsl:apply-templates -->
	</xsl:otherwise>
	</xsl:choose>
	
</xsl:template>

<!-- <textarea> -->
<xsl:template match="HTML_ELEMENT[NAME='textarea']">
<xsl:param name="url"/>
<xsl:param name="isForm"/>
<xsl:param name="name"/>
<xsl:param name="action"/>
<xsl:param name="method"/>
	<xsl:call-template name="formcolumn">
		<xsl:with-param name="url" select="$url"/>
		<xsl:with-param name="isForm" select="$isForm"/>
		<xsl:with-param name="name" select="$name"/>
		<xsl:with-param name="action" select="$action"/>
		<xsl:with-param name="method" select="$method"/>
		<xsl:with-param name="type" select="NAME"/>
		<xsl:with-param name="iname" select="HTML_ATTRIBUTE[NAME='name']/VALUE"/>
		<xsl:with-param name="value" select="HTML_TEXT"/>
		<xsl:with-param name="checked" select="''"/>
		<xsl:with-param name="vonhtml" select="''"/>
	</xsl:call-template>
</xsl:template>

<!-- <form> (ネスト) -->
<xsl:template match="HTML_ELEMENT[NAME='form']">
<xsl:param name="url"/>
<xsl:param name="isForm"/>
<xsl:param name="name"/>
<xsl:param name="action"/>
<xsl:param name="method"/>
	<xsl:call-template name="formcolumn">
		<xsl:with-param name="url" select="$url"/>
		<xsl:with-param name="isForm" select="$isForm"/>
		<xsl:with-param name="name" select="$name"/>
		<xsl:with-param name="action" select="$action"/>
		<xsl:with-param name="method" select="$method"/>
		<xsl:with-param name="type" select="NAME"/>
		<xsl:with-param name="iname" select="HTML_ATTRIBUTE[NAME='name']/VALUE"/>
		<xsl:with-param name="value" select="''"/>
		<xsl:with-param name="checked" select="''"/>
		<xsl:with-param name="vonhtml" select="''"/>
	</xsl:call-template>
</xsl:template>

<!-- <form> (mode=root) -->
<xsl:template match="HTML_ELEMENT[NAME='form']" mode="root">
<xsl:param name="url"/>
	<xsl:variable name="rows" select="count(./HTML_ELEMENT)"/>
		
	<xsl:variable name="name" select="HTML_ATTRIBUTE[NAME='name']/VALUE"/>
	<xsl:variable name="action" select="HTML_ATTRIBUTE[NAME='action']/VALUE"/>
	<xsl:variable name="method" select="HTML_ATTRIBUTE[NAME='method']/VALUE"/>
	
	<xsl:choose>
	<xsl:when test="0 = $rows">	<!-- input等の無い空の<form> -->
		<!-- <form>情報カラム -->
		<xsl:call-template name="formcolumn">
			<xsl:with-param name="url" select="$url"/>
			<xsl:with-param name="isForm" select="'1'"/>
			<xsl:with-param name="name" select="$name"/>
			<xsl:with-param name="action" select="$action"/>
			<xsl:with-param name="method" select="$method"/>
			<xsl:with-param name="type" select="''"/>
			<xsl:with-param name="iname" select="''"/>
			<xsl:with-param name="value" select="''"/>
			<xsl:with-param name="checked" select="''"/>
			<xsl:with-param name="vonhtml" select="''"/>
		</xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
		<xsl:apply-templates select="HTML_ELEMENT[1]">
			<xsl:with-param name="url" select="$url"/>
			<xsl:with-param name="isForm" select="'1'"/>
			<xsl:with-param name="name" select="$name"/>
			<xsl:with-param name="action" select="$action"/>
			<xsl:with-param name="method" select="$method"/>
		</xsl:apply-templates>
		
		<xsl:apply-templates select="HTML_ELEMENT[1&lt;position()]">
			<xsl:with-param name="url" select="''"/>
			<xsl:with-param name="isForm" select="'1'"/>
			<xsl:with-param name="name" select="$name"/>
			<xsl:with-param name="action" select="$action"/>
			<xsl:with-param name="method" select="$method"/>
		</xsl:apply-templates>
	</xsl:otherwise>
	</xsl:choose>
	
</xsl:template>

<xsl:template match="CONTENTS_AND_VARIATION">
	<xsl:apply-templates select="HTML_ELEMENT[NAME!='form']">
			<xsl:with-param name="url" select="URL"/>
			<xsl:with-param name="isForm" select="''"/>
			<xsl:with-param name="name" select="''"/>
			<xsl:with-param name="action" select="''"/>
			<xsl:with-param name="method" select="''"/>
		</xsl:apply-templates>
	
	<xsl:apply-templates select=".//HTML_ELEMENT[NAME='form']" mode="root">
		<xsl:with-param name="url" select="URL"/>
	</xsl:apply-templates>
</xsl:template>

<!--
 本文はここから
-->
<xsl:template match="/">
	<xsl:apply-templates select="RidualReportForm"/>
</xsl:template>

<xsl:template match="RidualReportForm">
	<xsl:text>"URL","form","name","action","method","type","name","value","checked","valueOnHTML"
</xsl:text>
	<xsl:apply-templates select="CONTENTS_AND_VARIATION"/>
</xsl:template>

</xsl:stylesheet>
