<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="Shift_JIS"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template name="tranDQ">
<xsl:param name="str"/>
	<xsl:choose>
	
	<xsl:when test="contains($str,'&quot;')">
		<xsl:value-of select="substring-before($str,'&quot;')"/>
		<xsl:text>&quot;&quot;</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="substring-after($str,'&quot;')"/>
		</xsl:call-template>
	</xsl:when>
	
	<xsl:otherwise>
		<xsl:value-of select="$str"/>
	</xsl:otherwise>
	
	</xsl:choose>

</xsl:template>

<!-- CONTENTS_CSS_CONDITION群 -->
<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='#']">
	<xsl:value-of select="TYPE"/><xsl:value-of select="VALUE"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='.']">
	<xsl:value-of select="TYPE"/><xsl:value-of select="VALUE"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE=':']">
	<xsl:value-of select="TYPE"/><xsl:value-of select="VALUE"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='And']">
	<xsl:apply-templates select="COMBINATOR_FIRST/CONTENTS_CSS_CONDITION"/>
	<xsl:apply-templates select="COMBINATOR_SECOND/CONTENTS_CSS_CONDITION"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='Lang']">
	<xsl:text>:lang(</xsl:text><xsl:value-of select="LANG"/><xsl:text>)</xsl:text>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='Attribute']">
	<xsl:text>[</xsl:text><xsl:value-of select="NAME"/>
	<xsl:if test="VALUE!='NULL'">
		<xsl:text>=</xsl:text><xsl:value-of select="VALUE"/>
	</xsl:if><xsl:text>]</xsl:text>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='OneOfAttribute']">
	<xsl:text>[</xsl:text><xsl:value-of select="NAME"/>~=<xsl:value-of select="VALUE"/><xsl:text>]</xsl:text>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='BeginHyphenAttribute']">
	<xsl:text>[</xsl:text><xsl:value-of select="NAME"/>|=<xsl:value-of select="VALUE"/><xsl:text>]</xsl:text>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION">
	<xsl:text>未対応condition:</xsl:text>
	<xsl:value-of select="NAME"/>
</xsl:template>

<!-- CONTENTS_CSS_SELECTOR群 -->
<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='ElementNode']">
	<xsl:value-of select="NAME"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='Conditional']">
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR"/>
	<xsl:text> </xsl:text>
	<xsl:apply-templates select="CONTENTS_CSS_CONDITION"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='Descendant']">
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='ancestor']"/>
	<xsl:text> </xsl:text>
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='simple']"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='>']">
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='ancestor']"/>

	<xsl:choose>
		<xsl:when test="CONTENTS_CSS_SELECTOR[RELATIONSHIP='simple' and TYPE!='PseudoElement']">
			<xsl:text>&gt;</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>:</xsl:text>
		</xsl:otherwise>
	</xsl:choose>

	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='simple']"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='+']">
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='selector']"/>
	<xsl:text>+</xsl:text>
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='sibling']"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='PseudoElement']">
	<xsl:value-of select="NAME"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR">
	<xsl:text>未対応selector:</xsl:text>
	<xsl:value-of select="NAME"/>
</xsl:template>

<!-- CONTENTS_CSS_NODES群 -->

<xsl:template match="CONTENTS_CSS_NODES[TYPE='importStyle']">
<xsl:param name="url"/>
<!--
<xsl:param name="media"/>
-->
	<xsl:text>"</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$url"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str"
				select="CSS_NODE_SUPPLEMENT[NAME='importStyle.media']/VALUE"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:text>@import</xsl:text>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="VALUE"/>
		</xsl:call-template>
	<xsl:text>"
</xsl:text>
</xsl:template>

<xsl:template match="CONTENTS_CSS_NODES[TYPE='media']">
<xsl:param name="url"/>
	<xsl:text>"</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$url"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="VALUE"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:text>@media</xsl:text>
	<xsl:text>","</xsl:text>
	<xsl:text>"
</xsl:text>
</xsl:template>


<xsl:template match="CONTENTS_CSS_NODES">
<xsl:param name="url"/>
<!--
<xsl:param name="media"/>
-->
	<xsl:variable name="sel">
		<xsl:for-each select="CONTENTS_CSS_SELECTOR">
			<xsl:if test="1!=position()">
				<xsl:text>,</xsl:text>
			</xsl:if>
			<xsl:apply-templates select="."/>
		</xsl:for-each>
	</xsl:variable>
	
	<xsl:variable name="prop">
		<xsl:for-each select="CONTENTS_CSS_NODES[TYPE='property']">
			<xsl:if test="1!=position()">
				<xsl:text> </xsl:text>
			</xsl:if>
			<xsl:value-of select="VALUE"/>
			<xsl:text>;</xsl:text>
		</xsl:for-each>
	</xsl:variable>
	
	<xsl:text>"</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$url"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
<!--
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$media"/>
		</xsl:call-template>
-->
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$sel"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$prop"/>
		</xsl:call-template>
	<xsl:text>"
</xsl:text>
	
</xsl:template>

<!-- 1件分のデータ -->
<xsl:template match="CONTENTS_AND_VARIATION">
<!--
	<xsl:variable name="media">
		<xsl:for-each select="CONTENTS_CSS_NODES[TYPE='media']">
			<xsl:if test="1!=position()">
				<xsl:text>,</xsl:text>
			</xsl:if>
			<xsl:apply-templates select="."/>
		</xsl:for-each>
	</xsl:variable>
-->	
	<xsl:apply-templates select="CONTENTS_CSS_NODES">
		<xsl:with-param name="url" select="URL"/>
<!--
		<xsl:with-param name="media" select="$media"/>
-->
	</xsl:apply-templates>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<xsl:apply-templates select="RidualReportCSS"/>
</xsl:template>

<xsl:template match="RidualReportCSS">
	<xsl:text>"URL","media","selector","parameter"
</xsl:text>
	<xsl:apply-templates select="CONTENTS_AND_VARIATION"/>
</xsl:template>

</xsl:stylesheet>
