/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.stmt;

import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.c3p0.stmt.StatementCacheKey;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class GooGooStatementCache {
    ConnectionStatementManager cxnStmtMgr;
    HashMap stmtToKey = new HashMap();
    HashMap keyToKeyRec = new HashMap();
    HashSet checkedOut = new HashSet();
    int stmt_count;
    AsynchronousRunner blockingTaskAsyncRunner;

    public GooGooStatementCache(AsynchronousRunner blockingTaskAsyncRunner) {
        this.blockingTaskAsyncRunner = blockingTaskAsyncRunner;
        this.cxnStmtMgr = this.createConnectionStatementManager();
    }

    abstract ConnectionStatementManager createConnectionStatementManager();

    public synchronized Object checkoutStatement(Connection physicalConnection, Method stmtProducingMethod, Object[] args) throws SQLException {
        Object out = null;
        StatementCacheKey key = StatementCacheKey.find(physicalConnection, stmtProducingMethod, args);
        LinkedList l = this.checkoutQueue(key);
        if (l == null || l.isEmpty()) {
            out = this.acquireStatement(physicalConnection, stmtProducingMethod, args);
            if (this.prepareAssimilateNewStatement(physicalConnection)) {
                this.assimilateNewCheckedOutStatement(key, physicalConnection, out);
            }
        } else {
            out = l.get(0);
            l.remove(0);
            if (!this.checkedOut.add(out)) {
                throw new RuntimeException("Internal inconsistency: Checking out a statement marked as already checked out!");
            }
            this.removeStatementFromDeathmarches(out, physicalConnection);
        }
        return out;
    }

    public synchronized void checkinStatement(Object pstmt) throws SQLException {
        if (!this.checkedOut.remove(pstmt)) {
            if (!this.ourResource(pstmt)) {
                this.destroyStatement(pstmt);
            }
            return;
        }
        try {
            this.refreshStatement((PreparedStatement)pstmt);
        }
        catch (Exception e) {
            System.err.println("Problem with checked-in Statement, discarding.");
            e.printStackTrace();
            this.checkedOut.add(pstmt);
            this.removeStatement(pstmt, true);
            return;
        }
        StatementCacheKey key = (StatementCacheKey)this.stmtToKey.get(pstmt);
        if (key == null) {
            throw new RuntimeException("Internal inconsistency: A checked-out statement has no key associated with it!");
        }
        LinkedList l = this.checkoutQueue(key);
        l.add(pstmt);
        this.addStatementToDeathmarches(pstmt, key.physicalConnection);
    }

    public synchronized void checkinAll(Connection pcon) throws SQLException {
        Set stmtSet = this.cxnStmtMgr.statementSet(pcon);
        if (stmtSet != null) {
            Iterator ii = stmtSet.iterator();
            while (ii.hasNext()) {
                Object stmt = ii.next();
                if (!this.checkedOut.contains(stmt)) continue;
                this.checkinStatement(stmt);
            }
        }
    }

    public synchronized void closeAll(Connection pcon) throws SQLException {
        Set cSet = this.cxnStmtMgr.statementSet(pcon);
        if (cSet != null) {
            HashSet stmtSet = new HashSet(cSet);
            Iterator ii = stmtSet.iterator();
            while (ii.hasNext()) {
                Object stmt = ii.next();
                this.removeStatement(stmt, true);
            }
        }
    }

    public synchronized void close() throws SQLException {
        Iterator ii = this.stmtToKey.keySet().iterator();
        while (ii.hasNext()) {
            this.synchronousDestroyStatement(ii.next());
        }
        this.cxnStmtMgr = null;
        this.stmtToKey = null;
        this.keyToKeyRec = null;
        this.checkedOut = null;
        this.stmt_count = -1;
    }

    private void destroyStatement(final Object pstmt) {
        Runnable r = new Runnable(){

            public void run() {
                StatementUtils.attemptClose((PreparedStatement)pstmt);
            }
        };
        this.blockingTaskAsyncRunner.postRunnable(r);
    }

    private void synchronousDestroyStatement(Object pstmt) {
        StatementUtils.attemptClose((PreparedStatement)pstmt);
    }

    abstract boolean prepareAssimilateNewStatement(Connection var1);

    abstract void addStatementToDeathmarches(Object var1, Connection var2);

    abstract void removeStatementFromDeathmarches(Object var1, Connection var2);

    final int countCachedStatements() {
        return this.stmtToKey.size();
    }

    private void assimilateNewCheckedOutStatement(StatementCacheKey key, Connection pConn, Object ps) {
        this.stmtToKey.put(ps, key);
        HashSet ks = this.keySet(key);
        if (ks == null) {
            this.keyToKeyRec.put(key, new KeyRec());
        }
        this.keySet(key).add(ps);
        this.cxnStmtMgr.addStatementForConnection(ps, pConn);
        ++this.stmt_count;
        this.checkedOut.add(ps);
    }

    private void removeStatement(Object ps, boolean force_destroy) {
        StatementCacheKey sck = (StatementCacheKey)this.stmtToKey.remove(ps);
        this.removeFromKeySet(sck, ps);
        Connection pConn = sck.physicalConnection;
        if (!this.checkedOut.contains(ps)) {
            this.removeStatementFromDeathmarches(ps, pConn);
            this.removeFromCheckoutQueue(sck, ps);
            this.destroyStatement(ps);
        } else {
            this.checkedOut.remove(ps);
            if (force_destroy) {
                this.destroyStatement(ps);
            }
        }
        boolean check = this.cxnStmtMgr.removeStatementForConnection(ps, pConn);
        if (!check) {
            new Exception("WARNING: removed a statement that apparently wasn't in a statement set!!!").printStackTrace();
        }
        --this.stmt_count;
    }

    private Object acquireStatement(final Connection pConn, final Method stmtProducingMethod, final Object[] args) throws SQLException {
        try {
            final Object[] outHolder = new Object[1];
            final SQLException[] exceptionHolder = new SQLException[1];
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    GooGooStatementCache gooGooStatementCache;
                    try {
                        try {
                            outHolder[0] = stmtProducingMethod.invoke((Object)pConn, args);
                        }
                        catch (InvocationTargetException e) {
                            Throwable targetException = e.getTargetException();
                            exceptionHolder[0] = targetException instanceof SQLException ? (SQLException)targetException : SqlUtils.toSQLException(targetException);
                            Object var4_2 = null;
                            GooGooStatementCache gooGooStatementCache3 = GooGooStatementCache.this;
                            synchronized (gooGooStatementCache3) {
                                GooGooStatementCache.this.notifyAll();
                                return;
                            }
                        }
                        catch (Exception e) {
                            exceptionHolder[0] = SqlUtils.toSQLException(e);
                            Object var4_3 = null;
                            GooGooStatementCache gooGooStatementCache4 = GooGooStatementCache.this;
                            synchronized (gooGooStatementCache4) {
                                GooGooStatementCache.this.notifyAll();
                                return;
                            }
                        }
                        Object var4_1 = null;
                        gooGooStatementCache = GooGooStatementCache.this;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        GooGooStatementCache gooGooStatementCache2 = GooGooStatementCache.this;
                        synchronized (gooGooStatementCache2) {
                            GooGooStatementCache.this.notifyAll();
                            throw throwable;
                        }
                    }
                    synchronized (gooGooStatementCache) {
                        GooGooStatementCache.this.notifyAll();
                        return;
                    }
                }
            };
            this.blockingTaskAsyncRunner.postRunnable(r);
            while (outHolder[0] == null && exceptionHolder[0] == null) {
                this.wait();
            }
            if (exceptionHolder[0] != null) {
                throw exceptionHolder[0];
            }
            Object out = outHolder[0];
            return out;
        }
        catch (InterruptedException e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    private KeyRec keyRec(StatementCacheKey key) {
        return (KeyRec)this.keyToKeyRec.get(key);
    }

    private HashSet keySet(StatementCacheKey key) {
        KeyRec rec = this.keyRec(key);
        return rec == null ? null : rec.allStmts;
    }

    private boolean removeFromKeySet(StatementCacheKey key, Object pstmt) {
        HashSet stmtSet = this.keySet(key);
        boolean out = stmtSet.remove(pstmt);
        if (stmtSet.isEmpty() && this.checkoutQueue(key).isEmpty()) {
            this.keyToKeyRec.remove(key);
        }
        return out;
    }

    private LinkedList checkoutQueue(StatementCacheKey key) {
        KeyRec rec = this.keyRec(key);
        return rec == null ? null : rec.checkoutQueue;
    }

    private boolean removeFromCheckoutQueue(StatementCacheKey key, Object pstmt) {
        LinkedList q = this.checkoutQueue(key);
        boolean out = q.remove(pstmt);
        if (q.isEmpty() && this.keySet(key).isEmpty()) {
            this.keyToKeyRec.remove(key);
        }
        return out;
    }

    private boolean ourResource(Object ps) {
        return this.stmtToKey.keySet().contains(ps);
    }

    private void refreshStatement(PreparedStatement ps) throws Exception {
        ps.clearParameters();
    }

    private void printStats() {
        int total_size = this.countCachedStatements();
        int checked_out_size = this.checkedOut.size();
        int num_connections = this.cxnStmtMgr.getNumConnectionsWithCachedStatements();
        int num_keys = this.keyToKeyRec.size();
        System.err.print(this.getClass().getName() + " stats -- ");
        System.err.print("total size: " + total_size);
        System.err.print("; checked out: " + checked_out_size);
        System.err.print("; num connections: " + num_connections);
        System.err.println("; num keys: " + num_keys);
    }

    protected final class DeathmarchConnectionStatementManager
    extends ConnectionStatementManager {
        Map cxnsToDms = new HashMap();

        protected DeathmarchConnectionStatementManager() {
        }

        public void addStatementForConnection(Object ps, Connection pcon) {
            super.addStatementForConnection(ps, pcon);
            Deathmarch dm = (Deathmarch)this.cxnsToDms.get(pcon);
            if (dm == null) {
                dm = new Deathmarch();
                this.cxnsToDms.put(pcon, dm);
            }
        }

        public boolean removeStatementForConnection(Object ps, Connection pcon) {
            boolean out = super.removeStatementForConnection(ps, pcon);
            if (out && this.statementSet(pcon) == null) {
                this.cxnsToDms.remove(pcon);
            }
            return out;
        }

        public Deathmarch getDeathmarch(Connection pcon) {
            return (Deathmarch)this.cxnsToDms.get(pcon);
        }
    }

    protected static final class SimpleConnectionStatementManager
    extends ConnectionStatementManager {
        protected SimpleConnectionStatementManager() {
        }
    }

    protected static abstract class ConnectionStatementManager {
        Map cxnToStmtSets = new HashMap();

        protected ConnectionStatementManager() {
        }

        public int getNumConnectionsWithCachedStatements() {
            return this.cxnToStmtSets.size();
        }

        public Set statementSet(Connection pcon) {
            return (Set)this.cxnToStmtSets.get(pcon);
        }

        public int getNumStatementsForConnection(Connection pcon) {
            Set stmtSet = this.statementSet(pcon);
            return stmtSet == null ? 0 : stmtSet.size();
        }

        public void addStatementForConnection(Object ps, Connection pcon) {
            HashSet<Object> stmtSet = this.statementSet(pcon);
            if (stmtSet == null) {
                stmtSet = new HashSet<Object>();
                this.cxnToStmtSets.put(pcon, stmtSet);
            }
            stmtSet.add(ps);
        }

        public boolean removeStatementForConnection(Object ps, Connection pcon) {
            boolean out;
            Set stmtSet = this.statementSet(pcon);
            if (stmtSet != null) {
                out = stmtSet.remove(ps);
                if (stmtSet.isEmpty()) {
                    this.cxnToStmtSets.remove(pcon);
                }
            } else {
                out = false;
            }
            return out;
        }
    }

    protected class Deathmarch {
        TreeMap longsToStmts = new TreeMap();
        HashMap stmtsToLongs = new HashMap();
        long last_long = -1L;

        protected Deathmarch() {
        }

        public void deathmarchStatement(Object ps) {
            Long old = (Long)this.stmtsToLongs.get(ps);
            if (old != null) {
                throw new RuntimeException("Internal inconsistency: A statement is being double-deathmatched. no checked-out statements should be in a deathmarch already; no already checked-in statement should be deathmarched!");
            }
            Long youth = this.getNextLong();
            this.stmtsToLongs.put(ps, youth);
            this.longsToStmts.put(youth, ps);
        }

        public void undeathmarchStatement(Object ps) {
            Long old = (Long)this.stmtsToLongs.remove(ps);
            if (old == null) {
                throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
            }
            Object check = this.longsToStmts.remove(old);
            if (old == null) {
                throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
            }
        }

        public boolean cullNext() {
            if (this.longsToStmts.isEmpty()) {
                return false;
            }
            Long l = (Long)this.longsToStmts.firstKey();
            Object ps = this.longsToStmts.get(l);
            GooGooStatementCache.this.removeStatement(ps, true);
            if (this.contains(ps)) {
                throw new RuntimeException("Inconsistency!!! Statement culled from deathmarch failed to be removed by removeStatement( ... )!");
            }
            return true;
        }

        public boolean contains(Object ps) {
            return this.stmtsToLongs.keySet().contains(ps);
        }

        public int size() {
            return this.longsToStmts.size();
        }

        private Long getNextLong() {
            return new Long(++this.last_long);
        }
    }

    private static class KeyRec {
        HashSet allStmts = new HashSet();
        LinkedList checkoutQueue = new LinkedList();

        private KeyRec() {
        }
    }
}

